/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ChangePropertyValue
extends Recipe {
    @Option(displayName="Property key", example="management.metrics.binders.files.enabled")
    private final String propertyKey;
    @Option(displayName="New value", example="false")
    private final String newValue;

    public String getDisplayName() {
        return "Change properties file property value";
    }

    public String getDescription() {
        return "Change a property value leaving the key intact.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyValueVisitor<ExecutionContext>();
    }

    public ChangePropertyValue(String propertyKey, String newValue) {
        this.propertyKey = propertyKey;
        this.newValue = newValue;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyValue(propertyKey=" + this.getPropertyKey() + ", newValue=" + this.getNewValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyValue)) {
            return false;
        }
        ChangePropertyValue other = (ChangePropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }

    public class ChangePropertyValueVisitor<P>
    extends PropertiesVisitor<P> {
        @Override
        public Properties visitEntry(Properties.Entry entry, P p) {
            if (entry.getKey().equals(ChangePropertyValue.this.propertyKey) && !entry.getValue().getText().equals(ChangePropertyValue.this.newValue)) {
                entry = entry.withValue(entry.getValue().withText(ChangePropertyValue.this.newValue));
            }
            return super.visitEntry(entry, p);
        }
    }
}

