/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Formatting;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesSourceVisitor;
import org.openrewrite.properties.internal.PrintProperties;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Properties
extends Serializable,
Tree {
    default public String print() {
        return (String)new PrintProperties().visit(this);
    }

    default public <R> R accept(SourceVisitor<R> v) {
        return (R)(v instanceof PropertiesSourceVisitor ? this.acceptProperties((PropertiesSourceVisitor)v) : v.defaultTo(null));
    }

    default public <R> R acceptProperties(PropertiesSourceVisitor<R> v) {
        return (R)v.defaultTo(null);
    }

    public static class Comment
    implements Content {
        private final UUID id;
        private final String message;
        private final Formatting formatting;
        private final Markers markers;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Comment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "message", "formatting", "markers"})
        public Comment(UUID id, String message, Formatting formatting, Markers markers) {
            this.id = id;
            this.message = message;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "Properties.Comment(id=" + this.getId() + ", message=" + this.getMessage() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Comment withMessage(String message) {
            return this.message == message ? this : new Comment(this.id, message, this.formatting, this.markers);
        }

        public Comment withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Comment(this.id, this.message, formatting, this.markers);
        }

        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.message, this.formatting, markers);
        }
    }

    public static class Entry
    implements Content {
        private final UUID id;
        private final String key;
        private final String value;
        private final Formatting equalsFormatting;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptProperties(PropertiesSourceVisitor<R> v) {
            return v.visitEntry(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "key", "value", "equalsFormatting", "formatting", "markers"})
        public Entry(UUID id, String key, String value, Formatting equalsFormatting, Formatting formatting, Markers markers) {
            this.id = id;
            this.key = key;
            this.value = value;
            this.equalsFormatting = equalsFormatting;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Formatting getEqualsFormatting() {
            return this.equalsFormatting;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "Properties.Entry(id=" + this.getId() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", equalsFormatting=" + this.getEqualsFormatting() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Entry withKey(String key) {
            return this.key == key ? this : new Entry(this.id, key, this.value, this.equalsFormatting, this.formatting, this.markers);
        }

        public Entry withValue(String value) {
            return this.value == value ? this : new Entry(this.id, this.key, value, this.equalsFormatting, this.formatting, this.markers);
        }

        public Entry withEqualsFormatting(Formatting equalsFormatting) {
            return this.equalsFormatting == equalsFormatting ? this : new Entry(this.id, this.key, this.value, equalsFormatting, this.formatting, this.markers);
        }

        public Entry withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Entry(this.id, this.key, this.value, this.equalsFormatting, formatting, this.markers);
        }

        public Entry withMarkers(Markers markers) {
            return this.markers == markers ? this : new Entry(this.id, this.key, this.value, this.equalsFormatting, this.formatting, markers);
        }
    }

    public static interface Content
    extends Properties {
    }

    @JsonIgnoreProperties(value={"styles"})
    public static class File
    implements Properties,
    SourceFile {
        private final UUID id;
        private final String sourcePath;
        private final List<Content> content;
        private final Formatting formatting;
        private final Markers markers;

        public Formatting getFormatting() {
            return this.formatting;
        }

        @Override
        public <R> R acceptProperties(PropertiesSourceVisitor<R> v) {
            return v.visitFile(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File other = (File)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof File;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "sourcePath", "content", "formatting", "markers"})
        public File(UUID id, String sourcePath, List<Content> content, Formatting formatting, Markers markers) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.content = content;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public List<Content> getContent() {
            return this.content;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "Properties.File(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", content=" + this.getContent() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public File withContent(List<Content> content) {
            return this.content == content ? this : new File(this.id, this.sourcePath, content, this.formatting, this.markers);
        }

        public File withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new File(this.id, this.sourcePath, this.content, formatting, this.markers);
        }

        public File withMarkers(Markers markers) {
            return this.markers == markers ? this : new File(this.id, this.sourcePath, this.content, this.formatting, markers);
        }
    }
}

