/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.openrewrite.SourceFile;

public class SourceFileStream
implements Stream<SourceFile> {
    private final Stream<SourceFile> delegate;
    private final String group;
    private final Consumer<String> peekGroup;
    private final int size;

    public static SourceFileStream build(String group, Consumer<String> peekGroup) {
        HashSet seenGroup = new HashSet();
        return new SourceFileStream(Stream.empty(), 0, group, g -> {
            if (seenGroup.add(g)) {
                peekGroup.accept((String)g);
            }
        });
    }

    private SourceFileStream(Stream<SourceFile> delegate, int size, String group, Consumer<String> peekGroup) {
        this.size = size;
        this.delegate = delegate.peek((? super T sf) -> peekGroup.accept(group));
        this.group = group;
        this.peekGroup = peekGroup;
    }

    public SourceFileStream concat(SourceFileStream sourceFileStream) {
        return new SourceFileStream(Stream.concat(this.delegate, sourceFileStream), sourceFileStream.size + this.size, this.group, this.peekGroup);
    }

    public SourceFileStream concat(Stream<SourceFile> sourceFileStream, int size) {
        return new SourceFileStream(Stream.concat(this.delegate, sourceFileStream), size + this.size, this.group, this.peekGroup);
    }

    public int size() {
        return this.size;
    }

    @Override
    public Stream<SourceFile> filter(Predicate<? super SourceFile> arg0) {
        return this.delegate.filter(arg0);
    }

    @Override
    public <R> Stream<R> map(Function<? super SourceFile, ? extends R> arg0) {
        return this.delegate.map(arg0);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super SourceFile> arg0) {
        return this.delegate.mapToInt(arg0);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super SourceFile> arg0) {
        return this.delegate.mapToLong(arg0);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super SourceFile> arg0) {
        return this.delegate.mapToDouble(arg0);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super SourceFile, ? extends Stream<? extends R>> arg0) {
        return this.delegate.flatMap(arg0);
    }

    @Override
    public IntStream flatMapToInt(Function<? super SourceFile, ? extends IntStream> arg0) {
        return this.delegate.flatMapToInt(arg0);
    }

    @Override
    public LongStream flatMapToLong(Function<? super SourceFile, ? extends LongStream> arg0) {
        return this.delegate.flatMapToLong(arg0);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super SourceFile, ? extends DoubleStream> arg0) {
        return this.delegate.flatMapToDouble(arg0);
    }

    @Override
    public Stream<SourceFile> distinct() {
        return this.delegate.distinct();
    }

    @Override
    public Stream<SourceFile> sorted() {
        return this.delegate.sorted();
    }

    @Override
    public Stream<SourceFile> sorted(Comparator<? super SourceFile> arg0) {
        return this.delegate.sorted(arg0);
    }

    @Override
    public Stream<SourceFile> peek(Consumer<? super SourceFile> arg0) {
        return this.delegate.peek(arg0);
    }

    @Override
    public Stream<SourceFile> limit(long arg0) {
        return this.delegate.limit(arg0);
    }

    @Override
    public Stream<SourceFile> skip(long arg0) {
        return this.delegate.skip(arg0);
    }

    @Override
    public void forEach(Consumer<? super SourceFile> arg0) {
        this.delegate.forEach(arg0);
    }

    @Override
    public void forEachOrdered(Consumer<? super SourceFile> arg0) {
        this.delegate.forEachOrdered(arg0);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> arg0) {
        return this.delegate.toArray(arg0);
    }

    @Override
    public SourceFile reduce(SourceFile arg0, BinaryOperator<SourceFile> arg1) {
        return this.delegate.reduce(arg0, arg1);
    }

    @Override
    public Optional<SourceFile> reduce(BinaryOperator<SourceFile> arg0) {
        return this.delegate.reduce(arg0);
    }

    @Override
    public <U> U reduce(U arg0, BiFunction<U, ? super SourceFile, U> arg1, BinaryOperator<U> arg2) {
        return this.delegate.reduce(arg0, arg1, arg2);
    }

    @Override
    public <R> R collect(Supplier<R> arg0, BiConsumer<R, ? super SourceFile> arg1, BiConsumer<R, R> arg2) {
        return this.delegate.collect(arg0, arg1, arg2);
    }

    @Override
    public <R, A> R collect(Collector<? super SourceFile, A, R> arg0) {
        return this.delegate.collect(arg0);
    }

    @Override
    public Optional<SourceFile> min(Comparator<? super SourceFile> arg0) {
        return this.delegate.min(arg0);
    }

    @Override
    public Optional<SourceFile> max(Comparator<? super SourceFile> arg0) {
        return this.delegate.max(arg0);
    }

    @Override
    public long count() {
        return this.delegate.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super SourceFile> arg0) {
        return this.delegate.anyMatch(arg0);
    }

    @Override
    public boolean allMatch(Predicate<? super SourceFile> arg0) {
        return this.delegate.allMatch(arg0);
    }

    @Override
    public boolean noneMatch(Predicate<? super SourceFile> arg0) {
        return this.delegate.noneMatch(arg0);
    }

    @Override
    public Optional<SourceFile> findFirst() {
        return this.delegate.findFirst();
    }

    @Override
    public Optional<SourceFile> findAny() {
        return this.delegate.findAny();
    }

    @Override
    public Iterator<SourceFile> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Spliterator<SourceFile> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    @Override
    public Stream<SourceFile> sequential() {
        return (Stream)this.delegate.sequential();
    }

    @Override
    public Stream<SourceFile> parallel() {
        return (Stream)this.delegate.parallel();
    }

    @Override
    public Stream<SourceFile> unordered() {
        return (Stream)this.delegate.unordered();
    }

    @Override
    public Stream<SourceFile> onClose(Runnable arg0) {
        return (Stream)this.delegate.onClose(arg0);
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

