/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.Nullable;

public class RemoteException
extends RuntimeException {
    @Nullable
    private final String sanitizedStackTrace;
    private final List<String> fixSuggestions;

    RemoteException(String message, @Nullable String sanitizedStackTrace, String[] fixSuggestions) {
        super(message);
        this.sanitizedStackTrace = sanitizedStackTrace;
        this.fixSuggestions = new ArrayList<String>(Arrays.asList(fixSuggestions));
    }

    public static Builder builder(String message, String ... stackTracePrefixFilter) {
        return new Builder(message, stackTracePrefixFilter);
    }

    public static String sanitizeStackTrace(Throwable t, String ... stackTracePrefixFilter) {
        StringJoiner sanitized = new StringJoiner("\n");
        int causeDepth = 0;
        Throwable tt = t;
        while (tt != null) {
            sanitized.add((causeDepth == 0 ? "" : "Caused by ") + tt.getClass().getName() + ": " + tt.getLocalizedMessage());
            RemoteException.sanitizeStackElements(sanitized, tt.getStackTrace(), stackTracePrefixFilter);
            tt = tt.getCause();
            ++causeDepth;
        }
        return sanitized.toString();
    }

    private static void sanitizeStackElements(StringJoiner sanitized, StackTraceElement[] stackTraceElements, String[] stackTracePrefixFilter) {
        StackTraceElement stackTraceElement;
        String stackTraceClass;
        int i = 0;
        StackTraceElement[] stackTraceElementArray = stackTraceElements;
        int n = stackTraceElementArray.length;
        for (int j = 0; j < n && !(stackTraceClass = (stackTraceElement = stackTraceElementArray[j]).getClassName()).startsWith("java.util.stream") && !stackTraceClass.startsWith("java.net.Inet"); ++j) {
            for (String filter : stackTracePrefixFilter) {
                if (stackTraceClass.startsWith(filter)) break;
            }
            if (i++ >= 8) {
                sanitized.add("  ...");
                break;
            }
            sanitized.add("  " + stackTraceElement);
        }
    }

    public String encode() {
        Base64.Encoder base64 = Base64.getEncoder();
        return base64.encodeToString(this.getMessage().getBytes(StandardCharsets.UTF_8)) + "\n" + (this.sanitizedStackTrace == null ? "null" : base64.encodeToString(this.sanitizedStackTrace.getBytes(StandardCharsets.UTF_8))) + "\n" + (this.fixSuggestions.isEmpty() ? "null" : this.fixSuggestions.stream().map(s -> base64.encodeToString(s.getBytes(StandardCharsets.UTF_8))).collect(Collectors.joining(",")));
    }

    public static RemoteException decode(String encoded) {
        Base64.Decoder base64 = Base64.getDecoder();
        String[] lines = encoded.split("\n");
        return new RemoteException(new String(base64.decode(lines[0]), StandardCharsets.UTF_8), lines[1].equals("null") ? null : new String(base64.decode(lines[1]), StandardCharsets.UTF_8), lines[2].equals("null") ? new String[]{} : (String[])Arrays.stream(lines[2].split(",")).map(s -> new String(base64.decode((String)s), StandardCharsets.UTF_8)).toArray(String[]::new));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteException that = (RemoteException)o;
        return Objects.equals(this.sanitizedStackTrace, that.sanitizedStackTrace) && Objects.equals(this.fixSuggestions, that.fixSuggestions);
    }

    public int hashCode() {
        int result = Objects.hash(this.sanitizedStackTrace);
        result = 31 * result + Objects.hashCode(this.fixSuggestions);
        return result;
    }

    public String getSanitizedStackTrace() {
        return this.sanitizedStackTrace;
    }

    public List<String> getFixSuggestions() {
        return this.fixSuggestions;
    }

    public static class Builder {
        private final String message;
        private final List<String> fixSuggestions = new ArrayList<String>();
        private String sanitizedStackTrace;

        public Builder(String message, String ... stackTracePrefixFilter) {
            this.message = message;
            StringJoiner sanitized = new StringJoiner("\n");
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement[] shortenedStackTrace = new StackTraceElement[stackTrace.length - 3];
            System.arraycopy(stackTrace, 3, shortenedStackTrace, 0, stackTrace.length - 3);
            RemoteException.sanitizeStackElements(sanitized, shortenedStackTrace, stackTracePrefixFilter);
            this.sanitizedStackTrace = sanitized.toString();
        }

        public Builder cause(Throwable t, String ... stackTracePrefixFilter) {
            this.sanitizedStackTrace = RemoteException.sanitizeStackTrace(t, stackTracePrefixFilter);
            return this;
        }

        public Builder fixSuggestions(String ... fixSuggestions) {
            this.fixSuggestions.addAll(Arrays.asList(fixSuggestions));
            return this;
        }

        public RemoteException build() {
            return new RemoteException(this.message, this.sanitizedStackTrace, this.fixSuggestions.toArray(new String[0]));
        }
    }
}

