/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonParser;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.protobuf.ProtoParser;
import org.openrewrite.shaded.jgit.ignore.IgnoreNode;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class OmniParser
implements Parser {
    private static final Collection<String> DEFAULT_IGNORED_DIRECTORIES = Arrays.asList("build", "target", "out", ".gradle", ".idea", ".project", "node_modules", ".git", ".metadata", ".DS_Store", ".moderne");
    private final Collection<Path> exclusions;
    private final Collection<PathMatcher> exclusionMatchers;
    private final int sizeThresholdMb;
    private final Collection<Path> excludedDirectories;
    private final boolean parallel;
    private final List<Parser> parsers;
    private final Consumer<Integer> onParse;

    public static List<Parser> defaultResourceParsers() {
        return new ArrayList<Parser>(Arrays.asList(new JsonParser(), new XmlParser(), new YamlParser(), new PropertiesParser(), new ProtoParser(), HclParser.builder().build(), GroovyParser.builder().build(), GradleParser.builder().build()));
    }

    public Stream<SourceFile> parseAll(Path rootDir) {
        return this.parse(this.acceptedPaths(rootDir), rootDir, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parse(Iterable<Path> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        int count = 0;
        for (Path ignored : sourceFiles) {
            ++count;
        }
        this.onParse.accept(count);
        return super.parse(sourceFiles, relativeTo, ctx);
    }

    public List<Path> acceptedPaths(Path rootDir) {
        return this.acceptedPaths(rootDir, rootDir);
    }

    public List<Path> acceptedPaths(final Path rootDir, final Path searchDir) {
        if (!Files.exists(searchDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        final ArrayList<Path> parseable = new ArrayList<Path>();
        final LinkedHashMap gitignoreStack = new LinkedHashMap();
        try {
            Files.walkFileTree(searchDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    OmniParser.this.loadGitignore(dir).ifPresent(ignoreNode -> gitignoreStack.put(dir, ignoreNode));
                    return OmniParser.this.isExcluded(dir, rootDir) || OmniParser.this.isIgnoredDirectory(dir, searchDir) || OmniParser.this.excludedDirectories.contains(dir) || OmniParser.this.isGitignored(gitignoreStack.values(), dir, searchDir) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (!(attrs.isOther() || attrs.isSymbolicLink() || OmniParser.this.isExcluded(file, rootDir) || OmniParser.this.isGitignored(gitignoreStack.values(), file, searchDir) || OmniParser.this.isOverSizeThreshold(attrs.size()))) {
                        for (Parser parser : OmniParser.this.parsers) {
                            if (!parser.accept(file)) continue;
                            parseable.add(file);
                            break;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    gitignoreStack.remove(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return parseable;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return StreamSupport.stream(sources.spliterator(), this.parallel).flatMap(input -> {
            Path path = input.getPath();
            for (Parser parser : this.parsers) {
                if (!parser.accept(path)) continue;
                return parser.parseInputs(Collections.singletonList(input), relativeTo, ctx);
            }
            return Stream.empty();
        });
    }

    public boolean accept(Path path) {
        for (Parser parser : this.parsers) {
            if (!parser.accept(path)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return Paths.get("resource.me", new String[0]);
    }

    private boolean isOverSizeThreshold(long fileSize) {
        return this.sizeThresholdMb > 0 && fileSize > (long)this.sizeThresholdMb * 1024L * 1024L;
    }

    boolean isExcluded(Path path, Path rootDir) {
        Path relativePath = rootDir.relativize(path);
        if (this.exclusions.contains(relativePath)) {
            return true;
        }
        for (PathMatcher excluded : this.exclusionMatchers) {
            if (!excluded.matches(relativePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnoredDirectory(Path path, Path rootDir) {
        for (Path pathSegment : rootDir.relativize(path)) {
            if (!DEFAULT_IGNORED_DIRECTORIES.contains(pathSegment.toString())) continue;
            return true;
        }
        return false;
    }

    private Optional<IgnoreNode> loadGitignore(Path dir) {
        Path gitignore = dir.resolve(".gitignore");
        if (!Files.exists(gitignore, new LinkOption[0])) {
            return Optional.empty();
        }
        IgnoreNode ignoreNode = new IgnoreNode();
        try (InputStream is = Files.newInputStream(gitignore, new OpenOption[0]);){
            ignoreNode.parse(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading '" + gitignore + "'", e);
        }
        return Optional.of(ignoreNode);
    }

    private boolean isGitignored(Collection<IgnoreNode> gitignoreStack, Path path, Path rootDir) {
        for (IgnoreNode ignoreNode : gitignoreStack) {
            Boolean result = ignoreNode.checkIgnored(rootDir.relativize(path).toFile().getPath(), path.toFile().isDirectory());
            if (result == null) continue;
            return result;
        }
        return false;
    }

    public static Builder builder(Parser ... parsers) {
        return OmniParser.builder(Arrays.asList(parsers), new Parser[0]);
    }

    public static Builder builder(List<Parser> parsers, Parser ... more) {
        if (more.length > 0) {
            ArrayList<Parser> all = new ArrayList<Parser>(parsers);
            all.addAll(Arrays.asList(more));
            parsers = all;
        }
        return new Builder(parsers);
    }

    private OmniParser(Collection<Path> exclusions, Collection<PathMatcher> exclusionMatchers, int sizeThresholdMb, Collection<Path> excludedDirectories, boolean parallel, List<Parser> parsers, Consumer<Integer> onParse) {
        this.exclusions = exclusions;
        this.exclusionMatchers = exclusionMatchers;
        this.sizeThresholdMb = sizeThresholdMb;
        this.excludedDirectories = excludedDirectories;
        this.parallel = parallel;
        this.parsers = parsers;
        this.onParse = onParse;
    }

    public static class Builder
    extends Parser.Builder {
        private Collection<Path> exclusions = Collections.emptyList();
        private Collection<PathMatcher> exclusionMatchers = Collections.emptyList();
        private int sizeThresholdMb = 10;
        private Collection<Path> excludedDirectories = Collections.emptyList();
        private boolean parallel;
        private Consumer<Integer> onParse = inputCount -> {};
        private final List<Parser> parsers;

        public Builder(List<Parser> parsers) {
            super(SourceFile.class);
            this.parsers = parsers;
        }

        public Builder exclusions(Collection<Path> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public Builder exclusionMatchers(Collection<PathMatcher> exclusions) {
            this.exclusionMatchers = exclusions;
            return this;
        }

        public Builder exclusionMatchers(Path basePath, Iterable<String> exclusions) {
            return this.exclusionMatchers(StreamSupport.stream(exclusions.spliterator(), false).map(o -> basePath.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList()));
        }

        public Builder sizeThresholdMb(int sizeThresholdMb) {
            this.sizeThresholdMb = sizeThresholdMb;
            return this;
        }

        public Builder excludedDirectories(Collection<Path> excludedDirectories) {
            this.excludedDirectories = excludedDirectories;
            return this;
        }

        public Builder onParse(Consumer<Integer> onParse) {
            this.onParse = onParse;
            return this;
        }

        public Builder parallel(boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        public OmniParser build() {
            return new OmniParser(this.exclusions, this.exclusionMatchers, this.sizeThresholdMb, this.excludedDirectories, this.parallel, this.parsers, this.onParse);
        }

        public String getDslName() {
            return "omni";
        }
    }
}

