/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.nio.file.Path;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class AddPlugin
extends Recipe {
    private static final XPathMatcher BUILD_MATCHER = new XPathMatcher("/project/build");
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;
    @Option(displayName="Version", description="A fixed version of the plugin to add.", example="1.0.0", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Configuration", description="Optional plugin configuration provided as raw XML", example="<configuration><foo>foo</foo></configuration>", required=false)
    @Nullable
    @Language(value="xml")
    private final String configuration;
    @Option(displayName="Dependencies", description="Optional plugin dependencies provided as raw XML.", example="<dependencies><dependency><groupId>com.yourorg</groupId><artifactId>core-lib</artifactId><version>1.0.0</version></dependency></dependencies>", required=false)
    @Nullable
    private final String dependencies;
    @Option(displayName="Executions", description="Optional executions provided as raw XML.", example="<execution><phase>generate-sources</phase><goals><goal>add-source</goal></goals></execution>", required=false)
    @Nullable
    private final String executions;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match. When not set, all source files are searched. ", required=false, example="**/*-parent/grpc-*/pom.xml")
    @Nullable
    private final String filePattern;

    public String getDisplayName() {
        return "Add Maven plugin";
    }

    public String getDescription() {
        return "Add the specified Maven plugin to the pom.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AddPluginVisitor();
    }

    public AddPlugin(String groupId, String artifactId, @Nullable String version, @Nullable @Language(value="xml") String configuration, @Nullable String dependencies, @Nullable String executions, @Nullable String filePattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.configuration = configuration;
        this.dependencies = dependencies;
        this.executions = executions;
        this.filePattern = filePattern;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    @Language(value="xml")
    public String getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public String getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public String getExecutions() {
        return this.executions;
    }

    @Nullable
    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    public String toString() {
        return "AddPlugin(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", configuration=" + this.getConfiguration() + ", dependencies=" + this.getDependencies() + ", executions=" + this.getExecutions() + ", filePattern=" + this.getFilePattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPlugin)) {
            return false;
        }
        AddPlugin other = (AddPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$dependencies = this.getDependencies();
        String other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !this$dependencies.equals(other$dependencies)) {
            return false;
        }
        String this$executions = this.getExecutions();
        String other$executions = other.getExecutions();
        if (this$executions == null ? other$executions != null : !this$executions.equals(other$executions)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : $dependencies.hashCode());
        String $executions = this.getExecutions();
        result = result * 59 + ($executions == null ? 43 : $executions.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }

    private class AddPluginVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private AddPluginVisitor() {
        }

        @Override
        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext executionContext) {
            if (AddPlugin.this.filePattern != null) {
                return PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)AddPlugin.this.filePattern) && super.isAcceptable(sourceFile, executionContext);
            }
            return super.isAcceptable(sourceFile, executionContext);
        }

        @Override
        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            Xml.Tag root = document.getRoot();
            if (!root.getChild("build").isPresent()) {
                document = (Xml.Document)new AddToTagVisitor(root, Xml.Tag.build((String)"<build/>")).visitNonNull((Tree)document, (Object)ctx, this.getCursor().getParentOrThrow());
            }
            return super.visitDocument(document, ctx);
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, ctx);
            if (BUILD_MATCHER.matches(this.getCursor())) {
                Xml.Tag plugins;
                Optional maybePlugins = t.getChild("plugins");
                if (maybePlugins.isPresent()) {
                    plugins = (Xml.Tag)maybePlugins.get();
                } else {
                    t = (Xml.Tag)new AddToTagVisitor(t, Xml.Tag.build((String)"<plugins/>")).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
                    plugins = (Xml.Tag)t.getChild("plugins").get();
                }
                Optional<Xml.Tag> maybePlugin = plugins.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && AddPlugin.this.groupId.equals(plugin.getChildValue("groupId").orElse(null)) && AddPlugin.this.artifactId.equals(plugin.getChildValue("artifactId").orElse(null))).findAny();
                if (maybePlugin.isPresent()) {
                    Xml.Tag plugin2 = maybePlugin.get();
                    if (AddPlugin.this.version != null && !AddPlugin.this.version.equals(plugin2.getChildValue("version").orElse(null))) {
                        t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)plugin2.getChild("version").get(), AddPlugin.this.version).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
                    }
                } else {
                    Xml.Tag pluginTag = Xml.Tag.build((String)("<plugin>\n<groupId>" + AddPlugin.this.groupId + "</groupId>\n<artifactId>" + AddPlugin.this.artifactId + "</artifactId>\n" + (AddPlugin.this.version != null ? "<version>" + AddPlugin.this.version + "</version>\n" : "") + (AddPlugin.this.executions != null ? AddPlugin.this.executions.trim() + "\n" : "") + (AddPlugin.this.configuration != null ? AddPlugin.this.configuration.trim() + "\n" : "") + (AddPlugin.this.dependencies != null ? AddPlugin.this.dependencies.trim() + "\n" : "") + "</plugin>"));
                    t = (Xml.Tag)new AddToTagVisitor(plugins, pluginTag).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParentOrThrow());
                }
            }
            return t;
        }
    }
}

