/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import org.jspecify.annotations.Nullable;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;

public class DependencyNotation {
    private DependencyNotation() {
    }

    public static @Nullable Dependency parse(@Nullable String notation) {
        if (notation == null) {
            return null;
        }
        if ((notation = notation.trim()).isEmpty()) {
            return null;
        }
        if (notation.indexOf(34) >= 0 || notation.indexOf(39) >= 0) {
            return null;
        }
        if (notation.indexOf(32) >= 0) {
            return null;
        }
        int idx = notation.lastIndexOf(64);
        if (idx == -1) {
            return DependencyNotation.parse(notation, null);
        }
        int versionIdx = notation.lastIndexOf(58);
        if (versionIdx < idx) {
            return DependencyNotation.parse(notation.substring(0, idx), notation.substring(idx + 1));
        }
        return DependencyNotation.parse(notation, null);
    }

    private static @Nullable Dependency parse(@Nullable String notation, @Nullable String type) {
        String fragment;
        if (notation == null) {
            return null;
        }
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        int count = 0;
        int idx = 0;
        for (int cur = 0; cur < notation.length(); ++cur) {
            if (':' != notation.charAt(cur)) continue;
            fragment = notation.substring(idx, cur);
            switch (count) {
                case 0: {
                    groupId = fragment;
                    break;
                }
                case 1: {
                    artifactId = fragment;
                    break;
                }
                case 2: {
                    version = fragment;
                    break;
                }
                case 3: {
                    classifier = fragment;
                }
            }
            idx = cur + 1;
            ++count;
        }
        if (idx < notation.length()) {
            fragment = notation.substring(idx);
            switch (count) {
                case 0: {
                    artifactId = fragment;
                    break;
                }
                case 1: {
                    artifactId = fragment;
                    break;
                }
                case 2: {
                    version = fragment;
                    break;
                }
                case 3: {
                    classifier = fragment;
                }
            }
            ++count;
        }
        if (count < 2 || count > 4 || artifactId == null || artifactId.isEmpty()) {
            return null;
        }
        if (groupId != null && !groupId.isEmpty() && !DependencyNotation.isValidIdentifier(groupId)) {
            return null;
        }
        if (!DependencyNotation.isValidIdentifier(artifactId)) {
            return null;
        }
        if ("".equals(version)) {
            version = "";
        }
        if ("".equals(classifier)) {
            classifier = "";
        }
        return Dependency.builder().gav(new GroupArtifactVersion(groupId, artifactId, version)).classifier(classifier).type(type).build();
    }

    public static String toStringNotation(Dependency dependency) {
        StringBuilder sb = new StringBuilder();
        if (dependency.getGav().getGroupId() != null) {
            sb.append(dependency.getGav().getGroupId());
        }
        sb.append(":").append(dependency.getGav().getArtifactId());
        if (dependency.getGav().getVersion() != null) {
            sb.append(":").append(dependency.getGav().getVersion());
        } else if (dependency.getClassifier() != null) {
            sb.append(":");
        }
        if (dependency.getClassifier() != null) {
            sb.append(":").append(dependency.getClassifier());
        }
        if (dependency.getType() != null) {
            sb.append("@").append(dependency.getType());
        }
        return sb.toString();
    }

    private static boolean isValidIdentifier(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }
}

