/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeClassLoader;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeMarketplaceWriter;
import org.openrewrite.maven.marketplace.MavenRecipeBundleReader;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;

public class MavenRecipeMarketplaceGenerator {
    private final GroupArtifactVersion gav;
    private final Path recipeJar;
    private final List<Path> classpath;

    public MavenRecipeMarketplaceGenerator(GroupArtifact ga, Path recipeJar, List<Path> classpath) {
        this.gav = new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), "");
        this.recipeJar = recipeJar;
        this.classpath = classpath;
    }

    public RecipeMarketplace generate() {
        if (Files.notExists(this.recipeJar, new LinkOption[0])) {
            throw new IllegalArgumentException("Recipe JAR does not exist " + this.recipeJar);
        }
        MavenRecipeBundleReader bundleReader = new MavenRecipeBundleReader(new RecipeBundle("maven", this.gav.getGroupId() + ":" + this.gav.getArtifactId(), this.gav.getVersion(), this.gav.getVersion(), null), null, null, RecipeClassLoader::new);
        bundleReader.recipeJar = this.recipeJar;
        bundleReader.classpath = this.classpath;
        return bundleReader.marketplaceFromClasspathScan();
    }

    public static void main(String[] args) throws IOException {
        String[] gav;
        if (args.length < 3) {
            System.err.println("Usage: java MavenRecipeMarketplaceGenerator <groupId:artifactId> <output-csv-path> <recipe-jar> [classpath-entries...]");
            System.exit(1);
        }
        if ((gav = args[0].split(":")).length != 2) {
            System.err.println("Invalid groupId:artifactId format: " + args[0]);
            System.exit(1);
        }
        String groupId = gav[0];
        String artifactId = gav[1];
        Path outputCsv = Paths.get(args[1], new String[0]);
        Path recipeJar = Paths.get(args[2], new String[0]);
        ArrayList<Path> classpath = new ArrayList<Path>();
        for (int i = 3; i < args.length; ++i) {
            classpath.add(Paths.get(args[i], new String[0]));
        }
        GroupArtifact ga = new GroupArtifact(groupId, artifactId);
        RecipeMarketplace marketplace = new MavenRecipeMarketplaceGenerator(ga, recipeJar, classpath).generate();
        String csv = new RecipeMarketplaceWriter().toCsv(marketplace);
        Files.write(outputCsv, csv.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        System.out.println("Generated marketplace CSV with " + marketplace.getAllRecipes().size() + " recipes");
        System.out.println("Output written to: " + outputCsv.toAbsolutePath());
    }
}

