/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.trait.MavenDependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.utilities.RetainVersions;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeDependencyVersion
extends ScanningRecipe<Accumulator> {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors)", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Override managed version", description="This flag can be set to explicitly override a managed dependency's version. If the dependency has its version managed by a Bill of Materials (BOM), enabling this flag will attempt to upgrade the BOM. The default for this flag is `false`.", required=false)
    private final @Nullable Boolean overrideManagedVersion;
    @Option(displayName="Retain versions", description="Accepts a list of GAVs. For each GAV, if it is a project direct dependency, and it is removed from dependency management after the changes from this recipe, then it will be retained with an explicit version. The version can be omitted from the GAV to use the old value from dependency management", example="com.jcraft:jsch", required=false)
    private final @Nullable List<String> retainVersions;

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven dependency version";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.newVersion);
    }

    public String getDescription() {
        return "Upgrade the version of a dependency by specifying a group and (optionally) an artifact using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator accumulator) {
        return new MavenIsoVisitor<ExecutionContext>(){
            private final VersionComparator versionComparator;
            {
                this.versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)UpgradeDependencyVersion.this.newVersion, (String)UpgradeDependencyVersion.this.versionPattern).getValue());
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                ResolvedPom pom = this.getResolutionResult().getPom();
                accumulator.projectArtifacts.add(new GroupArtifact(pom.getGroupId(), pom.getArtifactId()));
                return super.visitDocument(document, ctx);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency d;
                if (this.isDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId) && (d = this.findDependency(tag)) != null && d.getRepository() != null) {
                    try {
                        String requestedVersion;
                        Optional version;
                        String newerVersion = MavenDependency.findNewerVersion(d.getGroupId(), d.getArtifactId(), d.getVersion(), this.getResolutionResult(), UpgradeDependencyVersion.this.metadataFailures, this.versionComparator, ctx);
                        if (newerVersion != null && (version = tag.getChild("version")).isPresent() && this.isProperty(requestedVersion = d.getRequested().getVersion())) {
                            String propertyName = requestedVersion.substring(2, requestedVersion.length() - 1);
                            if (!this.getResolutionResult().getPom().getRequested().getProperties().containsKey(propertyName)) {
                                this.storeParentPomProperty(this.getResolutionResult().getParent(), propertyName, newerVersion);
                            }
                        }
                    }
                    catch (MavenDownloadingException e) {
                        return e.warn(tag);
                    }
                }
                return super.visitTag(tag, ctx);
            }

            private void storeParentPomProperty(@Nullable MavenResolutionResult currentMavenResolutionResult, String propertyName, String newerVersion) {
                if (currentMavenResolutionResult == null) {
                    return;
                }
                Pom pom = currentMavenResolutionResult.getPom().getRequested();
                if (pom.getSourcePath() == null) {
                    return;
                }
                if (pom.getProperties().containsKey(propertyName)) {
                    accumulator.pomProperties.add(new PomProperty(pom.getSourcePath(), propertyName, newerVersion));
                    return;
                }
                this.storeParentPomProperty(currentMavenResolutionResult.getParent(), propertyName, newerVersion);
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator accumulator) {
        return new MavenIsoVisitor<ExecutionContext>(){
            private final VersionComparator versionComparator;
            {
                this.versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)UpgradeDependencyVersion.this.newVersion, (String)UpgradeDependencyVersion.this.versionPattern).getValue());
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                if (Boolean.TRUE.equals(UpgradeDependencyVersion.this.overrideManagedVersion)) {
                    MavenResolutionResult mrr = this.getResolutionResult();
                    for (ResolvedDependency dep : mrr.findDependencies(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null)) {
                        ResolvedManagedDependency managedDep = this.getResolutionResult().getPom().getManagedDependency(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getClassifier());
                        if (managedDep == null || managedDep.getBomGav() == null) continue;
                        try {
                            Xml.Document result;
                            String targetVersion = this.findNewerVersion(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), ctx);
                            if (targetVersion == null || (result = this.attemptBomUpgrade(document, managedDep, targetVersion, ctx)) == document) continue;
                            return result;
                        }
                        catch (MavenDownloadingException e) {
                            document = e.warn(document);
                        }
                    }
                }
                return super.visitDocument(document, ctx);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t;
                block14: {
                    t = super.visitTag(tag, ctx);
                    try {
                        if (this.isPropertyTag()) {
                            Path pomSourcePath = this.getResolutionResult().getPom().getRequested().getSourcePath();
                            for (PomProperty pomProperty : accumulator.pomProperties) {
                                if (!pomProperty.pomFilePath.equals(pomSourcePath) || !pomProperty.propertyName.equals(tag.getName())) continue;
                                Optional value = tag.getValue();
                                if (!value.isPresent() || !((String)value.get()).equals(pomProperty.propertyValue)) {
                                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, pomProperty.propertyValue));
                                    this.maybeUpdateModel();
                                }
                                break block14;
                            }
                            break block14;
                        }
                        if (this.isDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                            t = this.upgradeDependency(ctx, t);
                        } else if (this.isManagedDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                            if (this.isManagedDependencyImportTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                                this.doAfterVisit((TreeVisitor)new UpgradeDependencyManagementImportVisitor());
                            } else {
                                TreeVisitor<Xml, ExecutionContext> upgradeManagedDependency = this.upgradeManagedDependency(tag, ctx, t);
                                if (upgradeManagedDependency != null) {
                                    this.doAfterVisit(upgradeManagedDependency);
                                }
                            }
                        } else if (this.isPluginDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId) || this.isAnnotationProcessorPathTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                            t = this.upgradeTag(ctx, t);
                        }
                    }
                    catch (MavenDownloadingException e) {
                        return e.warn(t);
                    }
                }
                if (t != tag && this.isProjectTag()) {
                    this.maybeUpdateModel();
                    this.doAfterVisit(new RemoveRedundantDependencyVersions(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null, null).getVisitor());
                }
                return t;
            }

            private boolean isManagedByLocalParent(String groupId, String artifactId) {
                for (MavenResolutionResult current = this.getResolutionResult().getParent(); current != null; current = current.getParent()) {
                    ResolvedPom parentPom = current.getPom();
                    if (!accumulator.projectArtifacts.contains(new GroupArtifact(parentPom.getGroupId(), parentPom.getArtifactId()))) continue;
                    for (ResolvedManagedDependency md : parentPom.getDependencyManagement()) {
                        if (!groupId.equals(md.getGroupId()) || !artifactId.equals(md.getArtifactId())) continue;
                        return true;
                    }
                }
                return false;
            }

            private Xml.Tag upgradeDependency(ExecutionContext ctx, Xml.Tag t) throws MavenDownloadingException {
                String newerVersion;
                ResolvedDependency d = this.findDependency(t);
                if (d != null && d.getRepository() != null && (newerVersion = this.findNewerVersion(d.getGroupId(), d.getArtifactId(), d.getVersion(), ctx)) != null) {
                    if (t.getChild("version").isPresent()) {
                        t = this.changeChildTagValue(t, "version", newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, ctx);
                    } else if (Boolean.TRUE.equals(UpgradeDependencyVersion.this.overrideManagedVersion)) {
                        ResolvedManagedDependency dm = this.findManagedDependency(t);
                        if (dm != null && this.isProperty(dm.getRequested().getVersion()) && dm.getRequestedBom() == null) {
                            this.doAfterVisit(new ChangePropertyValue(dm.getRequested().getVersion().substring(2, dm.getRequested().getVersion().length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false).getVisitor());
                        } else if (dm != null && dm.getBomGav() == null) {
                            boolean isManagedByLocalParent = this.isManagedByLocalParent(d.getGroupId(), d.getArtifactId());
                            if (!isManagedByLocalParent) {
                                Xml.Tag versionTag = Xml.Tag.build((String)("<version>" + newerVersion + "</version>"));
                                t = (Xml.Tag)new AddToTagVisitor(t, versionTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)0, this.getCursor().getParent());
                            }
                        } else {
                            Xml.Tag versionTag = Xml.Tag.build((String)("<version>" + newerVersion + "</version>"));
                            t = (Xml.Tag)new AddToTagVisitor(t, versionTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)0, this.getCursor().getParent());
                        }
                    }
                }
                return t;
            }

            private @Nullable TreeVisitor<Xml, ExecutionContext> upgradeManagedDependency(Xml.Tag tag, ExecutionContext ctx, Xml.Tag t) throws MavenDownloadingException {
                ResolvedManagedDependency managedDependency = this.findManagedDependency(t);
                if (managedDependency != null) {
                    String groupId = managedDependency.getGroupId();
                    String artifactId = managedDependency.getArtifactId();
                    String version = managedDependency.getVersion();
                    if (version != null && !accumulator.projectArtifacts.contains(new GroupArtifact(groupId, artifactId)) && StringUtils.matchesGlob((String)groupId, (String)UpgradeDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)artifactId, (String)UpgradeDependencyVersion.this.artifactId)) {
                        return this.upgradeVersion(ctx, t, managedDependency.getRequested().getVersion(), groupId, artifactId, version);
                    }
                } else {
                    for (ResolvedManagedDependency dm : this.getResolutionResult().getPom().getDependencyManagement()) {
                        ResolvedGroupArtifactVersion bom;
                        if (dm.getBomGav() == null) continue;
                        String group = Optional.ofNullable(this.getResolutionResult().getPom().getValue(tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId()))).orElse("");
                        String artifactId = Optional.ofNullable(this.getResolutionResult().getPom().getValue(tag.getChildValue("artifactId").orElse(""))).orElse("");
                        if (accumulator.projectArtifacts.contains(new GroupArtifact(group, artifactId)) || !Objects.equals(group, (bom = dm.getBomGav()).getGroupId()) || !Objects.equals(artifactId, bom.getArtifactId())) continue;
                        return this.upgradeVersion(ctx, t, Objects.requireNonNull(dm.getRequestedBom()).getVersion(), bom.getGroupId(), bom.getArtifactId(), bom.getVersion());
                    }
                }
                return null;
            }

            private Xml.Tag upgradeTag(ExecutionContext ctx, Xml.Tag t) throws MavenDownloadingException {
                String newerVersion;
                String groupId = t.getChildValue("groupId").orElse(null);
                String artifactId = t.getChildValue("artifactId").orElse(null);
                String version = t.getChildValue("version").orElse(null);
                if (groupId != null && artifactId != null && version != null && (newerVersion = this.findNewerVersion(groupId, artifactId, this.resolveVersion(version), ctx)) != null) {
                    t = this.changeChildTagValue(t, "version", newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, ctx);
                }
                return t;
            }

            private String resolveVersion(String version) {
                if (this.isProperty(version)) {
                    Map<String, String> properties = this.getResolutionResult().getPom().getProperties();
                    String property = version.substring(2, version.length() - 1);
                    return properties.getOrDefault(property, version);
                }
                return version;
            }

            public @Nullable TreeVisitor<Xml, ExecutionContext> upgradeVersion(ExecutionContext ctx, Xml.Tag tag, @Nullable String requestedVersion, String groupId, String artifactId, String version2) throws MavenDownloadingException {
                String newerVersion = this.findNewerVersion(groupId, artifactId, version2, ctx);
                if (newerVersion == null) {
                    return null;
                }
                if (this.isProperty(requestedVersion)) {
                    return new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion, false).getVisitor();
                }
                Xml.Tag childVersionTag = tag.getChild("version").orElse(null);
                if (childVersionTag != null) {
                    return new ChangeTagValueVisitor(childVersionTag, newerVersion);
                }
                return null;
            }

            private @Nullable String findNewerVersion(String groupId, String artifactId, String version, ExecutionContext ctx) throws MavenDownloadingException {
                return MavenDependency.findNewerVersion(groupId, artifactId, version, this.getResolutionResult(), UpgradeDependencyVersion.this.metadataFailures, this.versionComparator, ctx);
            }

            private Xml.Document attemptBomUpgrade(Xml.Document document, ResolvedManagedDependency managedDep, String targetVersion, ExecutionContext ctx) throws MavenDownloadingException {
                ResolvedGroupArtifactVersion bomGav = managedDep.getBomGav();
                if (bomGav == null) {
                    return document;
                }
                String newerBomVersion = this.findNewerBomVersionWithDependency(bomGav.getGroupId(), bomGav.getArtifactId(), bomGav.getVersion(), managedDep.getGroupId(), managedDep.getArtifactId(), targetVersion, ctx);
                if (newerBomVersion == null) {
                    return document;
                }
                return (Xml.Document)new UpgradeDependencyVersion(bomGav.getGroupId(), bomGav.getArtifactId(), newerBomVersion, null, true, UpgradeDependencyVersion.this.retainVersions).getVisitor(accumulator).visitNonNull((Tree)document, (Object)ctx, this.getCursor().getParentTreeCursor());
            }

            private @Nullable String findNewerBomVersionWithDependency(String bomGroupId, String bomArtifactId, String currentBomVersion, String dependencyGroupId, String dependencyArtifactId, String targetDependencyVersion, ExecutionContext ctx) throws MavenDownloadingException {
                List<String> bomVersions = this.getAvailableBomVersions(bomGroupId, bomArtifactId, currentBomVersion, ctx);
                for (String bomVersion : bomVersions) {
                    String managedVersion = this.getDependencyVersionFromBom(bomGroupId, bomArtifactId, bomVersion, dependencyGroupId, dependencyArtifactId, ctx);
                    if (!targetDependencyVersion.equals(managedVersion)) continue;
                    return bomVersion;
                }
                return null;
            }

            private List<String> getAvailableBomVersions(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) throws MavenDownloadingException {
                MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
                MavenSettings settings = mctx.effectiveSettings(this.getResolutionResult());
                MavenPomDownloader downloader = new MavenPomDownloader(Collections.emptyMap(), ctx, settings, Optional.ofNullable(settings).map(MavenSettings::getActiveProfiles).map(MavenSettings.ActiveProfiles::getActiveProfiles).orElse(null));
                MavenMetadata metadata = downloader.downloadMetadata(new GroupArtifact(groupId, artifactId), null, this.getResolutionResult().getPom().getRepositories());
                return metadata.getVersioning().getVersions().stream().filter(version -> this.versionComparator.compare(null, currentVersion, version) < 0).sorted((Comparator<String>)this.versionComparator).collect(Collectors.toList());
            }

            private @Nullable String getDependencyVersionFromBom(String bomGroupId, String bomArtifactId, String bomVersion, String dependencyGroupId, String dependencyArtifactId, ExecutionContext ctx) throws MavenDownloadingException {
                MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
                MavenSettings settings = mctx.effectiveSettings(this.getResolutionResult());
                MavenPomDownloader downloader = new MavenPomDownloader(Collections.emptyMap(), (ExecutionContext)mctx, settings, Optional.ofNullable(settings).map(MavenSettings::getActiveProfiles).map(MavenSettings.ActiveProfiles::getActiveProfiles).orElse(null));
                Pom bom = downloader.download(new GroupArtifactVersion(bomGroupId, bomArtifactId, bomVersion), null, null, this.getResolutionResult().getPom().getRepositories());
                ResolvedPom resolvedBom = bom.resolve(mctx.getActiveProfiles(), downloader, (ExecutionContext)mctx);
                for (ResolvedManagedDependency md : resolvedBom.getDependencyManagement()) {
                    if (!dependencyGroupId.equals(md.getGroupId()) || !dependencyArtifactId.equals(md.getArtifactId())) continue;
                    return md.getVersion();
                }
                return null;
            }

            class UpgradeDependencyManagementImportVisitor
            extends MavenIsoVisitor<ExecutionContext> {
                UpgradeDependencyManagementImportVisitor() {
                }

                @Override
                public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                    Xml.Tag t = super.visitTag(tag, ctx);
                    try {
                        TreeVisitor upgradeManagedDependency;
                        if (this.isManagedDependencyImportTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId) && (upgradeManagedDependency = this.upgradeManagedDependency(tag, ctx, t)) != null) {
                            this.retainVersions();
                            this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, null, UpgradeDependencyVersion.this.retainVersions).getVisitor());
                            this.doAfterVisit(upgradeManagedDependency);
                            this.maybeUpdateModel();
                            this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, null, null).getVisitor());
                        }
                    }
                    catch (MavenDownloadingException e) {
                        return e.warn(t);
                    }
                    return t;
                }

                private void retainVersions() {
                    RetainVersions.plan(this, UpgradeDependencyVersion.this.retainVersions == null ? Collections.emptyList() : UpgradeDependencyVersion.this.retainVersions).forEach(it -> this.doAfterVisit(it.getVisitor()));
                }
            }
        };
    }

    @Generated
    public UpgradeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion, @Nullable List<String> retainVersions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
        this.retainVersions = retainVersions;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @Generated
    public @Nullable List<String> getRetainVersions() {
        return this.retainVersions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeDependencyVersion(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ", retainVersions=" + this.getRetainVersions() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        List<String> this$retainVersions = this.getRetainVersions();
        List<String> other$retainVersions = other.getRetainVersions();
        return !(this$retainVersions == null ? other$retainVersions != null : !((Object)this$retainVersions).equals(other$retainVersions));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        List<String> $retainVersions = this.getRetainVersions();
        result = result * 59 + ($retainVersions == null ? 43 : ((Object)$retainVersions).hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Set<GroupArtifact> projectArtifacts = new HashSet<GroupArtifact>();
        private final Set<PomProperty> pomProperties = new HashSet<PomProperty>();

        @Generated
        public Accumulator() {
        }

        @Generated
        public Set<GroupArtifact> getProjectArtifacts() {
            return this.projectArtifacts;
        }

        @Generated
        public Set<PomProperty> getPomProperties() {
            return this.pomProperties;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<GroupArtifact> this$projectArtifacts = this.getProjectArtifacts();
            Set<GroupArtifact> other$projectArtifacts = other.getProjectArtifacts();
            if (this$projectArtifacts == null ? other$projectArtifacts != null : !((Object)this$projectArtifacts).equals(other$projectArtifacts)) {
                return false;
            }
            Set<PomProperty> this$pomProperties = this.getPomProperties();
            Set<PomProperty> other$pomProperties = other.getPomProperties();
            return !(this$pomProperties == null ? other$pomProperties != null : !((Object)this$pomProperties).equals(other$pomProperties));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<GroupArtifact> $projectArtifacts = this.getProjectArtifacts();
            result = result * 59 + ($projectArtifacts == null ? 43 : ((Object)$projectArtifacts).hashCode());
            Set<PomProperty> $pomProperties = this.getPomProperties();
            result = result * 59 + ($pomProperties == null ? 43 : ((Object)$pomProperties).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeDependencyVersion.Accumulator(projectArtifacts=" + this.getProjectArtifacts() + ", pomProperties=" + this.getPomProperties() + ")";
        }
    }

    public static final class PomProperty {
        private final Path pomFilePath;
        private final String propertyName;
        private final String propertyValue;

        @Generated
        public PomProperty(Path pomFilePath, String propertyName, String propertyValue) {
            this.pomFilePath = pomFilePath;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        @Generated
        public Path getPomFilePath() {
            return this.pomFilePath;
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public String getPropertyValue() {
            return this.propertyValue;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PomProperty)) {
                return false;
            }
            PomProperty other = (PomProperty)o;
            Path this$pomFilePath = this.getPomFilePath();
            Path other$pomFilePath = other.getPomFilePath();
            if (this$pomFilePath == null ? other$pomFilePath != null : !((Object)this$pomFilePath).equals(other$pomFilePath)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            String this$propertyValue = this.getPropertyValue();
            String other$propertyValue = other.getPropertyValue();
            return !(this$propertyValue == null ? other$propertyValue != null : !this$propertyValue.equals(other$propertyValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $pomFilePath = this.getPomFilePath();
            result = result * 59 + ($pomFilePath == null ? 43 : ((Object)$pomFilePath).hashCode());
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            String $propertyValue = this.getPropertyValue();
            result = result * 59 + ($propertyValue == null ? 43 : $propertyValue.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeDependencyVersion.PomProperty(pomFilePath=" + this.getPomFilePath() + ", propertyName=" + this.getPropertyName() + ", propertyValue=" + this.getPropertyValue() + ")";
        }
    }
}

