/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.table.EffectiveMavenSettings;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.tree.Xml;

public final class FindMavenSettings
extends Recipe {
    @Option(displayName="Existence check only", description="Only record that a maven settings file exists; do not include its contents.", required=false)
    private final @Nullable Boolean existenceCheckOnly;
    private final transient EffectiveMavenSettings settings = new EffectiveMavenSettings(this);

    public String getDisplayName() {
        return "Find effective maven settings";
    }

    public String getDescription() {
        return "List the effective maven settings file for the current project.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XmlMapper mapper = new XmlMapper();
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                MavenSettings effectiveSettings = MavenExecutionContextView.view(ctx).effectiveSettings(mrr);
                if (effectiveSettings != null) {
                    try {
                        FindMavenSettings.this.settings.insertRow(ctx, new EffectiveMavenSettings.Row(document.getSourcePath().toString(), Boolean.TRUE.equals(FindMavenSettings.this.existenceCheckOnly) ? "exists" : mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mrr.getMavenSettings())));
                    }
                    catch (JsonProcessingException e) {
                        throw new UncheckedIOException((IOException)((Object)e));
                    }
                }
                return document;
            }
        };
    }

    @Generated
    public FindMavenSettings(@Nullable Boolean existenceCheckOnly) {
        this.existenceCheckOnly = existenceCheckOnly;
    }

    @Generated
    public @Nullable Boolean getExistenceCheckOnly() {
        return this.existenceCheckOnly;
    }

    @Generated
    public EffectiveMavenSettings getSettings() {
        return this.settings;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindMavenSettings(existenceCheckOnly=" + this.getExistenceCheckOnly() + ", settings=" + (Object)((Object)this.getSettings()) + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMavenSettings)) {
            return false;
        }
        FindMavenSettings other = (FindMavenSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$existenceCheckOnly = this.getExistenceCheckOnly();
        Boolean other$existenceCheckOnly = other.getExistenceCheckOnly();
        return !(this$existenceCheckOnly == null ? other$existenceCheckOnly != null : !((Object)this$existenceCheckOnly).equals(other$existenceCheckOnly));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindMavenSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $existenceCheckOnly = this.getExistenceCheckOnly();
        result = result * 59 + ($existenceCheckOnly == null ? 43 : ((Object)$existenceCheckOnly).hashCode());
        return result;
    }
}

