/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradePluginVersion
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'. Supports globs.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'. Supports globs.", example="rewrite-maven-plugin")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors)", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Trust parent POM", description="Even if the parent suggests a version that is older than what we are trying to upgrade to, trust it anyway. Useful when you want to wait for the parent to catch up before upgrading. The parent is not trusted by default.", required=false)
    private final @Nullable Boolean trustParent;
    @Option(displayName="Add version if missing", description="If the plugin is missing a version, add the latest release. Defaults to false.", required=false)
    private final @Nullable Boolean addVersionIfMissing;

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven plugin version";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.newVersion);
    }

    public String getDescription() {
        return "Upgrade the version of a plugin using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue());
        return Preconditions.check((Recipe)new FindPlugin(this.groupId, this.artifactId), (TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isPluginTag(UpgradePluginVersion.this.groupId, UpgradePluginVersion.this.artifactId)) {
                    Optional versionTag = tag.getChild("version");
                    Optional maybeVersionValue = versionTag.flatMap(Xml.Tag::getValue);
                    if (maybeVersionValue.isPresent() || Boolean.TRUE.equals(UpgradePluginVersion.this.addVersionIfMissing)) {
                        String versionValue;
                        String versionLookup = maybeVersionValue.isPresent() ? ((versionValue = (String)maybeVersionValue.get()).startsWith("${") ? super.getResolutionResult().getPom().getValue(versionValue.trim()) : versionValue) : "0.0.0";
                        try {
                            ResolvedPom resolvedPom = this.getResolutionResult().getPom();
                            String tagGroupId = resolvedPom.getValue(tag.getChildValue("groupId").orElse(UpgradePluginVersion.this.groupId));
                            String tagArtifactId = resolvedPom.getValue(tag.getChildValue("artifactId").orElse(UpgradePluginVersion.this.artifactId));
                            assert (tagGroupId != null);
                            assert (tagArtifactId != null);
                            this.findNewerDependencyVersion(tagGroupId, tagArtifactId, versionLookup, ctx).ifPresent(newer -> this.doAfterVisit((TreeVisitor)new ChangePluginVersionVisitor(tagGroupId, tagArtifactId, (String)newer, Boolean.TRUE.equals(UpgradePluginVersion.this.addVersionIfMissing))));
                        }
                        catch (MavenDownloadingException e) {
                            return (Xml)e.warn(tag);
                        }
                    }
                    return tag;
                }
                return super.visitTag(tag, (Object)ctx);
            }

            private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) throws MavenDownloadingException {
                MavenMetadata mavenMetadata = UpgradePluginVersion.this.metadataFailures.insertRows(ctx, () -> this.downloadPluginMetadata(groupId, artifactId, ctx));
                ArrayList<String> availableVersions = new ArrayList<String>();
                for (String v : mavenMetadata.getVersioning().getVersions()) {
                    if (!versionComparator.isValid(currentVersion, v)) continue;
                    availableVersions.add(v);
                }
                return versionComparator.upgrade(currentVersion, availableVersions);
            }
        });
    }

    @Generated
    public UpgradePluginVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean trustParent, @Nullable Boolean addVersionIfMissing) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.trustParent = trustParent;
        this.addVersionIfMissing = addVersionIfMissing;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getTrustParent() {
        return this.trustParent;
    }

    @Generated
    public @Nullable Boolean getAddVersionIfMissing() {
        return this.addVersionIfMissing;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradePluginVersion(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", trustParent=" + this.getTrustParent() + ", addVersionIfMissing=" + this.getAddVersionIfMissing() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradePluginVersion)) {
            return false;
        }
        UpgradePluginVersion other = (UpgradePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        Boolean this$addVersionIfMissing = this.getAddVersionIfMissing();
        Boolean other$addVersionIfMissing = other.getAddVersionIfMissing();
        if (this$addVersionIfMissing == null ? other$addVersionIfMissing != null : !((Object)this$addVersionIfMissing).equals(other$addVersionIfMissing)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpgradePluginVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        Boolean $addVersionIfMissing = this.getAddVersionIfMissing();
        result = result * 59 + ($addVersionIfMissing == null ? 43 : ((Object)$addVersionIfMissing).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private static final class ChangePluginVersionVisitor
    extends MavenVisitor<ExecutionContext> {
        private final String groupId;
        private final String artifactId;
        private final String newVersion;
        private final boolean addVersionIfMissing;

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isPluginTag(this.groupId, this.artifactId)) {
                Optional versionTag = tag.getChild("version");
                if (versionTag.isPresent()) {
                    String version = ((Xml.Tag)versionTag.get()).getValue().orElse(null);
                    if (version != null) {
                        if (version.trim().startsWith("${")) {
                            if (!this.newVersion.equals(this.getResolutionResult().getPom().getValue(version.trim()))) {
                                this.doAfterVisit(new ChangePropertyValue(version, this.newVersion, false, false).getVisitor());
                            }
                        } else if (!this.newVersion.equals(version)) {
                            this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), this.newVersion));
                        }
                    }
                } else if (this.addVersionIfMissing) {
                    Xml.Tag newTag = Xml.Tag.build((String)("<version>" + this.newVersion + "</version>"));
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, newTag, (Comparator)new MavenTagInsertionComparator(tag.getChildren())));
                }
            }
            return super.visitTag(tag, (Object)ctx);
        }

        @Generated
        public ChangePluginVersionVisitor(String groupId, String artifactId, String newVersion, boolean addVersionIfMissing) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.newVersion = newVersion;
            this.addVersionIfMissing = addVersionIfMissing;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getNewVersion() {
            return this.newVersion;
        }

        @Generated
        public boolean isAddVersionIfMissing() {
            return this.addVersionIfMissing;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradePluginVersion.ChangePluginVersionVisitor(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", addVersionIfMissing=" + this.isAddVersionIfMissing() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangePluginVersionVisitor)) {
                return false;
            }
            ChangePluginVersionVisitor other = (ChangePluginVersionVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isAddVersionIfMissing() != other.isAddVersionIfMissing()) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$newVersion = this.getNewVersion();
            String other$newVersion = other.getNewVersion();
            return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ChangePluginVersionVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAddVersionIfMissing() ? 79 : 97);
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $newVersion = this.getNewVersion();
            result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
            return result;
        }
    }
}

