/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.xml.tree.Xml;

public final class RemoveExclusion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String artifactId;
    @Option(displayName="Exclusion Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String exclusionGroupId;
    @Option(displayName="Exclusion Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String exclusionArtifactId;
    @Option(displayName="Only ineffective", description="Default false. If enabled, matching exclusions will only be removed if they are ineffective (if the excluded dependency was not actually a transitive dependency of the target dependency).", required=false)
    @Nullable
    private final Boolean onlyIneffective;

    public String getDisplayName() {
        return "Remove exclusion";
    }

    public String getDescription() {
        return "Remove any matching exclusion from any matching dependency.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Optional maybeExclusions;
                if ((this.isDependencyTag(RemoveExclusion.this.groupId, RemoveExclusion.this.artifactId) || this.isManagedDependencyTag(RemoveExclusion.this.groupId, RemoveExclusion.this.artifactId)) && (maybeExclusions = tag.getChild("exclusions")).isPresent()) {
                    return tag.withContent(ListUtils.map((List)tag.getContent(), child -> {
                        if (child instanceof Xml.Tag && "exclusions".equals(((Xml.Tag)child).getName())) {
                            Xml.Tag e = (Xml.Tag)child;
                            if (e.getContent() != null) {
                                if ((e = e.withContent(ListUtils.map((List)e.getContent(), child2 -> {
                                    Xml.Tag exclusion;
                                    if (child2 instanceof Xml.Tag && "exclusion".equals(((Xml.Tag)child2).getName()) && (exclusion = (Xml.Tag)child2).getChildValue("groupId").map(g -> StringUtils.matchesGlob((String)g, (String)RemoveExclusion.this.exclusionGroupId)).orElse(false).booleanValue() && exclusion.getChildValue("artifactId").map(g -> StringUtils.matchesGlob((String)g, (String)RemoveExclusion.this.exclusionArtifactId)).orElse(false).booleanValue() && (!this.isEffectiveExclusion(tag, this.groupArtifact(exclusion)) || !Boolean.TRUE.equals(RemoveExclusion.this.onlyIneffective))) {
                                        return null;
                                    }
                                    return child2;
                                }))).getContent() == null || e.getContent().isEmpty()) {
                                    return null;
                                }
                                if (e.getContent().stream().noneMatch(Xml.Tag.class::isInstance)) {
                                    return null;
                                }
                            }
                            return e;
                        }
                        return child;
                    }));
                }
                return super.visitTag(tag, (Object)executionContext);
            }

            private GroupArtifact groupArtifact(Xml.Tag tag) {
                return new GroupArtifact((String)tag.getChildValue("groupId").orElseThrow(IllegalArgumentException::new), (String)tag.getChildValue("artifactId").orElseThrow(IllegalArgumentException::new));
            }

            private boolean isEffectiveExclusion(Xml.Tag tag, GroupArtifact exclusion) {
                ResolvedDependency dependency = this.findDependency(tag);
                if (dependency != null) {
                    return dependency.getEffectiveExclusions().contains(exclusion);
                }
                ResolvedManagedDependency managedDependency = this.findManagedDependency(tag);
                return managedDependency != null && managedDependency.getRequested() != null;
            }
        };
    }

    public RemoveExclusion(String groupId, String artifactId, String exclusionGroupId, String exclusionArtifactId, @Nullable Boolean onlyIneffective) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.exclusionGroupId = exclusionGroupId;
        this.exclusionArtifactId = exclusionArtifactId;
        this.onlyIneffective = onlyIneffective;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getExclusionGroupId() {
        return this.exclusionGroupId;
    }

    public String getExclusionArtifactId() {
        return this.exclusionArtifactId;
    }

    @Nullable
    public Boolean getOnlyIneffective() {
        return this.onlyIneffective;
    }

    @NonNull
    public String toString() {
        return "RemoveExclusion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", exclusionGroupId=" + this.getExclusionGroupId() + ", exclusionArtifactId=" + this.getExclusionArtifactId() + ", onlyIneffective=" + this.getOnlyIneffective() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveExclusion)) {
            return false;
        }
        RemoveExclusion other = (RemoveExclusion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$onlyIneffective = this.getOnlyIneffective();
        Boolean other$onlyIneffective = other.getOnlyIneffective();
        if (this$onlyIneffective == null ? other$onlyIneffective != null : !((Object)this$onlyIneffective).equals(other$onlyIneffective)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$exclusionGroupId = this.getExclusionGroupId();
        String other$exclusionGroupId = other.getExclusionGroupId();
        if (this$exclusionGroupId == null ? other$exclusionGroupId != null : !this$exclusionGroupId.equals(other$exclusionGroupId)) {
            return false;
        }
        String this$exclusionArtifactId = this.getExclusionArtifactId();
        String other$exclusionArtifactId = other.getExclusionArtifactId();
        return !(this$exclusionArtifactId == null ? other$exclusionArtifactId != null : !this$exclusionArtifactId.equals(other$exclusionArtifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveExclusion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $onlyIneffective = this.getOnlyIneffective();
        result = result * 59 + ($onlyIneffective == null ? 43 : ((Object)$onlyIneffective).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $exclusionGroupId = this.getExclusionGroupId();
        result = result * 59 + ($exclusionGroupId == null ? 43 : $exclusionGroupId.hashCode());
        String $exclusionArtifactId = this.getExclusionArtifactId();
        result = result * 59 + ($exclusionArtifactId == null ? 43 : $exclusionArtifactId.hashCode());
        return result;
    }
}

