/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jspecify.annotations.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.DownloadOperation;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.grammar.VersionRangeLexer;
import org.openrewrite.maven.internal.grammar.VersionRangeParser;
import org.openrewrite.maven.internal.grammar.VersionRangeParserBaseVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionRequirement {
    private static final Logger logger = LoggerFactory.getLogger(VersionRequirement.class);
    private final @Nullable VersionRequirement nearer;
    private final VersionSpec versionSpec;
    private volatile transient @Nullable String selected;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.nearer != null) {
            builder.append(this.nearer).append(", ");
        }
        builder.append(this.versionSpec);
        return builder.toString();
    }

    public static VersionRequirement fromVersion(String requested, int depth) {
        return new VersionRequirement(null, VersionSpec.build(requested, depth == 0));
    }

    public VersionRequirement addRequirement(String requested) {
        if (this.versionSpec instanceof DirectRequirement) {
            return this;
        }
        VersionSpec newRequirement = VersionSpec.build(requested, false);
        VersionRequirement next = this;
        while (next != null) {
            if (next.versionSpec.equals(newRequirement)) {
                return this;
            }
            next = next.nearer;
        }
        return new VersionRequirement(this, newRequirement);
    }

    public @Nullable String resolve(DownloadOperation<Iterable<String>> availableVersions) throws MavenDownloadingException {
        if (this.selected == null) {
            this.selected = this.cacheResolved(availableVersions);
        }
        return this.selected;
    }

    private @Nullable String cacheResolved(DownloadOperation<Iterable<String>> availableVersions) throws MavenDownloadingException {
        String nearestSoftRequirement = null;
        VersionRequirement next = this;
        VersionRequirement nearestHardRequirement = null;
        while (next != null) {
            VersionSpec spec = next.versionSpec;
            if (spec instanceof DirectRequirement) {
                return ((DirectRequirement)spec).getVersion();
            }
            if (spec instanceof SoftRequirement) {
                nearestSoftRequirement = ((SoftRequirement)spec).version;
            } else {
                nearestHardRequirement = next;
            }
            next = next.nearer;
        }
        if (nearestHardRequirement == null) {
            return nearestSoftRequirement;
        }
        VersionSpec hardRequirement = nearestHardRequirement.versionSpec;
        Version latest = null;
        for (String availableVersion : availableVersions.call()) {
            Version version = new Version(availableVersion);
            if ((!(hardRequirement instanceof DynamicVersion) || !((DynamicVersion)hardRequirement).matches(version)) && (!(hardRequirement instanceof RangeSet) || !((RangeSet)hardRequirement).matches(version)) || latest != null && version.compareTo(latest) <= 0) continue;
            latest = version;
        }
        if (latest == null) {
            return null;
        }
        return latest.toString();
    }

    public @Nullable String resolve(GroupArtifact groupArtifact, MavenPomDownloader downloader, List<MavenRepository> repositories) throws MavenDownloadingException {
        return this.resolve(() -> {
            MavenMetadata metadata = downloader.downloadMetadata(groupArtifact, null, repositories);
            return metadata.getVersioning().getVersions();
        });
    }

    @Generated
    public VersionRequirement(@Nullable VersionRequirement nearer, VersionSpec versionSpec) {
        this.nearer = nearer;
        this.versionSpec = versionSpec;
    }

    static interface VersionSpec {
        public static VersionSpec build(String requested, boolean direct) {
            if ("LATEST".equals(requested)) {
                return DynamicVersion.LATEST;
            }
            if ("RELEASE".equals(requested)) {
                return DynamicVersion.RELEASE;
            }
            if (requested.contains("[") || requested.contains("(")) {
                if (!requested.contains("]") && !requested.contains(")")) {
                    requested = requested + "]";
                }
                VersionRangeParser parser = new VersionRangeParser((TokenStream)new CommonTokenStream((TokenSource)new VersionRangeLexer((CharStream)CharStreams.fromString((String)requested))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new LoggingErrorListener());
                return (VersionSpec)new VersionRangeParserBaseVisitor<VersionSpec>(){

                    @Override
                    public VersionSpec visitVersionRequirement(VersionRangeParser.VersionRequirementContext ctx) {
                        return new RangeSet(ctx.range().stream().map(range -> {
                            Version upper;
                            Version lower;
                            if (range.bounds().boundedLower() != null) {
                                Iterator<TerminalNode> versionIter = range.bounds().boundedLower().Version().iterator();
                                lower = versionIter.hasNext() ? this.toVersion(versionIter.next()) : null;
                                upper = versionIter.hasNext() ? this.toVersion(versionIter.next()) : null;
                            } else if (range.bounds().unboundedLower() != null) {
                                TerminalNode upperVersionNode = range.bounds().unboundedLower().Version();
                                lower = null;
                                upper = upperVersionNode != null ? this.toVersion(upperVersionNode) : null;
                            } else {
                                lower = this.toVersion(range.bounds().exactly().Version());
                                upper = this.toVersion(range.bounds().exactly().Version());
                            }
                            return new Range(range.CLOSED_RANGE_OPEN() != null, lower, range.CLOSED_RANGE_CLOSE() != null, upper);
                        }).collect(Collectors.toList()));
                    }

                    private Version toVersion(TerminalNode version) {
                        return new Version(version.getText());
                    }
                }.visit((ParseTree)parser.versionRequirement());
            }
            return direct ? new DirectRequirement(requested) : new SoftRequirement(requested);
        }
    }

    private static final class DirectRequirement
    extends SoftRequirement {
        private DirectRequirement(String version) {
            super(version);
        }

        @Override
        public String toString() {
            return "Version='" + this.version + "'";
        }

        @Override
        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectRequirement)) {
                return false;
            }
            DirectRequirement other = (DirectRequirement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof DirectRequirement;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    private static class SoftRequirement
    implements VersionSpec {
        final String version;

        public String toString() {
            return "Soft version='" + this.version + "'";
        }

        @Generated
        public SoftRequirement(String version) {
            this.version = version;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SoftRequirement)) {
                return false;
            }
            SoftRequirement other = (SoftRequirement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof SoftRequirement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }
    }

    private static enum DynamicVersion implements VersionSpec
    {
        LATEST,
        RELEASE;


        public boolean matches(Version version) {
            return this == LATEST || !version.toString().endsWith("-SNAPSHOT");
        }

        public String toString() {
            return "Dynamic='" + this.name() + "'";
        }
    }

    private static final class RangeSet
    implements VersionSpec {
        private final List<Range> ranges;

        public boolean matches(Version version) {
            for (Range range : this.ranges) {
                boolean lowerMatches = true;
                if (range.lower != null) {
                    int lowComp = range.lower.compareTo(version);
                    boolean bl = lowComp == 0 ? range.lowerClosed : (lowerMatches = lowComp < 0);
                }
                if (!lowerMatches) {
                    return false;
                }
                boolean upperMatches = true;
                if (range.upper != null) {
                    int upperComp = range.upper.compareTo(version);
                    boolean bl = upperComp == 0 ? range.upperClosed : (upperMatches = upperComp > 0);
                }
                if (!upperMatches) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.ranges.stream().map(Range::toString).collect(Collectors.joining(",", "RangeSet={", "}"));
        }

        @Generated
        public RangeSet(List<Range> ranges) {
            this.ranges = ranges;
        }

        @Generated
        public List<Range> getRanges() {
            return this.ranges;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RangeSet)) {
                return false;
            }
            RangeSet other = (RangeSet)o;
            List<Range> this$ranges = this.getRanges();
            List<Range> other$ranges = other.getRanges();
            return !(this$ranges == null ? other$ranges != null : !((Object)this$ranges).equals(other$ranges));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Range> $ranges = this.getRanges();
            result = result * 59 + ($ranges == null ? 43 : ((Object)$ranges).hashCode());
            return result;
        }
    }

    private static class LoggingErrorListener
    extends BaseErrorListener {
        private LoggingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            logger.warn("Syntax error at line {}:{} {}", new Object[]{line, charPositionInLine, msg});
        }
    }

    private static final class Range {
        private final boolean lowerClosed;
        private final @Nullable Version lower;
        private final boolean upperClosed;
        private final @Nullable Version upper;

        public String toString() {
            return (this.lowerClosed ? "[" : "(") + this.lower + "," + this.upper + (this.upperClosed ? (char)']' : ')');
        }

        @Generated
        public Range(boolean lowerClosed, @Nullable Version lower, boolean upperClosed, @Nullable Version upper) {
            this.lowerClosed = lowerClosed;
            this.lower = lower;
            this.upperClosed = upperClosed;
            this.upper = upper;
        }

        @Generated
        public boolean isLowerClosed() {
            return this.lowerClosed;
        }

        @Generated
        public @Nullable Version getLower() {
            return this.lower;
        }

        @Generated
        public boolean isUpperClosed() {
            return this.upperClosed;
        }

        @Generated
        public @Nullable Version getUpper() {
            return this.upper;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (this.isLowerClosed() != other.isLowerClosed()) {
                return false;
            }
            if (this.isUpperClosed() != other.isUpperClosed()) {
                return false;
            }
            Version this$lower = this.getLower();
            Version other$lower = other.getLower();
            if (this$lower == null ? other$lower != null : !((Object)this$lower).equals(other$lower)) {
                return false;
            }
            Version this$upper = this.getUpper();
            Version other$upper = other.getUpper();
            return !(this$upper == null ? other$upper != null : !((Object)this$upper).equals(other$upper));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLowerClosed() ? 79 : 97);
            result = result * 59 + (this.isUpperClosed() ? 79 : 97);
            Version $lower = this.getLower();
            result = result * 59 + ($lower == null ? 43 : ((Object)$lower).hashCode());
            Version $upper = this.getUpper();
            result = result * 59 + ($upper == null ? 43 : ((Object)$upper).hashCode());
            return result;
        }
    }
}

