/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.tree.Version;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddDependencyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private static final XPathMatcher DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencies");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final @Nullable String versionPattern;
    private final @Nullable String scope;
    private final @Nullable Boolean releasesOnly;
    private final @Nullable String type;
    private final @Nullable String classifier;
    private final @Nullable Boolean optional;
    private final @Nullable Pattern familyRegex;
    private final @Nullable MavenMetadataFailures metadataFailures;
    private @Nullable VersionComparator versionComparator;
    private @Nullable String resolvedVersion;

    public AddDependencyVisitor(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, @Nullable Pattern familyRegex) {
        this(groupId, artifactId, version, versionPattern, scope, releasesOnly, type, classifier, optional, familyRegex, null);
    }

    @Override
    public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
        if (this.isDependencyTag() && this.groupId.equals(tag.getChildValue("groupId").orElse(null)) && this.artifactId.equals(tag.getChildValue("artifactId").orElse(null)) && Scope.fromName(this.scope) == Scope.fromName(tag.getChildValue("scope").orElse(null))) {
            this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "alreadyHasDependency", (Object)true);
            return tag;
        }
        return super.visitTag(tag, executionContext);
    }

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
        Xml.Tag root;
        Validated versionValidation;
        Xml.Document maven = super.visitDocument(document, executionContext);
        if (((Boolean)this.getCursor().getMessage("alreadyHasDependency", (Object)false)).booleanValue()) {
            return document;
        }
        Scope resolvedScope = this.scope == null ? Scope.Compile : Scope.fromName(this.scope);
        Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult().getDependencies();
        if (dependencies.containsKey((Object)resolvedScope)) {
            for (ResolvedDependency d : dependencies.get((Object)resolvedScope)) {
                if (!d.isDirect() || !this.groupId.equals(d.getGroupId()) || !this.artifactId.equals(d.getArtifactId())) continue;
                return maven;
            }
        }
        if ((versionValidation = Semver.validate((String)this.version, (String)this.versionPattern)).isValid()) {
            this.versionComparator = (VersionComparator)versionValidation.getValue();
        }
        if (!(root = maven.getRoot()).getChild("dependencies").isPresent()) {
            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencies/>"), (Comparator)new MavenTagInsertionComparator(root.getContent() == null ? Collections.emptyList() : root.getContent())));
        }
        this.doAfterVisit((TreeVisitor)new InsertDependencyInOrder(this.scope));
        return maven;
    }

    @Generated
    public AddDependencyVisitor(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, @Nullable Pattern familyRegex, @Nullable MavenMetadataFailures metadataFailures) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.scope = scope;
        this.releasesOnly = releasesOnly;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        this.familyRegex = familyRegex;
        this.metadataFailures = metadataFailures;
    }

    private class InsertDependencyInOrder
    extends MavenVisitor<ExecutionContext> {
        private final @Nullable String scope;

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                String versionToUse = null;
                if (this.getResolutionResult().getPom().getManagedVersion(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId, AddDependencyVisitor.this.type, AddDependencyVisitor.this.classifier) == null) {
                    if (AddDependencyVisitor.this.familyRegex != null) {
                        versionToUse = this.findDependencies(d -> AddDependencyVisitor.this.familyRegex.matcher(d.getGroupId()).matches()).stream().max(Comparator.comparing(d -> new Version(d.getVersion()))).map(d -> d.getRequested().getVersion()).orElse(null);
                    }
                    if (versionToUse == null) {
                        try {
                            versionToUse = this.findVersionToUse(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (Xml)e.warn(tag);
                        }
                    }
                }
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + AddDependencyVisitor.this.groupId + "</groupId>\n<artifactId>" + AddDependencyVisitor.this.artifactId + "</artifactId>\n" + (versionToUse == null ? "" : "<version>" + versionToUse + "</version>\n") + (AddDependencyVisitor.this.classifier == null ? "" : "<classifier>" + AddDependencyVisitor.this.classifier + "</classifier>\n") + (AddDependencyVisitor.this.type == null || "jar".equals(AddDependencyVisitor.this.type) ? "" : "<type>" + AddDependencyVisitor.this.type + "</type>\n") + (this.scope == null || "compile".equals(this.scope) ? "" : "<scope>" + this.scope + "</scope>\n") + (Boolean.TRUE.equals(AddDependencyVisitor.this.optional) ? "<optional>true</optional>\n" : "") + "</dependency>"));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getContent() == null ? Collections.emptyList() : tag.getContent(), dependencyTag)));
                this.maybeUpdateModel();
                return tag;
            }
            return super.visitTag(tag, (Object)ctx);
        }

        private String findVersionToUse(String groupId, String artifactId, ExecutionContext ctx) throws MavenDownloadingException {
            if (AddDependencyVisitor.this.resolvedVersion == null) {
                if (AddDependencyVisitor.this.versionComparator == null || AddDependencyVisitor.this.versionComparator instanceof ExactVersion) {
                    AddDependencyVisitor.this.resolvedVersion = AddDependencyVisitor.this.version;
                } else {
                    MavenMetadata mavenMetadata = AddDependencyVisitor.this.metadataFailures == null ? this.downloadMetadata(groupId, artifactId, ctx) : AddDependencyVisitor.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    LatestRelease latest = new LatestRelease(AddDependencyVisitor.this.versionPattern);
                    AddDependencyVisitor.this.resolvedVersion = mavenMetadata.getVersioning().getVersions().stream().filter(v -> AddDependencyVisitor.this.versionComparator.isValid(null, v)).filter(v -> !Boolean.TRUE.equals(AddDependencyVisitor.this.releasesOnly) || latest.isValid(null, v)).max((v1, v2) -> AddDependencyVisitor.this.versionComparator.compare(null, v1, v2)).orElse(AddDependencyVisitor.this.version);
                }
            }
            return AddDependencyVisitor.this.resolvedVersion;
        }

        @Generated
        public InsertDependencyInOrder(String scope) {
            this.scope = scope;
        }
    }
}

