/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.xml.tree.Xml;

public class Assertions {
    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        if (MavenSettings.readFromDiskEnabled()) {
            MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
            mctx.setMavenSettings(MavenSettings.readMavenSettingsFromDisk((ExecutionContext)mctx), new String[0]);
        }
    }

    public static SourceSpecs pomXml(@Nullable @Language(value="xml") String before) {
        return Assertions.pomXml(before, (SourceSpec<Xml.Document> s) -> {});
    }

    public static SourceSpecs pomXml(@Nullable @Language(value="xml") String before, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }

    public static SourceSpecs pomXml(@Nullable @Language(value="xml") String before, @Nullable @Language(value="xml") String after) {
        return Assertions.pomXml(before, after, s -> {});
    }

    public static SourceSpecs pomXml(@Nullable @Language(value="xml") String before, @Nullable @Language(value="xml") String after, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext).after(s -> after);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }
}

