/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.io.FileNotFoundException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.LocalMavenArtifactCache;
import org.openrewrite.maven.cache.MavenArtifactCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.ReadOnlyLocalMavenArtifactCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawMavenResolver;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public class MavenArtifactHelper {
    private static final String LATEST_INTEGRATION = "latest.integration";
    private static final String LATEST_RELEASE = "latest.release";
    private static final MavenRepository SUPER_POM_REPOSITORY = new MavenRepository("central", URI.create("https://repo.maven.apache.org/maven2"), true, false, null, null);

    public static List<Path> downloadArtifactAndDependencies(String groupId, String artifactId, String version, ExecutionContext ctx, MavenPomCache mavenPomCache) {
        ArrayList<MavenRepository> repositories = new ArrayList<MavenRepository>();
        repositories.add(SUPER_POM_REPOSITORY);
        return MavenArtifactHelper.downloadArtifactAndDependencies(groupId, artifactId, version, ctx, mavenPomCache, repositories);
    }

    public static List<Path> downloadArtifactAndDependencies(String groupId, String artifactId, String version, ExecutionContext ctx, MavenPomCache mavenPomCache, List<MavenRepository> repositories) {
        return MavenArtifactHelper.downloadArtifactAndDependenciesInternal(groupId, artifactId, version, ctx, mavenPomCache, repositories, ReadOnlyLocalMavenArtifactCache.mavenLocal().orElse(new LocalMavenArtifactCache(Paths.get(System.getProperty("user.home"), ".rewrite", "cache", "artifacts"))));
    }

    public static List<Path> downloadArtifactAndDependencies(String groupId, String artifactId, String version, ExecutionContext ctx, MavenPomCache mavenPomCache, List<MavenRepository> repositories, Path path) {
        return MavenArtifactHelper.downloadArtifactAndDependenciesInternal(groupId, artifactId, version, ctx, mavenPomCache, repositories, new LocalMavenArtifactCache(path));
    }

    private static List<Path> downloadArtifactAndDependenciesInternal(String groupId, String artifactId, String version, ExecutionContext ctx, MavenPomCache mavenPomCache, List<MavenRepository> repositories, MavenArtifactCache mavenArtifactCache) {
        MavenRepository pomRepository;
        String exactVersion;
        MavenPomDownloader mavenPomDownloader = new MavenPomDownloader(mavenPomCache, Collections.emptyMap(), ctx);
        RawMaven rawMaven = mavenPomDownloader.download(groupId, artifactId, exactVersion = MavenArtifactHelper.getExactVersion(groupId, artifactId, version, ctx, repositories), null, null, repositories, ctx);
        if (rawMaven == null) {
            return Collections.emptyList();
        }
        MavenExecutionContextView mavenCtx = new MavenExecutionContextView(ctx);
        mavenCtx.setRepositories(repositories);
        Xml.Document xml = new RawMavenResolver(mavenPomDownloader, Collections.emptyList(), true, ctx, null).resolve(rawMaven, new HashMap<String, String>());
        if (xml == null) {
            return Collections.emptyList();
        }
        Maven maven = new Maven(xml);
        Pom pom = maven.getModel();
        MavenArtifactDownloader mavenArtifactDownloader = new MavenArtifactDownloader(mavenArtifactCache, null, ctx.getOnError());
        ArrayList<Path> artifactPaths = new ArrayList<Path>();
        Path downloadedArtifact = null;
        Iterator<Object> iterator = pom.getRepositories().iterator();
        while (iterator.hasNext() && (downloadedArtifact = mavenArtifactDownloader.downloadArtifact(new Pom.Dependency(pomRepository = iterator.next(), Scope.Compile, null, null, false, new Pom(Tree.randomId(), pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), null, null, null, null, null, null, Collections.emptyList(), new Pom.DependencyManagement(Collections.emptyList()), Collections.emptyList(), repositories, Collections.emptyMap(), Collections.emptyMap()), null, pom.getSnapshotVersion(), Collections.emptySet()))) == null) {
        }
        if (downloadedArtifact == null) {
            throw new UncheckedIOException(new FileNotFoundException("Could not find " + pom.toString() + " in any repositories."));
        }
        artifactPaths.add(downloadedArtifact);
        for (Pom.Dependency dependency : MavenArtifactHelper.collectDependencies(maven.getModel().getDependencies(), d -> !d.isOptional() && d.getScope() != Scope.Test)) {
            artifactPaths.add(mavenArtifactDownloader.downloadArtifact(dependency));
        }
        return artifactPaths;
    }

    public static String getExactVersion(String groupId, String artifactId, String version, ExecutionContext ctx, List<MavenRepository> repositories) {
        if (LATEST_INTEGRATION.equals(version)) {
            return MavenArtifactHelper.getLatestIntegrationVersion(groupId, artifactId, version, ctx, repositories);
        }
        if (LATEST_RELEASE.equals(version)) {
            return MavenArtifactHelper.getLatestReleaseVersion(groupId, artifactId, version, ctx, repositories);
        }
        return version;
    }

    private static String getLatestReleaseVersion(String groupId, String artifactId, String version, ExecutionContext ctx, List<MavenRepository> repositories) {
        MavenMetadata mavenMetadata = new MavenPomDownloader(MavenPomCache.NOOP, Collections.emptyMap(), ctx).downloadMetadata(groupId, artifactId, repositories);
        LatestRelease versionComparator = new LatestRelease(null);
        Optional<String> maybeLatest = mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)versionComparator).isValid(arg_0)).max(String::compareTo);
        if (!maybeLatest.isPresent()) {
            throw new IllegalStateException("No latest release version of " + groupId + ":" + artifactId);
        }
        return maybeLatest.get();
    }

    private static String getLatestIntegrationVersion(String groupId, String artifactId, String version, ExecutionContext ctx, List<MavenRepository> repositories) {
        MavenMetadata mavenMetadata = new MavenPomDownloader(MavenPomCache.NOOP, Collections.emptyMap(), ctx).downloadMetadata(groupId, artifactId, repositories);
        Optional maybeLatest = mavenMetadata.getVersioning().getVersions().stream().max(String::compareTo);
        if (!maybeLatest.isPresent()) {
            throw new IllegalStateException("No latest integration version of " + groupId + ":" + artifactId);
        }
        return (String)maybeLatest.get();
    }

    public static List<Pom.Dependency> collectDependencies(Collection<Pom.Dependency> dependencies, Predicate<Pom.Dependency> dependencyFilter) {
        return new ArrayList<Pom.Dependency>(MavenArtifactHelper.traverseDependencies(dependencies, new LinkedHashMap<DependencyKey, Pom.Dependency>(), dependencyFilter).values());
    }

    private static Map<DependencyKey, Pom.Dependency> traverseDependencies(Collection<Pom.Dependency> dependencies, Map<DependencyKey, Pom.Dependency> dependencyMap, Predicate<Pom.Dependency> dependencyFilter) {
        if (dependencies == null) {
            return dependencyMap;
        }
        dependencies.stream().filter(dependencyFilter).forEach(d -> {
            DependencyKey key = MavenArtifactHelper.getDependencyKey(d);
            if (!dependencyMap.containsKey(key)) {
                dependencyMap.put(key, (Pom.Dependency)d);
                MavenArtifactHelper.traverseDependencies(d.getModel().getDependencies(), dependencyMap, dependencyFilter);
            }
        });
        return dependencyMap;
    }

    private static DependencyKey getDependencyKey(Pom.Dependency dependency) {
        return new DependencyKey(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getExclusions());
    }

    static final class DependencyKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<GroupArtifact> exclusions;

        public DependencyKey(String groupId, String artifactId, String version, Set<GroupArtifact> exclusions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.exclusions = exclusions;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyKey)) {
                return false;
            }
            DependencyKey other = (DependencyKey)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenArtifactHelper.DependencyKey(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", exclusions=" + this.getExclusions() + ")";
        }
    }
}

