/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class RawMaven {
    @JsonIgnore
    private final Timer.Sample sample = Timer.start();
    private final Xml.Document document;
    private final RawPom pom;
    private final boolean projectPom;
    @Nullable
    private MavenRepository repository;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawMaven rawMaven = (RawMaven)o;
        return this.getSourcePath().equals(rawMaven.getSourcePath());
    }

    public Path getSourcePath() {
        return this.document.getSourcePath();
    }

    public int hashCode() {
        return Objects.hash(this.getSourcePath());
    }

    public static RawMaven parse(Parser.Input source, @Nullable Path relativeTo, @Nullable String snapshotVersion, ExecutionContext ctx) {
        Xml.Document document = (Xml.Document)new MavenXmlParser().parseInputs(Collections.singletonList(source), relativeTo, ctx).iterator().next();
        try {
            RawPom pom = (RawPom)MavenXmlMapper.readMapper().readValue(source.getSource(), RawPom.class);
            if (snapshotVersion != null) {
                pom.setSnapshotVersion(snapshotVersion);
            }
            return new RawMaven(document, pom, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse " + source.getPath(), e);
        }
    }

    public Map<String, String> getActiveProperties(Collection<String> activeProfiles) {
        return this.pom.getActiveProperties(activeProfiles);
    }

    public List<RawPom.Dependency> getActiveDependencies(Collection<String> activeProfiles) {
        return this.pom.getActiveDependencies(activeProfiles);
    }

    public String getSourceUri() {
        String sourceUri = this.repository != null ? this.repository.getUri().toString() + '/' + (this.pom.getGroupId() == null ? "null" : this.pom.getGroupId().replace('.', '/')) + '/' + this.pom.getArtifactId() + '/' + this.pom.getVersion() + '/' + this.pom.getArtifactId() + '-' + (this.pom.getSnapshotVersion() == null ? this.pom.getVersion() : this.pom.getSnapshotVersion()) + ".pom" : "file://" + this.document.getSourcePath().toString();
        return sourceUri;
    }

    public String toString() {
        return "RawMaven{from=" + this.getSourceUri() + " / pom=" + this.pom + "}";
    }

    private RawMaven(Xml.Document document, RawPom pom, boolean projectPom, @Nullable MavenRepository repository) {
        this.document = document;
        this.pom = pom;
        this.projectPom = projectPom;
        this.repository = repository;
    }

    public RawMaven(Xml.Document document, RawPom pom, boolean projectPom) {
        this.document = document;
        this.pom = pom;
        this.projectPom = projectPom;
    }

    public Timer.Sample getSample() {
        return this.sample;
    }

    public Xml.Document getDocument() {
        return this.document;
    }

    public RawPom getPom() {
        return this.pom;
    }

    public boolean isProjectPom() {
        return this.projectPom;
    }

    @Nullable
    public MavenRepository getRepository() {
        return this.repository;
    }

    @NonNull
    public RawMaven withProjectPom(boolean projectPom) {
        return this.projectPom == projectPom ? this : new RawMaven(this.document, this.pom, projectPom, this.repository);
    }

    @NonNull
    public RawMaven withRepository(@Nullable MavenRepository repository) {
        return this.repository == repository ? this : new RawMaven(this.document, this.pom, this.projectPom, repository);
    }

    private static class MavenXmlParser
    extends XmlParser {
        private MavenXmlParser() {
        }

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    }
}

