/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.marker.XmlSearchResult;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="7.7.0")
public final class UpgradePluginVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Trust parent POM", description="Even if the parent suggests a version that is older than what we are trying to upgrade to, trust it anyway. Useful when you want to wait for the parent to catch up before upgrading. The parent is not trusted by default.", required=false)
    @Nullable
    private final Boolean trustParent;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven plugin version";
    }

    public String getDescription() {
        return "Upgrade the version of a plugin using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new MavenVisitor(){

            @Override
            public Maven visitMaven(Maven maven, ExecutionContext ctx) {
                if (!FindPlugin.find(maven, UpgradePluginVersion.this.groupId, UpgradePluginVersion.this.artifactId).isEmpty()) {
                    maven = maven.withMarkers(maven.getMarkers().addIfAbsent((Marker)new XmlSearchResult((Recipe)UpgradePluginVersion.this)));
                }
                return super.visitMaven(maven, ctx);
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UpgradePluginVersionVisitor();
    }

    public UpgradePluginVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean trustParent) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.trustParent = trustParent;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getTrustParent() {
        return this.trustParent;
    }

    @NonNull
    public String toString() {
        return "UpgradePluginVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", trustParent=" + this.getTrustParent() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradePluginVersion)) {
            return false;
        }
        UpgradePluginVersion other = (UpgradePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradePluginVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private static class ChangePluginVersionVisitor
    extends MavenVisitor {
        private final String groupId;
        private final String artifactId;
        private final String newVersion;

        private ChangePluginVersionVisitor(String groupId, String artifactId, String newVersion) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.newVersion = newVersion;
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            String version;
            Optional versionTag;
            if (this.isPluginTag(this.groupId, this.artifactId) && (versionTag = tag.getChild("version")).isPresent() && (version = (String)((Xml.Tag)versionTag.get()).getValue().orElse(null)) != null) {
                if (version.trim().startsWith("${") && !this.newVersion.equals(this.model.getValue(version.trim()))) {
                    this.doAfterVisit(new ChangePropertyValue(version, this.newVersion));
                } else if (!this.newVersion.equals(version)) {
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), this.newVersion));
                }
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }

    private class UpgradePluginVersionVisitor
    extends MavenVisitor {
        private final VersionComparator versionComparator;
        @Nullable
        private Collection<String> availableVersions;

        public UpgradePluginVersionVisitor() {
            this.versionComparator = (VersionComparator)Semver.validate((String)UpgradePluginVersion.this.newVersion, (String)UpgradePluginVersion.this.versionPattern).getValue();
        }

        @Override
        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            Maven m = super.visitMaven(maven, ctx);
            FindPlugin.find(m, UpgradePluginVersion.this.groupId, UpgradePluginVersion.this.artifactId).forEach(plugin -> this.maybeChangePluginVersion((Xml.Tag)plugin, ctx));
            return m;
        }

        private void maybeChangePluginVersion(Xml.Tag model, ExecutionContext ctx) {
            Optional versionTag = model.getChild("version");
            versionTag.ifPresent(tag -> tag.getValue().ifPresent(versionValue -> {
                String versionLookup;
                String string = versionLookup = versionValue.startsWith("${") ? this.model.getValue(versionValue.trim()) : versionValue;
                if (versionLookup != null) {
                    this.findNewerDependencyVersion(UpgradePluginVersion.this.groupId, UpgradePluginVersion.this.artifactId, versionLookup, ctx).ifPresent(newer -> {
                        ChangePluginVersionVisitor changeDependencyVersion = new ChangePluginVersionVisitor(UpgradePluginVersion.this.groupId, UpgradePluginVersion.this.artifactId, (String)newer);
                        this.doAfterVisit((TreeVisitor)changeDependencyVersion);
                    });
                }
            }));
        }

        private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) {
            if (this.availableVersions == null) {
                MavenMetadata mavenMetadata = new MavenPomDownloader(MavenPomCache.NOOP, Collections.emptyMap(), ctx).downloadMetadata(groupId, artifactId, Collections.emptyList());
                this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)this.versionComparator).isValid(arg_0)).collect(Collectors.toList());
            }
            LatestRelease latestRelease = new LatestRelease(UpgradePluginVersion.this.versionPattern);
            return this.availableVersions.stream().filter(v -> latestRelease.compare(currentVersion, v) < 0).max((Comparator<String>)this.versionComparator);
        }
    }
}

