/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;

@Incubating(since="7.7.0")
public final class RemovePlugin
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;

    public String getDisplayName() {
        return "Remove Maven plugin";
    }

    public String getDescription() {
        return "Remove the specified Maven plugin from the pom.xml.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemovePluginVisitor();
    }

    public RemovePlugin(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String toString() {
        return "RemovePlugin(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemovePlugin)) {
            return false;
        }
        RemovePlugin other = (RemovePlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemovePlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }

    private class RemovePluginVisitor
    extends MavenVisitor {
        private RemovePluginVisitor() {
        }

        @Override
        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            FindPlugin.find(maven, RemovePlugin.this.groupId, RemovePlugin.this.artifactId).forEach(plugin -> this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)plugin, true)));
            return super.visitMaven(maven, ctx);
        }
    }
}

