/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangePluginGroupIdAndArtifactId
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="my-deprecated-maven-plugin")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="my-new-maven-plugin", required=false)
    @Nullable
    private final String newArtifactId;

    @JsonCreator
    public ChangePluginGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
    }

    public String getDisplayName() {
        return "Change Maven plugin groupId and artifactId";
    }

    public String getDescription() {
        return "Change the groupId and/or the artifactId of a specified Maven plugin.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag(ChangePluginGroupIdAndArtifactId.this.oldGroupId, ChangePluginGroupIdAndArtifactId.this.oldArtifactId)) {
                    if (ChangePluginGroupIdAndArtifactId.this.newGroupId != null) {
                        t = this.changeChildTagValue(t, "groupId", ChangePluginGroupIdAndArtifactId.this.newGroupId, ctx);
                    }
                    if (ChangePluginGroupIdAndArtifactId.this.newArtifactId != null) {
                        t = this.changeChildTagValue(t, "artifactId", ChangePluginGroupIdAndArtifactId.this.newArtifactId, ctx);
                    }
                    if (t != tag) {
                        this.maybeUpdateModel();
                    }
                }
                return t;
            }

            private Xml.Tag changeChildTagValue(Xml.Tag tag, String childTagName, String newValue, ExecutionContext ctx) {
                Optional childTag = tag.getChild(childTagName);
                if (childTag.isPresent() && !newValue.equals(((Xml.Tag)childTag.get()).getValue().orElse(null))) {
                    tag = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)childTag.get(), newValue).visitNonNull((Tree)tag, (Object)ctx);
                }
                return tag;
            }
        };
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Nullable
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @NonNull
    public String toString() {
        return "ChangePluginGroupIdAndArtifactId(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginGroupIdAndArtifactId)) {
            return false;
        }
        ChangePluginGroupIdAndArtifactId other = (ChangePluginGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        return !(this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePluginGroupIdAndArtifactId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        return result;
    }
}

