/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerString;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.GroupArtifactRepository;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.JacksonMapdbSerializer;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.OptionalJacksonMapdbSerializer;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;

public class MapdbMavenPomCache
implements MavenPomCache {
    private static final Serializer<Optional<RawMaven>> MAVEN_SERIALIZER = new OptionalJacksonMapdbSerializer<RawMaven>(RawMaven.class);
    private static final Serializer<MavenRepository> REPOSITORY_SERIALIZER = new JacksonMapdbSerializer<MavenRepository>(MavenRepository.class);
    private static final Serializer<Optional<MavenRepository>> OPTIONAL_REPOSITORY_SERIALIZER = new OptionalJacksonMapdbSerializer<MavenRepository>(MavenRepository.class);
    private static final Serializer<Optional<MavenMetadata>> MAVEN_METADATA_SERIALIZER = new OptionalJacksonMapdbSerializer<MavenMetadata>(MavenMetadata.class);
    private static final Serializer<GroupArtifactRepository> GROUP_ARTIFACT_SERIALIZER = new JacksonMapdbSerializer<GroupArtifactRepository>(GroupArtifactRepository.class);
    private final HTreeMap<String, Optional<RawMaven>> pomCache;
    private final HTreeMap<GroupArtifactRepository, Optional<MavenMetadata>> mavenMetadataCache;
    private final HTreeMap<MavenRepository, Optional<MavenRepository>> normalizedRepositoryUrls;
    private final Set<String> unresolvablePoms = new HashSet<String>();
    CacheResult<RawMaven> UNAVAILABLE_POM = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<MavenMetadata> UNAVAILABLE_METADATA = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<MavenRepository> UNAVAILABLE_REPOSITORY = new CacheResult<Object>(CacheResult.State.Unavailable, null);

    public MapdbMavenPomCache(@Nullable File workspace, @Nullable Long maxCacheStoreSize) {
        if (workspace != null) {
            if (!workspace.exists() && !workspace.mkdirs()) {
                throw new IllegalStateException("Unable to find or create maven pom cache at " + workspace);
            }
            if (workspace.isDirectory()) {
                workspace = new File(workspace, "db");
            }
            DB localRepositoryDiskDb = DBMaker.fileDB((File)workspace).fileMmapEnableIfSupported().fileLockWait(10000L).checksumHeaderBypass().closeOnJvmShutdown().make();
            this.pomCache = localRepositoryDiskDb.hashMap("pom.disk").keySerializer((Serializer)new SerializerString()).valueSerializer(MAVEN_SERIALIZER).createOrOpen();
            this.fillUnresolvablePoms();
            this.mavenMetadataCache = localRepositoryDiskDb.hashMap("metadata.disk").keySerializer(GROUP_ARTIFACT_SERIALIZER).valueSerializer(MAVEN_METADATA_SERIALIZER).createOrOpen();
            this.normalizedRepositoryUrls = localRepositoryDiskDb.hashMap("repository.urls").keySerializer(REPOSITORY_SERIALIZER).valueSerializer(OPTIONAL_REPOSITORY_SERIALIZER).createOrOpen();
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "disk", "content", "poms"}), this.pomCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "disk", "content", "metadata"}), this.mavenMetadataCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "disk", "content", "repository urls"}), this.normalizedRepositoryUrls);
        } else {
            DB inMemoryDb = DBMaker.heapDB().make();
            this.pomCache = inMemoryDb.hashMap("pom.inmem").keySerializer((Serializer)new SerializerString()).valueSerializer(MAVEN_SERIALIZER).expireStoreSize(maxCacheStoreSize == null ? 0L : maxCacheStoreSize).create();
            this.fillUnresolvablePoms();
            this.mavenMetadataCache = inMemoryDb.hashMap("metadata.inmem").keySerializer(GROUP_ARTIFACT_SERIALIZER).valueSerializer(MAVEN_METADATA_SERIALIZER).expireStoreSize(maxCacheStoreSize == null ? 0L : maxCacheStoreSize).create();
            this.normalizedRepositoryUrls = inMemoryDb.hashMap("repository.urls").keySerializer(REPOSITORY_SERIALIZER).valueSerializer(OPTIONAL_REPOSITORY_SERIALIZER).create();
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "memory", "content", "pom"}), this.pomCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "memory", "content", "metadata"}), this.mavenMetadataCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "memory", "content", "repository urls"}), this.normalizedRepositoryUrls);
        }
    }

    private void fillUnresolvablePoms() {
        new BufferedReader(new InputStreamReader(MavenPomDownloader.class.getResourceAsStream("/unresolvable.txt"), StandardCharsets.UTF_8)).lines().filter(line -> !line.isEmpty()).forEach(this.unresolvablePoms::add);
    }

    @Override
    public CacheResult<MavenMetadata> computeMavenMetadata(URI repo, String groupId, String artifactId, Callable<MavenMetadata> orElseGet) throws Exception {
        GroupArtifactRepository gar = new GroupArtifactRepository(repo, new GroupArtifact(groupId, artifactId));
        Optional rawMavenMetadata = (Optional)this.mavenMetadataCache.get((Object)gar);
        if (rawMavenMetadata == null) {
            try {
                MavenMetadata metadata2 = orElseGet.call();
                this.mavenMetadataCache.put((Object)gar, Optional.ofNullable(metadata2));
                return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata2);
            }
            catch (Exception e) {
                this.mavenMetadataCache.put((Object)gar, Optional.empty());
                throw e;
            }
        }
        return rawMavenMetadata.map(metadata -> new CacheResult<MavenMetadata>(CacheResult.State.Cached, (MavenMetadata)metadata)).orElse(this.UNAVAILABLE_METADATA);
    }

    @Override
    public CacheResult<RawMaven> computeMaven(URI repo, String groupId, String artifactId, String version, Callable<RawMaven> orElseGet) throws Exception {
        String artifactCoordinates = groupId + ':' + artifactId + ':' + version;
        if (this.unresolvablePoms.contains(artifactCoordinates)) {
            return this.UNAVAILABLE_POM;
        }
        String cacheKey = repo.toString() + ":" + artifactCoordinates;
        Optional rawMaven = (Optional)this.pomCache.get((Object)cacheKey);
        if (rawMaven == null) {
            try {
                RawMaven maven = orElseGet.call();
                this.pomCache.put((Object)cacheKey, Optional.ofNullable(maven));
                return new CacheResult<RawMaven>(CacheResult.State.Updated, maven);
            }
            catch (Exception e) {
                this.pomCache.put((Object)cacheKey, Optional.empty());
                throw e;
            }
        }
        return rawMaven.map(pom -> new CacheResult<RawMaven>(CacheResult.State.Cached, (RawMaven)pom)).orElse(this.UNAVAILABLE_POM);
    }

    @Override
    public CacheResult<MavenRepository> computeRepository(MavenRepository repository, Callable<MavenRepository> orElseGet) throws Exception {
        Optional normalizedRepository = (Optional)this.normalizedRepositoryUrls.get((Object)repository);
        if (normalizedRepository == null) {
            try {
                MavenRepository repo = orElseGet.call();
                this.normalizedRepositoryUrls.put((Object)repository, Optional.ofNullable(repo));
                return new CacheResult<MavenRepository>(CacheResult.State.Updated, repo);
            }
            catch (Exception e) {
                this.normalizedRepositoryUrls.put((Object)repository, Optional.empty());
                throw e;
            }
        }
        return normalizedRepository.map(pom -> new CacheResult<MavenRepository>(CacheResult.State.Cached, (MavenRepository)pom)).orElse(this.UNAVAILABLE_REPOSITORY);
    }

    @Override
    public void close() {
        this.pomCache.close();
        this.mavenMetadataCache.close();
        this.normalizedRepositoryUrls.close();
    }
}

