/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.search.HasTypes;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.semver.Semver;

@Incubating(since="7.0.0")
public class AddDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private String versionPattern;
    @Option(displayName="Releases only", description="Whether to exclude snapshots from consideration.", required=false)
    private boolean releasesOnly = true;
    @Option(displayName="Classifier", description="A Maven classifier to add. Most commonly used to select shaded or test variants of a library", example="test", required=false)
    @Nullable
    private String classifier;
    @Option(displayName="Scope", valid={"compile", "test", "runtime", "provided"}, required=false)
    @Nullable
    private String scope;
    @Option(displayName="Type", valid={"jar", "pom"}, required=false)
    @Nullable
    private String type;
    @Option(displayName="Family pattern", description="A pattern, applied to groupIds, used to determine which other dependencies should have aligned version numbers. Accepts '*' as a wildcard character.", example="com.fasterxml.jackson*", required=false)
    @Nullable
    private String familyPattern;
    @Option(displayName="Only if using", description="Add the dependency only if using one of the supplied types. Types should be identified by fully qualified class name or a glob expression", example="org.junit.jupiter.api.*", required=false)
    @Nullable
    private List<String> onlyIfUsing;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.or(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Add Maven dependency";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        if (this.onlyIfUsing != null) {
            return new HasTypes(this.onlyIfUsing).getVisitor();
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AddDependencyVisitor(this.groupId, this.artifactId, this.version, this.versionPattern, this.releasesOnly, this.classifier, this.scope, this.type, this.familyPattern == null ? null : Pattern.compile(this.familyPattern.replace("*", ".*")));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    public boolean isReleasesOnly() {
        return this.releasesOnly;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getFamilyPattern() {
        return this.familyPattern;
    }

    @Nullable
    public List<String> getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    public AddDependency(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @JsonCreator
    public AddDependency(String groupId, String artifactId, String version, @Nullable String versionPattern, boolean releasesOnly, @Nullable String classifier, @Nullable String scope, @Nullable String type, @Nullable String familyPattern, @Nullable List<String> onlyIfUsing) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.releasesOnly = releasesOnly;
        this.classifier = classifier;
        this.scope = scope;
        this.type = type;
        this.familyPattern = familyPattern;
        this.onlyIfUsing = onlyIfUsing;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isReleasesOnly() != other.isReleasesOnly()) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$familyPattern = this.getFamilyPattern();
        String other$familyPattern = other.getFamilyPattern();
        if (this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern)) {
            return false;
        }
        List<String> this$onlyIfUsing = this.getOnlyIfUsing();
        List<String> other$onlyIfUsing = other.getOnlyIfUsing();
        return !(this$onlyIfUsing == null ? other$onlyIfUsing != null : !((Object)this$onlyIfUsing).equals(other$onlyIfUsing));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isReleasesOnly() ? 79 : 97);
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $familyPattern = this.getFamilyPattern();
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        List<String> $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : ((Object)$onlyIfUsing).hashCode());
        return result;
    }

    @NonNull
    public AddDependency withVersionPattern(@Nullable String versionPattern) {
        return this.versionPattern == versionPattern ? this : new AddDependency(this.groupId, this.artifactId, this.version, versionPattern, this.releasesOnly, this.classifier, this.scope, this.type, this.familyPattern, this.onlyIfUsing);
    }

    @NonNull
    public AddDependency withReleasesOnly(boolean releasesOnly) {
        return this.releasesOnly == releasesOnly ? this : new AddDependency(this.groupId, this.artifactId, this.version, this.versionPattern, releasesOnly, this.classifier, this.scope, this.type, this.familyPattern, this.onlyIfUsing);
    }

    @NonNull
    public AddDependency withClassifier(@Nullable String classifier) {
        return this.classifier == classifier ? this : new AddDependency(this.groupId, this.artifactId, this.version, this.versionPattern, this.releasesOnly, classifier, this.scope, this.type, this.familyPattern, this.onlyIfUsing);
    }

    @NonNull
    public AddDependency withScope(@Nullable String scope) {
        return this.scope == scope ? this : new AddDependency(this.groupId, this.artifactId, this.version, this.versionPattern, this.releasesOnly, this.classifier, scope, this.type, this.familyPattern, this.onlyIfUsing);
    }

    @NonNull
    public AddDependency withType(@Nullable String type) {
        return this.type == type ? this : new AddDependency(this.groupId, this.artifactId, this.version, this.versionPattern, this.releasesOnly, this.classifier, this.scope, type, this.familyPattern, this.onlyIfUsing);
    }

    @NonNull
    public AddDependency withFamilyPattern(@Nullable String familyPattern) {
        return this.familyPattern == familyPattern ? this : new AddDependency(this.groupId, this.artifactId, this.version, this.versionPattern, this.releasesOnly, this.classifier, this.scope, this.type, familyPattern, this.onlyIfUsing);
    }
}

