/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.util.Collection;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.MavenRepository;

public class MavenRepositoryCredentials {
    private final String id;
    private final String username;
    private final String password;

    public boolean matches(MavenRepository repository) {
        return this.id.equals(repository.getId());
    }

    public static MavenRepository apply(Collection<MavenRepositoryCredentials> credentials, MavenRepository repo) {
        MavenRepository mapped = repo;
        for (MavenRepositoryCredentials credential : credentials) {
            mapped = credential.apply(mapped);
        }
        return mapped;
    }

    public MavenRepository apply(MavenRepository repo) {
        return this.matches(repo) ? repo.withUsername(this.username).withPassword(this.password) : repo;
    }

    public MavenRepositoryCredentials(String id, String username, String password) {
        this.id = id;
        this.username = username;
        this.password = password;
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenRepositoryCredentials)) {
            return false;
        }
        MavenRepositoryCredentials other = (MavenRepositoryCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MavenRepositoryCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "MavenRepositoryCredentials(id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

