/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="7.7.0")
public final class FindPlugin
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;

    public static Set<Xml.Tag> find(Xml.Document maven, final String groupId, final String artifactId) {
        final HashSet<Xml.Tag> ds = new HashSet<Xml.Tag>();
        new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext context) {
                if (this.isPluginTag(groupId, artifactId)) {
                    ds.add(tag);
                }
                return super.visitTag(tag, context);
            }
        }.visit((Tree)maven, new InMemoryExecutionContext());
        return ds;
    }

    public String getDisplayName() {
        return "Find Maven plugin";
    }

    public String getDescription() {
        return "Finds a Maven plugin within a pom.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isPluginTag(FindPlugin.this.groupId, FindPlugin.this.artifactId)) {
                    return (Xml.Tag)SearchResult.found((Tree)tag);
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    public FindPlugin(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String toString() {
        return "FindPlugin(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPlugin)) {
            return false;
        }
        FindPlugin other = (FindPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }
}

