/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.DependencyDescriptor;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Scope;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Pom
implements Marker {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", null);
    private final UUID id;
    @Nullable
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String snapshotVersion;
    @Nullable
    private final String packaging;
    @Nullable
    private final String classifier;
    @Nullable
    private final Pom parent;
    private final Collection<Dependency> dependencies;
    private final DependencyManagement dependencyManagement;
    private final Collection<License> licenses;
    private final Collection<MavenRepository> repositories;
    private final Map<String, String> properties;
    private final Map<String, String> effectiveProperties;

    public Pom(UUID id, @Nullable String groupId, String artifactId, @Nullable String version, @Nullable String name, @Nullable String description, @Nullable String snapshotVersion, @Nullable String packaging, @Nullable String classifier, @Nullable Pom parent, Collection<Dependency> dependencies, DependencyManagement dependencyManagement, Collection<License> licenses, Collection<MavenRepository> repositories, Map<String, String> properties, Map<String, String> effectiveProperties) {
        this.id = id;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.name = name;
        this.description = description;
        this.snapshotVersion = snapshotVersion;
        this.packaging = packaging;
        this.classifier = classifier;
        this.parent = parent;
        this.dependencies = dependencies;
        this.dependencyManagement = dependencyManagement;
        this.licenses = licenses;
        this.repositories = repositories;
        this.properties = properties;
        this.effectiveProperties = effectiveProperties;
    }

    public Set<Dependency> getDependencies(Scope scope) {
        TreeSet<Dependency> dependenciesForScope = new TreeSet<Dependency>(Comparator.comparing(Dependency::getCoordinates));
        for (Dependency dependency : this.dependencies) {
            this.addDependenciesFromScope(scope, dependency, dependenciesForScope);
        }
        return dependenciesForScope;
    }

    public Set<Dependency> getDependencies(Dependency dependency, Scope scope) {
        TreeSet<Dependency> dependenciesForScope = new TreeSet<Dependency>(Comparator.comparing(Dependency::getCoordinates));
        this.addDependenciesFromScope(scope, dependency, dependenciesForScope);
        return dependenciesForScope;
    }

    private void addDependenciesFromScope(Scope scope, Dependency dep, Set<Dependency> found) {
        if (dep.getScope().isInClasspathOf(scope) || dep.getScope().equals((Object)scope)) {
            found.add(dep);
            for (Dependency child : dep.getModel().getDependencies()) {
                this.addDependenciesFromScope(scope, child, found);
            }
        }
    }

    @Nullable
    public String getValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return placeholderHelper.replacePlaceholders(value, this::getProperty);
    }

    @Nullable
    private String getProperty(@Nullable String property) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "groupId": 
            case "project.groupId": 
            case "pom.groupId": {
                return this.getGroupId();
            }
            case "project.parent.groupId": {
                return this.parent != null ? this.parent.getGroupId() : null;
            }
            case "artifactId": 
            case "project.artifactId": 
            case "pom.artifactId": {
                return this.getArtifactId();
            }
            case "project.parent.artifactId": {
                return this.parent == null ? null : this.parent.getArtifactId();
            }
            case "version": 
            case "project.version": 
            case "pom.version": {
                return this.getVersion();
            }
            case "project.parent.version": {
                return this.parent != null ? this.parent.getVersion() : null;
            }
        }
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        String key = property.replace("${", "").replace("}", "");
        return this.effectiveProperties.get(key);
    }

    public String getGroupId() {
        if (this.groupId == null) {
            if (this.parent == null) {
                throw new IllegalStateException("groupId must be defined");
            }
            return this.parent.getGroupId();
        }
        return this.groupId;
    }

    public DependencyManagement getEffectiveDependencyManagement() {
        if (this.parent == null) {
            return this.dependencyManagement;
        }
        return new DependencyManagement(Stream.concat(this.dependencyManagement.getDependencies().stream(), this.parent.getEffectiveDependencyManagement().getDependencies().stream()).collect(Collectors.toList()));
    }

    @Nullable
    public String getManagedVersion(String groupId, String artifactId) {
        return this.getEffectiveDependencyManagement().getManagedVersion(groupId, artifactId);
    }

    @Nullable
    public String getManagedScope(String groupId, String artifactId) {
        return this.getEffectiveDependencyManagement().getManagedScope(groupId, artifactId);
    }

    public Collection<Dependency> findDependencies(String groupId, String artifactId) {
        return this.dependencies.stream().flatMap(d -> d.findDependencies(groupId, artifactId).stream()).collect(Collectors.toList());
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        if (this.version == null) {
            if (this.parent == null) {
                throw new IllegalStateException("version must be defined");
            }
            return this.parent.getVersion();
        }
        return this.version;
    }

    public String getPackaging() {
        return this.packaging == null ? "jar" : this.packaging;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        return "Pom{" + this.groupId + ':' + this.artifactId + ':' + this.version + '}';
    }

    public UUID getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Nullable
    public Pom getParent() {
        return this.parent;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public Collection<License> getLicenses() {
        return this.licenses;
    }

    public Collection<MavenRepository> getRepositories() {
        return this.repositories;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getEffectiveProperties() {
        return this.effectiveProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pom)) {
            return false;
        }
        Pom other = (Pom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$snapshotVersion = this.getSnapshotVersion();
        String other$snapshotVersion = other.getSnapshotVersion();
        if (this$snapshotVersion == null ? other$snapshotVersion != null : !this$snapshotVersion.equals(other$snapshotVersion)) {
            return false;
        }
        String this$packaging = this.getPackaging();
        String other$packaging = other.getPackaging();
        if (this$packaging == null ? other$packaging != null : !this$packaging.equals(other$packaging)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        Pom this$parent = this.getParent();
        Pom other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Collection<Dependency> this$dependencies = this.getDependencies();
        Collection<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        DependencyManagement this$dependencyManagement = this.getDependencyManagement();
        DependencyManagement other$dependencyManagement = other.getDependencyManagement();
        if (this$dependencyManagement == null ? other$dependencyManagement != null : !((Object)this$dependencyManagement).equals(other$dependencyManagement)) {
            return false;
        }
        Collection<License> this$licenses = this.getLicenses();
        Collection<License> other$licenses = other.getLicenses();
        if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
            return false;
        }
        Collection<MavenRepository> this$repositories = this.getRepositories();
        Collection<MavenRepository> other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !((Object)this$repositories).equals(other$repositories)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Map<String, String> this$effectiveProperties = this.getEffectiveProperties();
        Map<String, String> other$effectiveProperties = other.getEffectiveProperties();
        return !(this$effectiveProperties == null ? other$effectiveProperties != null : !((Object)this$effectiveProperties).equals(other$effectiveProperties));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Pom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $snapshotVersion = this.getSnapshotVersion();
        result = result * 59 + ($snapshotVersion == null ? 43 : $snapshotVersion.hashCode());
        String $packaging = this.getPackaging();
        result = result * 59 + ($packaging == null ? 43 : $packaging.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        Pom $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Collection<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        DependencyManagement $dependencyManagement = this.getDependencyManagement();
        result = result * 59 + ($dependencyManagement == null ? 43 : ((Object)$dependencyManagement).hashCode());
        Collection<License> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        Collection<MavenRepository> $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : ((Object)$repositories).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Map<String, String> $effectiveProperties = this.getEffectiveProperties();
        result = result * 59 + ($effectiveProperties == null ? 43 : ((Object)$effectiveProperties).hashCode());
        return result;
    }

    @NonNull
    public Pom withDependencies(Collection<Dependency> dependencies) {
        return this.dependencies == dependencies ? this : new Pom(this.id, this.groupId, this.artifactId, this.version, this.name, this.description, this.snapshotVersion, this.packaging, this.classifier, this.parent, dependencies, this.dependencyManagement, this.licenses, this.repositories, this.properties, this.effectiveProperties);
    }

    @NonNull
    public Pom withLicenses(Collection<License> licenses) {
        return this.licenses == licenses ? this : new Pom(this.id, this.groupId, this.artifactId, this.version, this.name, this.description, this.snapshotVersion, this.packaging, this.classifier, this.parent, this.dependencies, this.dependencyManagement, licenses, this.repositories, this.properties, this.effectiveProperties);
    }

    public static class DependencyManagement {
        private final Collection<DependencyManagementDependency> dependencies;

        @Nullable
        public String getManagedVersion(String groupId, String artifactId) {
            for (DependencyManagementDependency dep : this.dependencies) {
                for (DependencyDescriptor dependencyDescriptor : dep.getDependencies()) {
                    if (!groupId.equals(dependencyDescriptor.getGroupId()) || !artifactId.equals(dependencyDescriptor.getArtifactId())) continue;
                    return dependencyDescriptor.getVersion();
                }
            }
            return null;
        }

        @Nullable
        public String getManagedScope(String groupId, String artifactId) {
            Enum scope = null;
            for (DependencyManagementDependency dep : this.dependencies) {
                for (DependencyDescriptor dependencyDescriptor : dep.getDependencies()) {
                    if (!groupId.equals(dependencyDescriptor.getGroupId()) || !artifactId.equals(dependencyDescriptor.getArtifactId())) continue;
                    scope = Scope.maxPrecedence((Scope)scope, dependencyDescriptor.getScope() == null ? Scope.Compile : dependencyDescriptor.getScope());
                }
            }
            return scope == null ? null : scope.name().toLowerCase();
        }

        public DependencyManagement(Collection<DependencyManagementDependency> dependencies) {
            this.dependencies = dependencies;
        }

        public Collection<DependencyManagementDependency> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyManagement)) {
                return false;
            }
            DependencyManagement other = (DependencyManagement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<DependencyManagementDependency> this$dependencies = this.getDependencies();
            Collection<DependencyManagementDependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof DependencyManagement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<DependencyManagementDependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "Pom.DependencyManagement(dependencies=" + this.getDependencies() + ")";
        }
    }

    public static class Dependency
    implements DependencyDescriptor {
        private final MavenRepository repository;
        private final Scope scope;
        @Nullable
        private final String classifier;
        @Nullable
        private final String type;
        private final boolean optional;
        private final Pom model;
        @Nullable
        private final String requestedVersion;
        @Nullable
        private final String datedSnapshotVersion;
        private final Set<GroupArtifact> exclusions;

        @Override
        public String getGroupId() {
            return this.model.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.model.getArtifactId();
        }

        @Override
        public String getVersion() {
            return this.model.getVersion();
        }

        public String getCoordinates() {
            return this.model.getGroupId() + ':' + this.model.getArtifactId() + ':' + this.model.getVersion() + (this.classifier == null ? "" : ':' + this.classifier);
        }

        public String toString() {
            return "Dependency {" + this.getCoordinates() + (this.optional ? ", optional" : "") + (!this.getVersion().equals(this.requestedVersion) ? ", requested=" + this.requestedVersion : "") + '}';
        }

        public Collection<Dependency> findDependencies(String groupId, String artifactId) {
            return this.findDependencies(d -> d.getGroupId().equals(groupId) && d.getArtifactId().equals(artifactId));
        }

        public Collection<Dependency> findDependencies(Predicate<Dependency> matcher) {
            ArrayList<Dependency> matches = new ArrayList<Dependency>();
            if (matcher.test(this)) {
                matches.add(this);
            }
            for (Dependency d : this.model.getDependencies()) {
                matches.addAll(d.findDependencies(matcher));
            }
            return matches;
        }

        public Dependency(MavenRepository repository, Scope scope, @Nullable String classifier, @Nullable String type, boolean optional, Pom model, @Nullable String requestedVersion, @Nullable String datedSnapshotVersion, Set<GroupArtifact> exclusions) {
            this.repository = repository;
            this.scope = scope;
            this.classifier = classifier;
            this.type = type;
            this.optional = optional;
            this.model = model;
            this.requestedVersion = requestedVersion;
            this.datedSnapshotVersion = datedSnapshotVersion;
            this.exclusions = exclusions;
        }

        public MavenRepository getRepository() {
            return this.repository;
        }

        @Override
        public Scope getScope() {
            return this.scope;
        }

        @Override
        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Pom getModel() {
            return this.model;
        }

        @Nullable
        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        @Nullable
        public String getDatedSnapshotVersion() {
            return this.datedSnapshotVersion;
        }

        @Override
        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            MavenRepository this$repository = this.getRepository();
            MavenRepository other$repository = other.getRepository();
            if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Pom this$model = this.getModel();
            Pom other$model = other.getModel();
            if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            if (this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion)) {
                return false;
            }
            String this$datedSnapshotVersion = this.getDatedSnapshotVersion();
            String other$datedSnapshotVersion = other.getDatedSnapshotVersion();
            if (this$datedSnapshotVersion == null ? other$datedSnapshotVersion != null : !this$datedSnapshotVersion.equals(other$datedSnapshotVersion)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Dependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            MavenRepository $repository = this.getRepository();
            result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Pom $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            String $datedSnapshotVersion = this.getDatedSnapshotVersion();
            result = result * 59 + ($datedSnapshotVersion == null ? 43 : $datedSnapshotVersion.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }
    }

    public static enum LicenseType {
        Apache2,
        BSD,
        CDDL,
        CreativeCommons,
        Eclipse,
        GPL,
        LGPL,
        MIT,
        Mozilla,
        PublicDomain,
        Unknown;

    }

    public static class License {
        private final String name;
        private final LicenseType type;

        public static License fromName(@Nullable String license) {
            if (license == null) {
                return new License("", LicenseType.Unknown);
            }
            switch (license) {
                case "Apache License, Version 2.0": 
                case "The Apache Software License, Version 2.0": {
                    return new License(license, LicenseType.Apache2);
                }
                case "GNU Lesser General Public License": 
                case "GNU Library General Public License": {
                    return new License(license, LicenseType.LGPL);
                }
                case "Public Domain": {
                    return new License(license, LicenseType.PublicDomain);
                }
            }
            if (license.contains("LGPL")) {
                return new License(license, LicenseType.LGPL);
            }
            if (license.contains("GPL") || license.contains("GNU General Public License")) {
                return new License(license, LicenseType.GPL);
            }
            if (license.contains("CDDL")) {
                return new License(license, LicenseType.CDDL);
            }
            if (license.contains("Creative Commons") || license.contains("CC0")) {
                return new License(license, LicenseType.CreativeCommons);
            }
            if (license.contains("BSD")) {
                return new License(license, LicenseType.BSD);
            }
            if (license.contains("MIT")) {
                return new License(license, LicenseType.MIT);
            }
            if (license.contains("Eclipse") || license.contains("EPL")) {
                return new License(license, LicenseType.Eclipse);
            }
            if (license.contains("Apache") || license.contains("ASF")) {
                return new License(license, LicenseType.Apache2);
            }
            if (license.contains("Mozilla")) {
                return new License(license, LicenseType.Mozilla);
            }
            if (license.toLowerCase().contains("GNU Lesser General Public License".toLowerCase()) || license.contains("GNU Library General Public License")) {
                return new License(license, LicenseType.LGPL);
            }
            return new License(license, LicenseType.Unknown);
        }

        public License(String name, LicenseType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public LicenseType getType() {
            return this.type;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            LicenseType this$type = this.getType();
            LicenseType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof License;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            LicenseType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "Pom.License(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }
}

