/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeDependencyVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava")
    @Nullable
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven dependency version";
    }

    public String getDescription() {
        return "Upgrade the version a group or group and artifact using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UpgradeDependencyVersionVisitor();
    }

    public UpgradeDependencyVersion(String groupId, @Nullable String artifactId, String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private class ChangeDependencyVersionVisitor
    extends MavenVisitor {
        private final String newVersion;
        private final String artifactId;

        private ChangeDependencyVersionVisitor(String newVersion, String artifactId) {
            this.newVersion = newVersion;
            this.artifactId = artifactId;
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            block5: {
                block3: {
                    Optional versionTag;
                    block4: {
                        String version;
                        block6: {
                            if (!this.isDependencyTag(UpgradeDependencyVersion.this.groupId, this.artifactId) && !this.isManagedDependencyTag(UpgradeDependencyVersion.this.groupId, this.artifactId)) break block3;
                            versionTag = tag.getChild("version");
                            if (!versionTag.isPresent()) break block4;
                            version = ((Xml.Tag)versionTag.get()).getValue().orElse(null);
                            if (version == null) break block5;
                            if (!version.trim().startsWith("${") || this.newVersion.equals(this.model.getValue(version.trim()))) break block6;
                            this.doAfterVisit(new ChangePropertyValue(version, this.newVersion));
                            break block5;
                        }
                        if (this.newVersion.equals(version)) break block5;
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), this.newVersion));
                        break block5;
                    }
                    if (versionTag.isPresent() || this.isManagedDependencyTag(UpgradeDependencyVersion.this.groupId, this.artifactId)) break block5;
                    Xml.Tag newVersionTag = Xml.Tag.build((String)("<version>" + this.newVersion + "</version>"));
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor((Xml.Tag)this.getCursor().getValue(), newVersionTag));
                    break block5;
                }
                if (!this.modules.isEmpty() && this.isPropertyTag()) {
                    String propertyKeyRef = "${" + tag.getName() + "}";
                    block0: for (Pom module : this.modules) {
                        for (Pom.Dependency dependency : module.getDependencies()) {
                            if (!propertyKeyRef.equals(dependency.getRequestedVersion())) continue;
                            this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, this.newVersion));
                            this.doAfterVisit(new RemoveRedundantDependencyVersions());
                            break block0;
                        }
                    }
                }
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }

    private class UpgradeDependencyVersionVisitor
    extends MavenVisitor {
        @Nullable
        private Collection<String> availableVersions;
        private final VersionComparator versionComparator;

        public UpgradeDependencyVersionVisitor() {
            this.versionComparator = (VersionComparator)Semver.validate((String)UpgradeDependencyVersion.this.newVersion, (String)UpgradeDependencyVersion.this.versionPattern).getValue();
        }

        @Override
        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            this.maybeChangeDependencyVersion(maven.getModel(), ctx);
            for (Pom module : maven.getModules()) {
                this.maybeChangeDependencyVersion(module, ctx);
            }
            return super.visitMaven(maven, ctx);
        }

        private void maybeChangeDependencyVersion(Pom model, ExecutionContext ctx) {
            for (Pom.Dependency dependency : model.getDependencies()) {
                if (!dependency.getGroupId().equals(UpgradeDependencyVersion.this.groupId) || UpgradeDependencyVersion.this.artifactId != null && !dependency.getArtifactId().equals(UpgradeDependencyVersion.this.artifactId)) continue;
                this.findNewerDependencyVersion(UpgradeDependencyVersion.this.groupId, dependency.getArtifactId(), dependency.getVersion(), ctx).ifPresent(newer -> {
                    ChangeDependencyVersionVisitor changeDependencyVersion = new ChangeDependencyVersionVisitor((String)newer, dependency.getArtifactId());
                    this.doAfterVisit((TreeVisitor)changeDependencyVersion);
                });
            }
            for (DependencyManagementDependency dependencyManagementDependency : model.getDependencyManagement().getDependencies()) {
                if (!dependencyManagementDependency.getGroupId().equals(UpgradeDependencyVersion.this.groupId) || UpgradeDependencyVersion.this.artifactId != null && !dependencyManagementDependency.getArtifactId().equals(UpgradeDependencyVersion.this.artifactId)) continue;
                this.findNewerDependencyVersion(UpgradeDependencyVersion.this.groupId, dependencyManagementDependency.getArtifactId(), dependencyManagementDependency.getVersion(), ctx).ifPresent(newer -> {
                    ChangeDependencyVersionVisitor changeDependencyVersion = new ChangeDependencyVersionVisitor((String)newer, dependencyManagementDependency.getArtifactId());
                    this.doAfterVisit((TreeVisitor)changeDependencyVersion);
                });
            }
        }

        private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) {
            if (this.availableVersions == null) {
                MavenMetadata mavenMetadata = new MavenPomDownloader(MavenPomCache.NOOP, Collections.emptyMap(), ctx).downloadMetadata(groupId, artifactId, Collections.emptyList());
                this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)this.versionComparator).isValid(arg_0)).collect(Collectors.toList());
            }
            LatestRelease latestRelease = new LatestRelease(UpgradeDependencyVersion.this.versionPattern);
            return this.availableVersions.stream().filter(v -> latestRelease.compare(currentVersion, v) < 0).max((Comparator<String>)this.versionComparator);
        }
    }
}

