/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.internal.Version;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class ManageDependencies
extends Recipe {
    private static final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the the first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.*")
    private final String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava*", required=false)
    @Nullable
    private final String artifactPattern;
    @Option(displayName="Version", description="Version to use for the dependency in dependency management. Defaults to the existing version found on the matching dependency.", required=false)
    @Nullable
    private final String version;

    public String getDisplayName() {
        return "Manage dependencies";
    }

    public String getDescription() {
        return "Make existing dependencies managed by moving their version to be specified in the dependencyManagement section of the POM.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ManageDependenciesVisitor(this.groupPattern == null ? null : Pattern.compile(this.groupPattern.replace("*", ".*")), this.artifactPattern == null ? null : Pattern.compile(this.artifactPattern.replace("*", ".*")));
    }

    public ManageDependencies(String groupPattern, @Nullable String artifactPattern, @Nullable String version) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.version = version;
    }

    public String getGroupPattern() {
        return this.groupPattern;
    }

    @Nullable
    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "ManageDependencies(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManageDependencies)) {
            return false;
        }
        ManageDependencies other = (ManageDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        if (this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ManageDependencies;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    private class ManageDependenciesVisitor
    extends MavenVisitor {
        private final Pattern groupPattern;
        @Nullable
        private final Pattern artifactPattern;
        @Nullable
        private String selectedVersion;

        private ManageDependenciesVisitor(@Nullable Pattern groupPattern, Pattern artifactPattern) {
            this.groupPattern = groupPattern;
            this.artifactPattern = artifactPattern;
        }

        @Override
        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            this.model = maven.getModel();
            Collection<Pom.Dependency> manageableDependencies = this.findDependencies(d -> this.groupPattern.matcher(d.getGroupId()).matches() && (this.artifactPattern == null || this.artifactPattern.matcher(d.getArtifactId()).matches()));
            this.selectedVersion = ManageDependencies.this.version;
            if (!manageableDependencies.isEmpty()) {
                List requiresDependencyManagement;
                if (ManageDependencies.this.version == null) {
                    this.selectedVersion = manageableDependencies.stream().map(Pom.Dependency::getVersion).max(Comparator.comparing(Version::new)).get();
                }
                if (!(requiresDependencyManagement = manageableDependencies.stream().filter(d -> this.model.getManagedVersion(d.getGroupId(), d.getArtifactId()) == null).map(d -> new GroupArtifact(d.getGroupId(), d.getArtifactId())).distinct().collect(Collectors.toList())).isEmpty()) {
                    Xml.Tag root = maven.getRoot();
                    if (!root.getChild("dependencyManagement").isPresent()) {
                        this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencyManagement>\n<dependencies/>\n</dependencyManagement>"), (Comparator)new MavenTagInsertionComparator(root.getChildren())));
                    }
                    for (GroupArtifact ga : requiresDependencyManagement) {
                        this.doAfterVisit((TreeVisitor)new InsertDependencyInOrder(ga.getGroupId(), ga.getArtifactId(), this.selectedVersion));
                    }
                }
            }
            return super.visitMaven(maven, ctx);
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isManagedDependencyTag() && this.hasMatchingGroupArtifact(tag)) {
                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)tag.getChild("version").orElseThrow(() -> new IllegalStateException("Version tag must exist")), this.selectedVersion));
            } else if (this.isDependencyTag() && this.hasMatchingGroupArtifact(tag)) {
                tag.getChild("version").ifPresent(version -> this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)version, false)));
                return tag;
            }
            return super.visitTag(tag, (Object)ctx);
        }

        private boolean hasMatchingGroupArtifact(Xml.Tag tag) {
            return this.groupPattern.matcher(tag.getChildValue("groupId").orElse(this.model.getGroupId())).matches() && (this.artifactPattern == null || this.artifactPattern.matcher(tag.getChildValue("artifactId").orElse(this.model.getArtifactId())).matches());
        }

        private class InsertDependencyInOrder
        extends MavenVisitor {
            private final String groupId;
            private final String artifactId;
            private final String version;

            private InsertDependencyInOrder(String groupId, String artifactId, String version) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (MANAGED_DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                    Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n<version>" + this.version + "</version>\n</dependency>"));
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getChildren(), dependencyTag)));
                    return tag;
                }
                return super.visitTag(tag, (Object)ctx);
            }
        }
    }
}

