/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.marker.JavaProvenance;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class MavenProjectParser {
    private static final Pattern mavenWrapperVersionPattern = Pattern.compile(".*apache-maven/(.*?)/.*");
    private final MavenParser mavenParser;
    private final MavenArtifactDownloader artifactDownloader;
    private final JavaParser.Builder<?, ?> javaParserBuilder;
    private final ExecutionContext ctx;

    public MavenProjectParser(MavenArtifactDownloader artifactDownloader, MavenParser.Builder mavenParserBuilder, JavaParser.Builder<?, ?> javaParserBuilder, ExecutionContext ctx) {
        this.mavenParser = mavenParserBuilder.build();
        this.artifactDownloader = artifactDownloader;
        this.javaParserBuilder = javaParserBuilder;
        this.ctx = ctx;
    }

    public List<SourceFile> parse(Path projectDirectory) {
        String propertiesTargetCompatibility;
        GitProvenance gitProvenance = GitProvenance.fromProjectDirectory((Path)projectDirectory);
        List mavens = this.mavenParser.parse(Maven.getMavenPoms(projectDirectory, this.ctx), projectDirectory, this.ctx);
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>(mavens);
        Path rootPomPath = Paths.get("pom.xml", new String[0]);
        Maven rootMaven = sourceFiles.stream().filter(f -> f.getSourcePath().equals(rootPomPath)).map(Maven.class::cast).findAny().orElseThrow(() -> new RuntimeException("Unable to locate root pom source file"));
        Pom rootMavenModel = rootMaven.getModel();
        mavens.sort((m1, m2) -> {
            Pom m1Model = m1.getModel();
            List m1Dependencies = m1Model.getDependencies().stream().filter(d -> d.getRepository() == null).collect(Collectors.toList());
            Pom m2Model = m2.getModel();
            List m2Dependencies = m2Model.getDependencies().stream().filter(d -> d.getRepository() == null).collect(Collectors.toList());
            if (m1Dependencies.stream().anyMatch(m1Dependency -> m1Dependency.getGroupId().equals(m2Model.getGroupId()) && m1Dependency.getArtifactId().equals(m2Model.getArtifactId()))) {
                return 1;
            }
            if (m2Dependencies.stream().anyMatch(m2Dependency -> m2Dependency.getGroupId().equals(m1Model.getGroupId()) && m2Dependency.getArtifactId().equals(m1Model.getArtifactId()))) {
                return -1;
            }
            return 0;
        });
        JavaParser javaParser = this.javaParserBuilder.build();
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        String sourceCompatibility = javaRuntimeVersion;
        String targetCompatibility = javaRuntimeVersion;
        String propertiesSourceCompatibility = rootMavenModel.getValue(rootMavenModel.getEffectiveProperties().get("maven.compiler.source"));
        if (propertiesSourceCompatibility != null) {
            sourceCompatibility = propertiesSourceCompatibility;
        }
        if ((propertiesTargetCompatibility = rootMavenModel.getValue(rootMavenModel.getEffectiveProperties().get("maven.compiler.target"))) != null) {
            targetCompatibility = propertiesTargetCompatibility;
        }
        Path wrapperPropertiesPath = projectDirectory.resolve(".mvn/wrapper/maven-wrapper.properties");
        String mavenVersion = "3.6";
        if (Files.exists(wrapperPropertiesPath, new LinkOption[0])) {
            try {
                Matcher wrapperVersionMatcher;
                Properties wrapperProperties = new Properties();
                wrapperProperties.load(new FileReader(wrapperPropertiesPath.toFile()));
                String distributionUrl = (String)wrapperProperties.get("distributionUrl");
                if (distributionUrl != null && (wrapperVersionMatcher = mavenWrapperVersionPattern.matcher(distributionUrl)).matches()) {
                    mavenVersion = wrapperVersionMatcher.group(1);
                }
            }
            catch (IOException e) {
                this.ctx.getOnError().accept(e);
            }
        }
        JavaProvenance.BuildTool buildTool = new JavaProvenance.BuildTool(JavaProvenance.BuildTool.Type.Maven, mavenVersion);
        JavaProvenance.JavaVersion javaVersion = new JavaProvenance.JavaVersion(javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility);
        JavaProvenance.Publication publication = new JavaProvenance.Publication(rootMavenModel.getGroupId(), rootMavenModel.getArtifactId(), rootMavenModel.getVersion());
        JavaProvenance mainProvenance = new JavaProvenance(Tree.randomId(), rootMavenModel.getName(), "main", buildTool, javaVersion, publication);
        JavaProvenance testProvenance = new JavaProvenance(Tree.randomId(), rootMavenModel.getName(), "test", buildTool, javaVersion, publication);
        for (Maven maven : mavens) {
            javaParser.setClasspath(this.downloadArtifacts(maven.getModel().getDependencies(Scope.Compile)));
            sourceFiles.addAll(ListUtils.map((List)javaParser.parse(maven.getJavaSources(projectDirectory, this.ctx), projectDirectory, this.ctx), s -> s.withMarkers(s.getMarkers().addOrUpdate((Marker)mainProvenance))));
            javaParser.setClasspath(this.downloadArtifacts(maven.getModel().getDependencies(Scope.Test)));
            sourceFiles.addAll(ListUtils.map((List)javaParser.parse(maven.getTestJavaSources(projectDirectory, this.ctx), projectDirectory, this.ctx), s -> s.withMarkers(s.getMarkers().addOrUpdate((Marker)testProvenance))));
            this.parseResources(maven.getResources(projectDirectory, this.ctx), projectDirectory, sourceFiles, mainProvenance);
            this.parseResources(maven.getTestResources(projectDirectory, this.ctx), projectDirectory, sourceFiles, testProvenance);
        }
        return ListUtils.map(sourceFiles, s -> s.withMarkers(s.getMarkers().addOrUpdate((Marker)gitProvenance)));
    }

    private void parseResources(List<Path> resources, Path projectDirectory, List<SourceFile> sourceFiles, JavaProvenance javaProvenance) {
        sourceFiles.addAll(ListUtils.map((List)new XmlParser().parse((Iterable)resources.stream().filter(p -> p.getFileName().toString().endsWith(".xml")).collect(Collectors.toList()), projectDirectory, this.ctx), s -> s.withMarkers(s.getMarkers().addOrUpdate((Marker)javaProvenance))));
        sourceFiles.addAll(ListUtils.map((List)new YamlParser().parse((Iterable)resources.stream().filter(p -> p.getFileName().toString().endsWith(".yml") || p.getFileName().toString().endsWith(".yaml")).collect(Collectors.toList()), projectDirectory, this.ctx), s -> s.withMarkers(s.getMarkers().addOrUpdate((Marker)javaProvenance))));
        sourceFiles.addAll(ListUtils.map((List)new PropertiesParser().parse((Iterable)resources.stream().filter(p -> p.getFileName().toString().endsWith(".properties")).collect(Collectors.toList()), projectDirectory, this.ctx), s -> s.withMarkers(s.getMarkers().addOrUpdate((Marker)javaProvenance))));
    }

    private List<Path> downloadArtifacts(Set<Pom.Dependency> dependencies) {
        return dependencies.stream().filter(d -> d.getRepository() != null).map(this.artifactDownloader::downloadArtifact).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

