/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.ProfileActivation;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.GroupArtifact;

@XmlRootElement(name="project")
public class RawPom {
    @Nullable
    private final Parent parent;
    @Nullable
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private String snapshotVersion;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String packaging;
    @Nullable
    private final Dependencies dependencies;
    @Nullable
    private final DependencyManagement dependencyManagement;
    @Nullable
    private final Map<String, String> properties;
    @Nullable
    private final RawRepositories repositories;
    @Nullable
    private final Licenses licenses;
    @Nullable
    private final Profiles profiles;

    public Map<String, String> getActiveProperties(Iterable<String> activeProfiles) {
        HashMap<String, String> activeProperties = new HashMap<String, String>();
        if (this.properties != null) {
            activeProperties.putAll(this.properties);
        }
        if (this.profiles != null) {
            for (Profile profile : this.getInnerProfiles()) {
                if (!profile.isActive(activeProfiles) || profile.getProperties() == null) continue;
                activeProperties.putAll(profile.getProperties());
            }
        }
        return activeProperties;
    }

    public Collection<Dependency> getActiveDependencyManagementDependencies(Iterable<String> activeProfiles) {
        ArrayList<Dependency> activeDependencies = new ArrayList<Dependency>();
        if (this.dependencyManagement != null && this.dependencyManagement.dependencies != null) {
            activeDependencies.addAll(this.dependencyManagement.dependencies.getDependencies());
        }
        if (this.profiles != null) {
            for (Profile profile : this.getInnerProfiles()) {
                if (!profile.isActive(activeProfiles) || profile.getDependencyManagement() == null || profile.getDependencyManagement().dependencies == null) continue;
                activeDependencies.addAll(profile.getDependencyManagement().dependencies.getDependencies());
            }
        }
        return activeDependencies;
    }

    public List<Dependency> getActiveDependencies(Collection<String> activeProfiles) {
        ArrayList<Dependency> activeDependencies = new ArrayList<Dependency>();
        if (this.dependencies != null) {
            activeDependencies.addAll(this.dependencies.getDependencies());
        }
        if (this.profiles != null) {
            for (Profile profile : this.getInnerProfiles()) {
                if (!profile.isActive(activeProfiles) || profile.dependencies == null) continue;
                activeDependencies.addAll(profile.dependencies.dependencies);
            }
        }
        return activeDependencies;
    }

    public List<RawRepositories.Repository> getActiveRepositories(Collection<String> activeProfiles) {
        ArrayList<RawRepositories.Repository> activeRepositories = new ArrayList<RawRepositories.Repository>();
        if (this.repositories != null) {
            activeRepositories.addAll(this.repositories.getRepositories());
        }
        if (this.profiles != null) {
            for (Profile profile : this.getInnerProfiles()) {
                if (!profile.isActive(activeProfiles) || profile.repositories == null) continue;
                activeRepositories.addAll(profile.repositories.getRepositories());
            }
        }
        return activeRepositories;
    }

    public List<License> getInnerLicenses() {
        return this.licenses == null ? Collections.emptyList() : this.licenses.getLicenses();
    }

    public List<Profile> getInnerProfiles() {
        return this.profiles == null ? Collections.emptyList() : this.profiles.getProfiles();
    }

    @Nullable
    public String getGroupId() {
        return this.groupId == null && this.parent != null ? this.parent.getGroupId() : this.groupId;
    }

    @Nullable
    public String getVersion() {
        return this.version == null && this.parent != null ? this.parent.getVersion() : this.version;
    }

    @NonNull
    public String toString() {
        return "RawPom(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", snapshotVersion=" + this.getSnapshotVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawPom)) {
            return false;
        }
        RawPom other = (RawPom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$snapshotVersion = this.getSnapshotVersion();
        String other$snapshotVersion = other.getSnapshotVersion();
        return !(this$snapshotVersion == null ? other$snapshotVersion != null : !this$snapshotVersion.equals(other$snapshotVersion));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RawPom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $snapshotVersion = this.getSnapshotVersion();
        result = result * 59 + ($snapshotVersion == null ? 43 : $snapshotVersion.hashCode());
        return result;
    }

    public RawPom(@Nullable Parent parent, @Nullable String groupId, String artifactId, @Nullable String version, @Nullable String name, @Nullable String description, @Nullable String packaging, @Nullable Dependencies dependencies, @Nullable DependencyManagement dependencyManagement, @Nullable Map<String, String> properties, @Nullable RawRepositories repositories, @Nullable Licenses licenses, @Nullable Profiles profiles) {
        this.parent = parent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.name = name;
        this.description = description;
        this.packaging = packaging;
        this.dependencies = dependencies;
        this.dependencyManagement = dependencyManagement;
        this.properties = properties;
        this.repositories = repositories;
        this.licenses = licenses;
        this.profiles = profiles;
    }

    @Nullable
    public Parent getParent() {
        return this.parent;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getPackaging() {
        return this.packaging;
    }

    @Nullable
    public Dependencies getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nullable
    public RawRepositories getRepositories() {
        return this.repositories;
    }

    @Nullable
    public Licenses getLicenses() {
        return this.licenses;
    }

    @Nullable
    public Profiles getProfiles() {
        return this.profiles;
    }

    void setSnapshotVersion(@Nullable String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public static class Profile {
        @Nullable
        private final String id;
        @Nullable
        private final ProfileActivation activation;
        @Nullable
        private final Map<String, String> properties;
        @Nullable
        private final Dependencies dependencies;
        @Nullable
        private final DependencyManagement dependencyManagement;
        @Nullable
        private final RawRepositories repositories;

        public boolean isActive(Iterable<String> activeProfiles) {
            return ProfileActivation.isActive(this.id, activeProfiles, this.activation);
        }

        public Profile(@Nullable String id, @Nullable ProfileActivation activation, @Nullable Map<String, String> properties, @Nullable Dependencies dependencies, @Nullable DependencyManagement dependencyManagement, @Nullable RawRepositories repositories) {
            this.id = id;
            this.activation = activation;
            this.properties = properties;
            this.dependencies = dependencies;
            this.dependencyManagement = dependencyManagement;
            this.repositories = repositories;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public ProfileActivation getActivation() {
            return this.activation;
        }

        @Nullable
        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Nullable
        public Dependencies getDependencies() {
            return this.dependencies;
        }

        @Nullable
        public DependencyManagement getDependencyManagement() {
            return this.dependencyManagement;
        }

        @Nullable
        public RawRepositories getRepositories() {
            return this.repositories;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ProfileActivation this$activation = this.getActivation();
            ProfileActivation other$activation = other.getActivation();
            if (this$activation == null ? other$activation != null : !((Object)this$activation).equals(other$activation)) {
                return false;
            }
            Map<String, String> this$properties = this.getProperties();
            Map<String, String> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            Dependencies this$dependencies = this.getDependencies();
            Dependencies other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !this$dependencies.equals(other$dependencies)) {
                return false;
            }
            DependencyManagement this$dependencyManagement = this.getDependencyManagement();
            DependencyManagement other$dependencyManagement = other.getDependencyManagement();
            if (this$dependencyManagement == null ? other$dependencyManagement != null : !this$dependencyManagement.equals(other$dependencyManagement)) {
                return false;
            }
            RawRepositories this$repositories = this.getRepositories();
            RawRepositories other$repositories = other.getRepositories();
            return !(this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ProfileActivation $activation = this.getActivation();
            result = result * 59 + ($activation == null ? 43 : ((Object)$activation).hashCode());
            Map<String, String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            Dependencies $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : $dependencies.hashCode());
            DependencyManagement $dependencyManagement = this.getDependencyManagement();
            result = result * 59 + ($dependencyManagement == null ? 43 : $dependencyManagement.hashCode());
            RawRepositories $repositories = this.getRepositories();
            result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RawPom.Profile(id=" + this.getId() + ", activation=" + this.getActivation() + ", properties=" + this.getProperties() + ", dependencies=" + this.getDependencies() + ", dependencyManagement=" + this.getDependencyManagement() + ", repositories=" + this.getRepositories() + ")";
        }
    }

    public static class License {
        private final String name;

        public License() {
            this.name = "";
        }

        public License(@JsonProperty(value="name") String name) {
            this.name = name;
        }

        @NonNull
        public String toString() {
            return "RawPom.License(name=" + this.getName() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof License;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Parent {
        private final String groupId;
        private final String artifactId;
        private final String version;
        @Nullable
        private final String relativePath;

        public Parent(String groupId, String artifactId, String version, @Nullable String relativePath) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.relativePath = relativePath;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getRelativePath() {
            return this.relativePath;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parent)) {
                return false;
            }
            Parent other = (Parent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$relativePath = this.getRelativePath();
            String other$relativePath = other.getRelativePath();
            return !(this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Parent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $relativePath = this.getRelativePath();
            result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RawPom.Parent(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", relativePath=" + this.getRelativePath() + ")";
        }
    }

    public static class Profiles {
        private final List<Profile> profiles;

        public Profiles() {
            this.profiles = Collections.emptyList();
        }

        public Profiles(@JacksonXmlProperty(localName="profile") List<Profile> profiles) {
            this.profiles = profiles;
        }

        public List<Profile> getProfiles() {
            return this.profiles;
        }
    }

    public static class Licenses {
        private final List<License> licenses;

        public Licenses() {
            this.licenses = Collections.emptyList();
        }

        public Licenses(@JacksonXmlProperty(localName="license") List<License> licenses) {
            this.licenses = licenses;
        }

        public List<License> getLicenses() {
            return this.licenses;
        }
    }

    public static class Dependencies {
        private final List<Dependency> dependencies;

        public Dependencies() {
            this.dependencies = Collections.emptyList();
        }

        public Dependencies(@JacksonXmlProperty(localName="dependency") List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }
    }

    public static class DependencyManagement {
        @Nullable
        private final Dependencies dependencies;

        public DependencyManagement() {
            this.dependencies = null;
        }

        public DependencyManagement(@JsonProperty(value="dependencies") @Nullable Dependencies dependencies) {
            this.dependencies = dependencies;
        }

        @Nullable
        public Dependencies getDependencies() {
            return this.dependencies;
        }
    }

    public static class Dependency {
        private final String groupId;
        private final String artifactId;
        @Nullable
        private final String version;
        @Nullable
        private final String scope;
        @Nullable
        private final String type;
        @Nullable
        private final String classifier;
        @Nullable
        private final Boolean optional;
        @Nullable
        @JacksonXmlElementWrapper(useWrapping=true)
        private final Set<GroupArtifact> exclusions;

        public Dependency(String groupId, String artifactId, @Nullable String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, @Nullable Set<GroupArtifact> exclusions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.scope = scope;
            this.type = type;
            this.classifier = classifier;
            this.optional = optional;
            this.exclusions = exclusions;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getScope() {
            return this.scope;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        @Nullable
        public Boolean getOptional() {
            return this.optional;
        }

        @Nullable
        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$optional = this.getOptional();
            Boolean other$optional = other.getOptional();
            if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Dependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $optional = this.getOptional();
            result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RawPom.Dependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", optional=" + this.getOptional() + ", exclusions=" + this.getExclusions() + ")";
        }
    }
}

