/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectParser {
    private static final Pattern mavenWrapperVersionPattern = Pattern.compile(".*apache-maven/(.*?)/.*");
    private static final Logger logger = LoggerFactory.getLogger(MavenProjectParser.class);
    private final MavenParser mavenParser;
    private final MavenArtifactDownloader artifactDownloader;
    private final JavaParser.Builder<?, ?> javaParserBuilder;
    private final ExecutionContext ctx;

    public MavenProjectParser(MavenArtifactDownloader artifactDownloader, MavenParser.Builder mavenParserBuilder, JavaParser.Builder<?, ?> javaParserBuilder, ExecutionContext ctx) {
        this.mavenParser = mavenParserBuilder.build();
        this.artifactDownloader = artifactDownloader;
        this.javaParserBuilder = javaParserBuilder;
        this.ctx = ctx;
    }

    public List<SourceFile> parse(Path projectDirectory) {
        List<Maven> mavens = this.mavenParser.parse(Maven.getMavenPoms(projectDirectory, this.ctx), projectDirectory, this.ctx);
        mavens = MavenProjectParser.sort(mavens);
        JavaParser javaParser = this.javaParserBuilder.build();
        logger.info("The order in which projects are being parsed is:");
        for (Maven maven : mavens) {
            logger.info("  {}:{}", (Object)maven.getModel().getGroupId(), (Object)maven.getModel().getArtifactId());
        }
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        for (Maven maven : mavens) {
            List<Marker> projectProvenance = this.getJavaProvenance(maven, projectDirectory);
            sourceFiles.add((SourceFile)this.addProjectProvenance(maven, projectProvenance));
            List<Path> dependencies = this.downloadArtifacts(maven.getModel().getDependencies(Scope.Compile));
            javaParser.setSourceSet("main");
            javaParser.setClasspath(dependencies);
            sourceFiles.addAll(ListUtils.map((List)javaParser.parse(maven.getJavaSources(projectDirectory, this.ctx), projectDirectory, this.ctx), this.addProvenance(projectProvenance)));
            this.parseResources(maven.getResources(projectDirectory, this.ctx), projectDirectory, sourceFiles, projectProvenance, javaParser.getSourceSet(this.ctx));
            List<Path> testDependencies = this.downloadArtifacts(maven.getModel().getDependencies(Scope.Test));
            javaParser.setSourceSet("test");
            javaParser.setClasspath(testDependencies);
            sourceFiles.addAll(ListUtils.map((List)javaParser.parse(maven.getTestJavaSources(projectDirectory, this.ctx), projectDirectory, this.ctx), this.addProvenance(projectProvenance)));
            this.parseResources(maven.getTestResources(projectDirectory, this.ctx), projectDirectory, sourceFiles, projectProvenance, javaParser.getSourceSet(this.ctx));
        }
        return sourceFiles;
    }

    private List<Marker> getJavaProvenance(Maven maven, Path projectDirectory) {
        String propertiesTargetCompatibility;
        Pom mavenModel = maven.getModel();
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        String sourceCompatibility = javaRuntimeVersion;
        String targetCompatibility = javaRuntimeVersion;
        String propertiesSourceCompatibility = mavenModel.getValue(mavenModel.getValue("maven.compiler.source"));
        if (propertiesSourceCompatibility != null) {
            sourceCompatibility = propertiesSourceCompatibility;
        }
        if ((propertiesTargetCompatibility = mavenModel.getValue(mavenModel.getValue("maven.compiler.target"))) != null) {
            targetCompatibility = propertiesTargetCompatibility;
        }
        Path wrapperPropertiesPath = projectDirectory.resolve(".mvn/wrapper/maven-wrapper.properties");
        String mavenVersion = "3.6";
        if (Files.exists(wrapperPropertiesPath, new LinkOption[0])) {
            try {
                Matcher wrapperVersionMatcher;
                Properties wrapperProperties = new Properties();
                wrapperProperties.load(new FileReader(wrapperPropertiesPath.toFile()));
                String distributionUrl = (String)wrapperProperties.get("distributionUrl");
                if (distributionUrl != null && (wrapperVersionMatcher = mavenWrapperVersionPattern.matcher(distributionUrl)).matches()) {
                    mavenVersion = wrapperVersionMatcher.group(1);
                }
            }
            catch (IOException e) {
                this.ctx.getOnError().accept(e);
            }
        }
        return Arrays.asList(new BuildTool(Tree.randomId(), BuildTool.Type.Maven, mavenVersion), new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility), new JavaProject(Tree.randomId(), mavenModel.getName(), new JavaProject.Publication(mavenModel.getGroupId(), mavenModel.getArtifactId(), mavenModel.getVersion())));
    }

    private void parseResources(List<Path> resources, Path projectDirectory, List<SourceFile> sourceFiles, List<Marker> projectProvenance, JavaSourceSet sourceSet) {
        ArrayList<Marker> provenance = new ArrayList<Marker>(projectProvenance);
        provenance.add((Marker)sourceSet);
        sourceFiles.addAll(ListUtils.map((List)new XmlParser().parse((Iterable)resources.stream().filter(p -> p.getFileName().toString().endsWith(".xml") || p.getFileName().toString().endsWith(".wsdl") || p.getFileName().toString().endsWith(".xhtml") || p.getFileName().toString().endsWith(".xsd") || p.getFileName().toString().endsWith(".xsl") || p.getFileName().toString().endsWith(".xslt")).collect(Collectors.toList()), projectDirectory, this.ctx), this.addProvenance(provenance)));
        sourceFiles.addAll(ListUtils.map((List)new YamlParser().parse((Iterable)resources.stream().filter(p -> p.getFileName().toString().endsWith(".yml") || p.getFileName().toString().endsWith(".yaml")).collect(Collectors.toList()), projectDirectory, this.ctx), this.addProvenance(provenance)));
        sourceFiles.addAll(ListUtils.map((List)new PropertiesParser().parse((Iterable)resources.stream().filter(p -> p.getFileName().toString().endsWith(".properties")).collect(Collectors.toList()), projectDirectory, this.ctx), this.addProvenance(provenance)));
    }

    private <S extends SourceFile> S addProjectProvenance(S s, List<Marker> projectProvenance) {
        for (Marker marker : projectProvenance) {
            s = s.withMarkers(s.getMarkers().addIfAbsent(marker));
        }
        return s;
    }

    private <S extends SourceFile> UnaryOperator<S> addProvenance(List<Marker> projectProvenance) {
        return s -> {
            s = this.addProjectProvenance(s, projectProvenance);
            return s;
        };
    }

    private List<Path> downloadArtifacts(Set<Pom.Dependency> dependencies) {
        return dependencies.stream().filter(d -> d.getRepository() != null).map(this.artifactDownloader::downloadArtifact).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Maven> sort(List<Maven> mavens) {
        HashMap<Maven, Set> byDependedOn = new HashMap<Maven, Set>();
        for (Maven maven : mavens) {
            byDependedOn.computeIfAbsent(maven, m -> new HashSet());
            for (Pom.Dependency dependency : maven.getModel().getDependencies()) {
                for (Maven test : mavens) {
                    if (!test.getModel().getGroupId().equals(dependency.getGroupId()) || !test.getModel().getArtifactId().equals(dependency.getArtifactId())) continue;
                    byDependedOn.computeIfAbsent(maven, m -> new HashSet()).add(test);
                }
            }
        }
        ArrayList<Maven> sorted = new ArrayList<Maven>(mavens.size());
        block3: while (!byDependedOn.isEmpty()) {
            for (Map.Entry mavenAndDependencies : byDependedOn.entrySet()) {
                if (!((Set)mavenAndDependencies.getValue()).isEmpty()) continue;
                Maven maven = (Maven)((Object)mavenAndDependencies.getKey());
                byDependedOn.remove((Object)maven);
                sorted.add(maven);
                for (Set dependencies : byDependedOn.values()) {
                    dependencies.remove((Object)maven);
                }
                continue block3;
            }
        }
        return sorted;
    }
}

