/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.DependencyDescriptor;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Scope;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public final class Pom {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", null);
    private static final Map<Pom, List<Pom>> flyweights = new WeakHashMap<Pom, List<Pom>>();
    @Nullable
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String datedSnapshotVersion;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String packaging;
    @Nullable
    private final String classifier;
    @Nullable
    private final Pom parent;
    private final List<Dependency> dependencies;
    private final DependencyManagement dependencyManagement;
    private final Collection<License> licenses;
    private final Collection<MavenRepository> repositories;
    private final Map<String, String> properties;
    private final Map<String, String> propertyOverrides;

    public static void clearCaches() {
        flyweights.clear();
    }

    public Collection<MavenRepository> getEffectiveRepositories() {
        ArrayList<MavenRepository> allRepositories = new ArrayList<MavenRepository>(this.repositories);
        for (Pom ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
            allRepositories.addAll(ancestor.getRepositories());
        }
        return allRepositories;
    }

    public Set<Dependency> getDependencies(Scope scope) {
        TreeSet<Dependency> dependenciesForScope = new TreeSet<Dependency>(Comparator.comparing(Dependency::getCoordinates));
        for (Dependency dependency : this.dependencies) {
            this.addDependenciesFromScope(scope, dependency, dependenciesForScope);
        }
        return dependenciesForScope;
    }

    public Set<Dependency> getDependencies(Dependency dependency, Scope scope) {
        TreeSet<Dependency> dependenciesForScope = new TreeSet<Dependency>(Comparator.comparing(Dependency::getCoordinates));
        this.addDependenciesFromScope(scope, dependency, dependenciesForScope);
        return dependenciesForScope;
    }

    private void addDependenciesFromScope(Scope scope, Dependency dep, Set<Dependency> found) {
        if (dep.getScope().isInClasspathOf(scope) || dep.getScope().equals((Object)scope)) {
            found.add(dep);
            for (Dependency child : dep.getModel().getDependencies()) {
                this.addDependenciesFromScope(scope, child, found);
            }
        }
    }

    @Nullable
    public String getValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return placeholderHelper.replacePlaceholders(value, this::getProperty);
    }

    @Nullable
    private String getProperty(@Nullable String property) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "groupId": 
            case "project.groupId": 
            case "pom.groupId": {
                return this.getGroupId();
            }
            case "project.parent.groupId": {
                return this.parent != null ? this.parent.getGroupId() : null;
            }
            case "artifactId": 
            case "project.artifactId": 
            case "pom.artifactId": {
                return this.getArtifactId();
            }
            case "project.parent.artifactId": {
                return this.parent == null ? null : this.parent.getArtifactId();
            }
            case "version": 
            case "project.version": 
            case "pom.version": {
                return this.getVersion();
            }
            case "project.parent.version": {
                return this.parent != null ? this.parent.getVersion() : null;
            }
        }
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        String key = property.replace("${", "").replace("}", "");
        value = this.propertyOverrides.get(key);
        if (value != null) {
            return value;
        }
        value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.getProperty(key);
        }
        return null;
    }

    public String getGroupId() {
        if (this.groupId == null) {
            if (this.parent == null) {
                throw new IllegalStateException("groupId must be defined");
            }
            return this.parent.getGroupId();
        }
        return this.groupId;
    }

    public DependencyManagement getEffectiveDependencyManagement() {
        if (this.parent == null) {
            return this.dependencyManagement;
        }
        return new DependencyManagement(Stream.concat(this.dependencyManagement.getDependencies().stream(), this.parent.getEffectiveDependencyManagement().getDependencies().stream()).collect(Collectors.toList()));
    }

    @Nullable
    public String getManagedVersion(String groupId, String artifactId) {
        return this.getEffectiveDependencyManagement().getManagedVersion(groupId, artifactId);
    }

    @Nullable
    public String getManagedScope(String groupId, String artifactId) {
        return this.getEffectiveDependencyManagement().getManagedScope(groupId, artifactId);
    }

    public Collection<Dependency> findDependencies(String groupId, String artifactId) {
        return this.dependencies.stream().flatMap(d -> d.findDependencies(groupId, artifactId).stream()).collect(Collectors.toList());
    }

    public String getVersion() {
        if (this.version == null) {
            if (this.parent == null) {
                throw new IllegalStateException("version must be defined");
            }
            return this.parent.getVersion();
        }
        return this.version;
    }

    public String getCoordinates() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public String getPackaging() {
        return this.packaging == null ? "jar" : this.packaging;
    }

    public boolean deepEquals(@Nullable Pom other) {
        return this == other || other != null && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.version, other.version) && Objects.equals(this.datedSnapshotVersion, other.datedSnapshotVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.packaging, other.packaging) && Objects.equals(this.propertyOverrides, other.propertyOverrides) && Objects.equals(this.properties, other.properties) && Objects.equals(this.repositories, other.repositories) && Objects.equals(this.licenses, other.licenses) && (this.dependencyManagement == other.dependencyManagement || this.dependencyManagement.deepEquals(other.dependencyManagement)) && (this.parent == other.parent || this.parent != null && this.parent.deepEquals(other.parent)) && Objects.equals(this.dependencies, other.dependencies);
    }

    public Pom withVersion(String version) {
        if (Objects.equals(this.version, version)) {
            return this;
        }
        return Pom.build(this.groupId, this.artifactId, version, this.datedSnapshotVersion, this.name, this.description, this.packaging, this.classifier, this.parent, this.dependencies, this.dependencyManagement, this.licenses, this.repositories, this.properties, this.propertyOverrides, false);
    }

    public Pom withDependencies(List<Dependency> dependencies) {
        if (Objects.equals(this.dependencies, dependencies)) {
            return this;
        }
        return Pom.build(this.groupId, this.artifactId, this.version, this.datedSnapshotVersion, this.name, this.description, this.packaging, this.classifier, this.parent, dependencies, this.dependencyManagement, this.licenses, this.repositories, this.properties, this.propertyOverrides, false);
    }

    public Pom withDependencyManagement(DependencyManagement dependencyManagement) {
        if (Objects.equals(this.dependencyManagement, dependencyManagement)) {
            return this;
        }
        return Pom.build(this.groupId, this.artifactId, this.version, this.datedSnapshotVersion, this.name, this.description, this.packaging, this.classifier, this.parent, this.dependencies, dependencyManagement, this.licenses, this.repositories, this.properties, this.propertyOverrides, false);
    }

    public Pom withLicenses(List<License> licenses) {
        if (Objects.equals(this.licenses, licenses)) {
            return this;
        }
        return Pom.build(this.groupId, this.artifactId, this.version, this.datedSnapshotVersion, this.name, this.description, this.packaging, this.classifier, this.parent, this.dependencies, this.dependencyManagement, licenses, this.repositories, this.properties, this.propertyOverrides, false);
    }

    public static Pom build(@Nullable String groupId, String artifactId, @Nullable String version, @Nullable String datedSnapshotVersion) {
        return Pom.build(groupId, artifactId, version, datedSnapshotVersion, null, null, null, null, null, Collections.emptyList(), DependencyManagement.empty(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static Pom build(@Nullable String groupId, String artifactId, @Nullable String version, @Nullable String datedSnapshotVersion, @Nullable String name, @Nullable String description, @Nullable String packaging, @Nullable String classifier, @Nullable Pom parent, List<Dependency> dependencies, DependencyManagement dependencyManagement, Collection<License> licenses, Collection<MavenRepository> repositories, Map<String, String> properties, Map<String, String> propertyOverrides, boolean relaxedMatching) {
        Pom candidate = new Pom(groupId, artifactId, version, datedSnapshotVersion, name, description, packaging, classifier, parent, dependencies, dependencyManagement, licenses, repositories, properties, propertyOverrides);
        List variants = flyweights.get(candidate);
        if (relaxedMatching && variants != null && !variants.isEmpty()) {
            return variants.iterator().next();
        }
        Map<Pom, List<Pom>> map = flyweights;
        synchronized (map) {
            variants = flyweights.computeIfAbsent(candidate, k -> new ArrayList());
            if (relaxedMatching) {
                if (variants.isEmpty()) {
                    variants.add(candidate);
                    return candidate;
                }
                return (Pom)variants.iterator().next();
            }
            for (Pom v : variants) {
                if (!v.deepEquals(candidate)) continue;
                return v;
            }
            variants.add(candidate);
            return candidate;
        }
    }

    public String toString() {
        return "Pom{" + this.groupId + ':' + this.artifactId + ':' + this.version + '}';
    }

    public Pom(@Nullable String groupId, String artifactId, @Nullable String version, @Nullable String datedSnapshotVersion, @Nullable String name, @Nullable String description, @Nullable String packaging, @Nullable String classifier, @Nullable Pom parent, List<Dependency> dependencies, DependencyManagement dependencyManagement, Collection<License> licenses, Collection<MavenRepository> repositories, Map<String, String> properties, Map<String, String> propertyOverrides) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.datedSnapshotVersion = datedSnapshotVersion;
        this.name = name;
        this.description = description;
        this.packaging = packaging;
        this.classifier = classifier;
        this.parent = parent;
        this.dependencies = dependencies;
        this.dependencyManagement = dependencyManagement;
        this.licenses = licenses;
        this.repositories = repositories;
        this.properties = properties;
        this.propertyOverrides = propertyOverrides;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pom)) {
            return false;
        }
        Pom other = (Pom)o;
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$datedSnapshotVersion = this.getDatedSnapshotVersion();
        String other$datedSnapshotVersion = other.getDatedSnapshotVersion();
        if (this$datedSnapshotVersion == null ? other$datedSnapshotVersion != null : !this$datedSnapshotVersion.equals(other$datedSnapshotVersion)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        Map<String, String> this$propertyOverrides = this.getPropertyOverrides();
        Map<String, String> other$propertyOverrides = other.getPropertyOverrides();
        return !(this$propertyOverrides == null ? other$propertyOverrides != null : !((Object)this$propertyOverrides).equals(other$propertyOverrides));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $datedSnapshotVersion = this.getDatedSnapshotVersion();
        result = result * 59 + ($datedSnapshotVersion == null ? 43 : $datedSnapshotVersion.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        Map<String, String> $propertyOverrides = this.getPropertyOverrides();
        result = result * 59 + ($propertyOverrides == null ? 43 : ((Object)$propertyOverrides).hashCode());
        return result;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getDatedSnapshotVersion() {
        return this.datedSnapshotVersion;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Pom withPackaging(@Nullable String packaging) {
        return this.packaging == packaging ? this : new Pom(this.groupId, this.artifactId, this.version, this.datedSnapshotVersion, this.name, this.description, packaging, this.classifier, this.parent, this.dependencies, this.dependencyManagement, this.licenses, this.repositories, this.properties, this.propertyOverrides);
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public Pom getParent() {
        return this.parent;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public Collection<License> getLicenses() {
        return this.licenses;
    }

    public Collection<MavenRepository> getRepositories() {
        return this.repositories;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getPropertyOverrides() {
        return this.propertyOverrides;
    }

    public static class DependencyManagement {
        private static final DependencyManagement EMPTY = new DependencyManagement(Collections.emptyList());
        private final List<DependencyManagementDependency> dependencies;

        public static DependencyManagement empty() {
            return EMPTY;
        }

        @Nullable
        public String getManagedVersion(String groupId, String artifactId) {
            for (DependencyManagementDependency dep : this.dependencies) {
                for (DependencyDescriptor dependencyDescriptor : dep.getDependencies()) {
                    if (!groupId.equals(dependencyDescriptor.getGroupId()) || !artifactId.equals(dependencyDescriptor.getArtifactId())) continue;
                    return dependencyDescriptor.getVersion();
                }
            }
            return null;
        }

        @Nullable
        public String getManagedScope(String groupId, String artifactId) {
            Enum scope = null;
            for (DependencyManagementDependency dep : this.dependencies) {
                for (DependencyDescriptor dependencyDescriptor : dep.getDependencies()) {
                    if (!groupId.equals(dependencyDescriptor.getGroupId()) || !artifactId.equals(dependencyDescriptor.getArtifactId())) continue;
                    scope = Scope.maxPrecedence((Scope)scope, dependencyDescriptor.getScope() == null ? Scope.Compile : dependencyDescriptor.getScope());
                }
            }
            return scope == null ? null : scope.name().toLowerCase();
        }

        public boolean deepEquals(@Nullable DependencyManagement other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            ListIterator<DependencyManagementDependency> e1 = this.dependencies.listIterator();
            ListIterator<DependencyManagementDependency> e2 = other.dependencies.listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                DependencyManagementDependency o2;
                DependencyManagementDependency o1 = e1.next();
                if (o1 == (o2 = e2.next()) || o1 instanceof DependencyManagementDependency.Defined && o1.equals(o2) || o1 instanceof DependencyManagementDependency.Imported && ((DependencyManagementDependency.Imported)o1).deepEquals(o2)) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        public DependencyManagement(List<DependencyManagementDependency> dependencies) {
            this.dependencies = dependencies;
        }

        public List<DependencyManagementDependency> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyManagement)) {
                return false;
            }
            DependencyManagement other = (DependencyManagement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<DependencyManagementDependency> this$dependencies = this.getDependencies();
            List<DependencyManagementDependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof DependencyManagement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<DependencyManagementDependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "Pom.DependencyManagement(dependencies=" + this.getDependencies() + ")";
        }

        @NonNull
        public DependencyManagement withDependencies(List<DependencyManagementDependency> dependencies) {
            return this.dependencies == dependencies ? this : new DependencyManagement(dependencies);
        }
    }

    public static class Dependency
    implements DependencyDescriptor {
        private final MavenRepository repository;
        private final Scope scope;
        @Nullable
        private final String classifier;
        @Nullable
        private final String type;
        private final boolean optional;
        private final Pom model;
        @Nullable
        private final String requestedVersion;
        private final Set<GroupArtifact> exclusions;

        @Override
        public String getGroupId() {
            return this.model.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.model.getArtifactId();
        }

        @Override
        public String getVersion() {
            return this.model.getVersion();
        }

        public Dependency withVersion(String version) {
            return this.withModel(this.model.withVersion(version).withDependencies(Collections.emptyList()));
        }

        @Nullable
        public String getDatedSnapshotVersion() {
            return this.model.getDatedSnapshotVersion();
        }

        public String getCoordinates() {
            return this.model.getGroupId() + ':' + this.model.getArtifactId() + ':' + this.model.getVersion() + (this.classifier == null ? "" : ':' + this.classifier);
        }

        public String toString() {
            return "Dependency {" + this.getCoordinates() + (this.optional ? ", optional" : "") + (!this.getVersion().equals(this.requestedVersion) ? ", requested=" + this.requestedVersion : "") + '}';
        }

        public Collection<Dependency> findDependencies(String groupId, String artifactId) {
            return this.findDependencies(d -> d.getGroupId().equals(groupId) && d.getArtifactId().equals(artifactId));
        }

        public Collection<Dependency> findDependencies(Predicate<Dependency> matcher) {
            ArrayList<Dependency> matches = new ArrayList<Dependency>();
            if (matcher.test(this)) {
                matches.add(this);
            }
            for (Dependency d : this.model.getDependencies()) {
                matches.addAll(d.findDependencies(matcher));
            }
            return matches;
        }

        public boolean deepEquals(@Nullable Dependency other) {
            return this == other || other != null && Objects.equals(this.repository, other.repository) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.type, other.type) && this.optional == other.optional && Objects.equals(this.requestedVersion, other.requestedVersion) && Objects.equals(this.exclusions, other.exclusions) && (this.model == other.model || this.model != null && this.model.deepEquals(other.model));
        }

        public Dependency(MavenRepository repository, Scope scope, @Nullable String classifier, @Nullable String type, boolean optional, Pom model, @Nullable String requestedVersion, Set<GroupArtifact> exclusions) {
            this.repository = repository;
            this.scope = scope;
            this.classifier = classifier;
            this.type = type;
            this.optional = optional;
            this.model = model;
            this.requestedVersion = requestedVersion;
            this.exclusions = exclusions;
        }

        public MavenRepository getRepository() {
            return this.repository;
        }

        @Override
        public Scope getScope() {
            return this.scope;
        }

        @Override
        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Pom getModel() {
            return this.model;
        }

        @Nullable
        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        @Override
        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            MavenRepository this$repository = this.getRepository();
            MavenRepository other$repository = other.getRepository();
            if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Pom this$model = this.getModel();
            Pom other$model = other.getModel();
            if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            if (this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Dependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            MavenRepository $repository = this.getRepository();
            result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Pom $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        public Dependency withRepository(MavenRepository repository) {
            return this.repository == repository ? this : new Dependency(repository, this.scope, this.classifier, this.type, this.optional, this.model, this.requestedVersion, this.exclusions);
        }

        @NonNull
        public Dependency withScope(Scope scope) {
            return this.scope == scope ? this : new Dependency(this.repository, scope, this.classifier, this.type, this.optional, this.model, this.requestedVersion, this.exclusions);
        }

        @NonNull
        public Dependency withClassifier(@Nullable String classifier) {
            return this.classifier == classifier ? this : new Dependency(this.repository, this.scope, classifier, this.type, this.optional, this.model, this.requestedVersion, this.exclusions);
        }

        @NonNull
        public Dependency withType(@Nullable String type) {
            return this.type == type ? this : new Dependency(this.repository, this.scope, this.classifier, type, this.optional, this.model, this.requestedVersion, this.exclusions);
        }

        @NonNull
        public Dependency withOptional(boolean optional) {
            return this.optional == optional ? this : new Dependency(this.repository, this.scope, this.classifier, this.type, optional, this.model, this.requestedVersion, this.exclusions);
        }

        @NonNull
        public Dependency withModel(Pom model) {
            return this.model == model ? this : new Dependency(this.repository, this.scope, this.classifier, this.type, this.optional, model, this.requestedVersion, this.exclusions);
        }

        @NonNull
        public Dependency withRequestedVersion(@Nullable String requestedVersion) {
            return this.requestedVersion == requestedVersion ? this : new Dependency(this.repository, this.scope, this.classifier, this.type, this.optional, this.model, requestedVersion, this.exclusions);
        }

        @NonNull
        public Dependency withExclusions(Set<GroupArtifact> exclusions) {
            return this.exclusions == exclusions ? this : new Dependency(this.repository, this.scope, this.classifier, this.type, this.optional, this.model, this.requestedVersion, exclusions);
        }
    }

    public static enum LicenseType {
        Apache2,
        BSD,
        CDDL,
        CreativeCommons,
        Eclipse,
        GPL,
        LGPL,
        MIT,
        Mozilla,
        PublicDomain,
        Unknown;

    }

    public static class License {
        private final String name;
        private final LicenseType type;

        public static License fromName(@Nullable String license) {
            if (license == null) {
                return new License("", LicenseType.Unknown);
            }
            switch (license) {
                case "Apache License, Version 2.0": 
                case "The Apache Software License, Version 2.0": {
                    return new License(license, LicenseType.Apache2);
                }
                case "GNU Lesser General Public License": 
                case "GNU Library General Public License": {
                    return new License(license, LicenseType.LGPL);
                }
                case "Public Domain": {
                    return new License(license, LicenseType.PublicDomain);
                }
            }
            if (license.contains("LGPL")) {
                return new License(license, LicenseType.LGPL);
            }
            if (license.contains("GPL") || license.contains("GNU General Public License")) {
                return new License(license, LicenseType.GPL);
            }
            if (license.contains("CDDL")) {
                return new License(license, LicenseType.CDDL);
            }
            if (license.contains("Creative Commons") || license.contains("CC0")) {
                return new License(license, LicenseType.CreativeCommons);
            }
            if (license.contains("BSD")) {
                return new License(license, LicenseType.BSD);
            }
            if (license.contains("MIT")) {
                return new License(license, LicenseType.MIT);
            }
            if (license.contains("Eclipse") || license.contains("EPL")) {
                return new License(license, LicenseType.Eclipse);
            }
            if (license.contains("Apache") || license.contains("ASF")) {
                return new License(license, LicenseType.Apache2);
            }
            if (license.contains("Mozilla")) {
                return new License(license, LicenseType.Mozilla);
            }
            if (license.toLowerCase().contains("GNU Lesser General Public License".toLowerCase()) || license.contains("GNU Library General Public License")) {
                return new License(license, LicenseType.LGPL);
            }
            return new License(license, LicenseType.Unknown);
        }

        public License(String name, LicenseType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public LicenseType getType() {
            return this.type;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            LicenseType this$type = this.getType();
            LicenseType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof License;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            LicenseType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "Pom.License(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }
}

