/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.Version;
import org.openrewrite.maven.internal.grammar.VersionRangeLexer;
import org.openrewrite.maven.internal.grammar.VersionRangeParser;
import org.openrewrite.maven.internal.grammar.VersionRangeParserBaseVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestedVersion {
    private static final Logger logger = LoggerFactory.getLogger(RequestedVersion.class);
    private final GroupArtifact groupArtifact;
    @Nullable
    private final RequestedVersion nearer;
    private final VersionSpec versionSpec;

    public RequestedVersion(GroupArtifact groupArtifact, @Nullable RequestedVersion nearer, String requested) {
        this.groupArtifact = groupArtifact;
        this.nearer = nearer;
        if (requested.equals("LATEST")) {
            this.versionSpec = new DynamicVersion(DynamicVersion.Kind.LATEST);
        } else if (requested.equals("RELEASE")) {
            this.versionSpec = new DynamicVersion(DynamicVersion.Kind.RELEASE);
        } else if (requested.contains("[") || requested.contains("(")) {
            if (!requested.contains("]") && !requested.contains(")")) {
                requested = requested + "]";
            }
            VersionRangeParser parser = new VersionRangeParser((TokenStream)new CommonTokenStream((TokenSource)new VersionRangeLexer((CharStream)CharStreams.fromString((String)requested))));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new LoggingErrorListener());
            this.versionSpec = (VersionSpec)new VersionRangeParserBaseVisitor<VersionSpec>(){

                @Override
                public VersionSpec visitRequestedVersion(VersionRangeParser.RequestedVersionContext ctx) {
                    if (ctx.version() != null) {
                        return new SoftRequirement(new Version(ctx.version().getText()));
                    }
                    return new RangeSet(ctx.range().stream().map(range -> {
                        Version upper;
                        Version lower;
                        if (range.bounds().boundedLower() != null) {
                            Iterator<TerminalNode> versionIter = range.bounds().boundedLower().Version().iterator();
                            lower = this.toVersion(versionIter.next());
                            upper = versionIter.hasNext() ? this.toVersion(versionIter.next()) : null;
                        } else if (range.bounds().unboundedLower() != null) {
                            lower = null;
                            upper = this.toVersion(range.bounds().unboundedLower().Version());
                        } else {
                            lower = this.toVersion(range.bounds().exactly().Version());
                            upper = this.toVersion(range.bounds().exactly().Version());
                        }
                        return new Range(range.CLOSED_RANGE_OPEN() != null, lower, range.CLOSED_RANGE_CLOSE() != null, upper);
                    }).collect(Collectors.toList()));
                }

                private Version toVersion(TerminalNode version) {
                    return new Version(version.getText());
                }
            }.visit((ParseTree)parser.requestedVersion());
        } else {
            this.versionSpec = new SoftRequirement(new Version(requested));
        }
    }

    public boolean isRange() {
        return this.versionSpec instanceof RangeSet && (this.nearer == null || this.nearer.isRange());
    }

    public boolean isDynamic() {
        return !this.isRange() && (this.nearer == null ? this.versionSpec instanceof DynamicVersion : this.nearer.isDynamic());
    }

    @Nullable
    public String nearestVersion() {
        if (this.isRange() || this.isDynamic()) {
            return null;
        }
        if (this.nearer != null) {
            return this.nearer.nearestVersion();
        }
        return ((SoftRequirement)this.versionSpec).version.toString();
    }

    @Nullable
    public String selectFrom(Iterable<String> availableVersions) {
        Stream<Version> versionStream = StreamSupport.stream(availableVersions.spliterator(), false).map(Version::new);
        return (this.isRange() ? versionStream.filter(this::rangeMatch) : versionStream.filter(v -> ((DynamicVersion)this.versionSpec).kind.equals((Object)DynamicVersion.Kind.LATEST) || !v.toString().endsWith("-SNAPSHOT"))).max(Comparator.naturalOrder()).map(Version::toString).orElse(null);
    }

    private boolean rangeMatch(Version version) {
        if (!(this.versionSpec instanceof RangeSet)) {
            return true;
        }
        return ((RangeSet)this.versionSpec).ranges.stream().anyMatch(range -> {
            boolean lowerMatches = true;
            if (((Range)range).lower != null) {
                int lowComp = ((Range)range).lower.compareTo(version);
                lowerMatches = lowComp == 0 ? ((Range)range).lowerClosed : lowComp < 0;
            }
            boolean upperMatches = true;
            if (((Range)range).upper != null) {
                int upperComp = ((Range)range).upper.compareTo(version);
                upperMatches = upperComp == 0 ? ((Range)range).upperClosed : upperComp > 0;
            }
            return lowerMatches && upperMatches;
        }) && (this.nearer == null || this.nearer.rangeMatch(version));
    }

    @Nullable
    public String resolve(MavenPomDownloader downloader, Collection<MavenRepository> repositories) {
        String selectedVersion;
        if (this.isRange() || this.isDynamic()) {
            MavenMetadata metadata = downloader.downloadMetadata(this.groupArtifact.getGroupId(), this.groupArtifact.getArtifactId(), repositories);
            selectedVersion = this.selectFrom(metadata.getVersioning().getVersions());
        } else {
            selectedVersion = this.nearestVersion();
        }
        if (selectedVersion == null) assert (selectedVersion != null);
        return selectedVersion;
    }

    private static class LoggingErrorListener
    extends BaseErrorListener {
        private LoggingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            logger.warn("Syntax error at line {}:{} {}", new Object[]{line, charPositionInLine, msg});
        }
    }

    private static class Range {
        private final boolean lowerClosed;
        private final boolean upperClosed;
        @Nullable
        private final Version lower;
        @Nullable
        private final Version upper;

        private Range(boolean lowerClosed, @Nullable Version lower, boolean upperClosed, @Nullable Version upper) {
            this.lowerClosed = lowerClosed;
            this.lower = lower;
            this.upperClosed = upperClosed;
            this.upper = upper;
        }

        public String toString() {
            return (this.lowerClosed ? "[" : "(") + this.lower + "," + this.upper + (this.upperClosed ? (char)']' : ')');
        }
    }

    private static class RangeSet
    implements VersionSpec {
        private final List<Range> ranges;

        private RangeSet(List<Range> ranges) {
            this.ranges = ranges;
        }
    }

    private static class DynamicVersion
    implements VersionSpec {
        private final Kind kind;

        private DynamicVersion(Kind kind) {
            this.kind = kind;
        }

        static enum Kind {
            LATEST,
            RELEASE;

        }
    }

    private static class SoftRequirement
    implements VersionSpec {
        private final Version version;

        private SoftRequirement(Version version) {
            this.version = version;
        }
    }

    static interface VersionSpec {
    }
}

