/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.vavr.CheckedFunction1;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;

public class MavenPomDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryOnException(throwable -> throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private static final CheckedFunction1<Request, Response> sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> httpClient.newCall(request).execute());
    private static final MavenRepository SUPER_POM_REPOSITORY = new MavenRepository("central", URI.create("https://repo.maven.apache.org/maven2"), true, false, true, null, null);
    private static final Set<String> unresolvablePoms = new HashSet<String>();
    private static final CacheResult<RawMaven> UNAVAILABLE_POM = new CacheResult<Object>(CacheResult.State.Unavailable, null, -1L);
    private static final CacheResult<MavenMetadata> UNAVAILABLE_METADATA = new CacheResult<Object>(CacheResult.State.Unavailable, null, -1L);
    private static final CacheResult<MavenRepository> UNAVAILABLE_REPOSITORY = new CacheResult<Object>(CacheResult.State.Unavailable, null, -1L);
    private final MavenPomCache mavenPomCache;
    private final Map<Path, RawMaven> projectPoms;
    private final MavenExecutionContextView ctx;

    public MavenPomDownloader(MavenPomCache mavenPomCache, Map<Path, RawMaven> projectPoms, ExecutionContext ctx) {
        this.mavenPomCache = mavenPomCache;
        this.projectPoms = projectPoms;
        this.ctx = new MavenExecutionContextView(ctx);
    }

    @Nullable
    public MavenMetadata downloadMetadata(String groupId, String artifactId, Collection<MavenRepository> repositories) {
        return this.downloadMetadata(groupId, artifactId, null, repositories);
    }

    @Nullable
    public MavenMetadata downloadMetadata(String groupId, String artifactId, @Nullable String version, Collection<MavenRepository> repositories) {
        Timer.Sample sample = Timer.start();
        MavenMetadata mavenMetadata = MavenMetadata.EMPTY;
        Set<MavenRepository> repos = this.getDistinctNormalizedRepositories(repositories);
        for (MavenRepository repo : repos) {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("repo.id", repo.getUri().toString()).tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "metadata");
            try {
                MavenMetadata currentMetadata;
                MavenPomCache.MetadataKey metadataKey = new MavenPomCache.MetadataKey(repo.getUri(), groupId, artifactId, version);
                CacheResult<MavenMetadata> result = this.mavenPomCache.getMavenMetadata(metadataKey);
                if (result == null) {
                    currentMetadata = this.forceDownloadMetadata(groupId, artifactId, version, repo);
                    result = this.mavenPomCache.setMavenMetadata(metadataKey, currentMetadata, version != null && version.endsWith("SNAPSHOT"));
                } else {
                    currentMetadata = result.getData();
                }
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                if (currentMetadata == null) continue;
                if (mavenMetadata == MavenMetadata.EMPTY) {
                    if (currentMetadata == MavenMetadata.EMPTY) continue;
                    mavenMetadata = currentMetadata;
                    continue;
                }
                if (currentMetadata == MavenMetadata.EMPTY) continue;
                mavenMetadata = this.mergeMetadata(mavenMetadata, currentMetadata);
            }
            catch (Exception e) {
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                this.ctx.getOnError().accept(e);
            }
        }
        return mavenMetadata;
    }

    @NonNull
    private MavenMetadata mergeMetadata(MavenMetadata m1, MavenMetadata m2) {
        return new MavenMetadata(new MavenMetadata.Versioning(Stream.concat(m1.getVersioning().getVersions().stream(), m2.getVersioning().getVersions().stream()).collect(Collectors.toList()), Stream.concat(m1.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m1.getVersioning().getSnapshotVersions().stream(), m2.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m2.getVersioning().getSnapshotVersions().stream()).collect(Collectors.toList()), null));
    }

    @Nullable
    private MavenMetadata forceDownloadMetadata(String groupId, String artifactId, @Nullable String version, MavenRepository repo) {
        String uri = repo.getUri().toString() + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + (version == null ? "" : version + '/') + "maven-metadata.xml";
        Request.Builder request = this.applyAuthenticationToRequest(repo, new Request.Builder().url(uri).get());
        try {
            Response response;
            block10: {
                MavenMetadata mavenMetadata;
                block11: {
                    response = (Response)sendRequest.apply((Object)request.build());
                    try {
                        if (!response.isSuccessful() || response.body() == null) break block10;
                        byte[] responseBody = response.body().bytes();
                        mavenMetadata = MavenMetadata.parse(responseBody);
                        if (response == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return mavenMetadata;
            }
            if (response != null) {
                response.close();
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    private Timer.Builder addTagsByResult(Timer.Builder timer, CacheResult<?> result) {
        switch (result.getState()) {
            case Cached: {
                timer = timer.tags(new String[]{"outcome", "cached", "exception", "none"});
                break;
            }
            case Unavailable: {
                timer = timer.tags(new String[]{"outcome", "unavailable", "exception", "none"});
                break;
            }
            case Updated: {
                timer = timer.tags(new String[]{"outcome", "downloaded", "exception", "none"});
            }
        }
        return timer;
    }

    @Nullable
    public RawMaven download(String groupId, String artifactId, String version, @Nullable String relativePath, @Nullable RawMaven containingPom, Collection<MavenRepository> repositories, ExecutionContext ctx) {
        RawMaven maybeLocalPom;
        Path folderContainingPom;
        HashMap<MavenRepository, String> errors = new HashMap<MavenRepository, String>();
        String versionMaybeDatedSnapshot = this.datedSnapshotVersion(groupId, artifactId, version, repositories, ctx);
        Timer.Sample sample = Timer.start();
        RawMaven goodEnoughMatch = null;
        for (RawMaven projectPom : this.projectPoms.values()) {
            if (!groupId.equals(projectPom.getPom().getGroupId()) || !artifactId.equals(projectPom.getPom().getArtifactId())) continue;
            if (version.equals(projectPom.getPom().getVersion())) {
                return projectPom;
            }
            goodEnoughMatch = projectPom;
        }
        if (goodEnoughMatch != null) {
            return goodEnoughMatch;
        }
        if (containingPom != null && containingPom.getSourcePath() != null && !StringUtils.isBlank((String)relativePath) && (folderContainingPom = containingPom.getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && groupId.equals(maybeLocalPom.getPom().getGroupId()) && artifactId.equals(maybeLocalPom.getPom().getArtifactId()) && version.equals(maybeLocalPom.getPom().getVersion())) {
            return maybeLocalPom;
        }
        Set<MavenRepository> normalizedRepos = this.getDistinctNormalizedRepositories(repositories);
        Set repos = normalizedRepos.stream().filter(repo -> repo.acceptsVersion(version)).collect(Collectors.toSet());
        for (MavenRepository repo2 : repos) {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("repo.id", repo2.getUri().toString()).tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "pom");
            String artifactCoordinates = groupId + ':' + artifactId + ':' + version;
            if (unresolvablePoms.contains(artifactCoordinates)) {
                return null;
            }
            MavenPomCache.PomKey pomKey = new MavenPomCache.PomKey(repo2.getUri(), groupId, artifactId, versionMaybeDatedSnapshot);
            CacheResult<RawMaven> result = this.mavenPomCache.getMaven(pomKey);
            if (result == null) {
                String uri = URI.create(repo2.getUri().toString()) + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + versionMaybeDatedSnapshot + ".pom";
                Request.Builder request = this.applyAuthenticationToRequest(repo2, new Request.Builder().url(uri).get());
                try (Response response = (Response)sendRequest.apply((Object)request.build());){
                    int responseCode = response.code();
                    if (response.isSuccessful() && response.body() != null) {
                        byte[] responseBody = response.body().bytes();
                        Path inputPath = Paths.get(groupId, artifactId, version);
                        RawMaven rawMaven = RawMaven.parse(new Parser.Input(inputPath, () -> new ByteArrayInputStream(responseBody), true), null, versionMaybeDatedSnapshot.equals(version) ? null : versionMaybeDatedSnapshot, ctx).withRepository(repo2);
                        result = this.mavenPomCache.setMaven(pomKey, rawMaven, version.endsWith("-SNAPSHOT"));
                    } else {
                        errors.put(repo2, "Download failure. Response code is [" + responseCode + "].");
                        result = this.mavenPomCache.setMaven(pomKey, null, version.endsWith("-SNAPSHOT"));
                    }
                }
                catch (Throwable throwable) {
                    errors.put(repo2, "Download failure. " + throwable.getMessage());
                    result = this.mavenPomCache.setMaven(pomKey, null, version.endsWith("-SNAPSHOT"));
                }
            }
            sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
            if (result.getData() == null) continue;
            return result.getData();
        }
        if (!errors.isEmpty()) {
            String errorText = "Unable to download dependency " + groupId + ":" + artifactId + ":" + version + " from any of these repositories: \n" + errors.entrySet().stream().map(entry -> "    Id: " + ((MavenRepository)entry.getKey()).getId() + ", URL: " + ((MavenRepository)entry.getKey()).getUri().toString() + ", cause: " + (String)entry.getValue()).collect(Collectors.joining("\n"));
            ctx.getOnError().accept(new MavenDownloadingException(errorText));
        }
        return null;
    }

    private String datedSnapshotVersion(String groupId, String artifactId, String version, Collection<MavenRepository> repositories, ExecutionContext ctx) {
        if (version.endsWith("-SNAPSHOT")) {
            MavenMetadata.Snapshot snapshot;
            for (GroupArtifactVersion pinnedSnapshotVersion : new MavenExecutionContextView(ctx).getPinnedSnapshotVersions()) {
                if (pinnedSnapshotVersion.getDatedSnapshotVersion() == null || !pinnedSnapshotVersion.getGroupId().equals(groupId) || !pinnedSnapshotVersion.getArtifactId().equals(artifactId) || !pinnedSnapshotVersion.getVersion().equals(version)) continue;
                return pinnedSnapshotVersion.getDatedSnapshotVersion();
            }
            Set<MavenRepository> normalizedRepos = this.getDistinctNormalizedRepositories(repositories);
            Set<MavenRepository> repos = normalizedRepos.stream().filter(repo -> repo.acceptsVersion(version)).collect(Collectors.toSet());
            MavenMetadata mavenMetadata = this.downloadMetadata(groupId, artifactId, version, repos);
            if (mavenMetadata != null && (snapshot = mavenMetadata.getVersioning().getSnapshot()) != null) {
                return version.replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
            }
        }
        return version;
    }

    @NonNull
    private Set<MavenRepository> getDistinctNormalizedRepositories(Collection<MavenRepository> repositories) {
        ArrayList<MavenRepository> candidates = new ArrayList<MavenRepository>(repositories);
        candidates.add(SUPER_POM_REPOSITORY);
        HashSet<MavenRepository> normalizedRepositories = new HashSet<MavenRepository>();
        for (MavenRepository repo : candidates) {
            MavenRepository normalizedRepo = this.normalizeRepository(repo);
            if (normalizedRepo == null) continue;
            normalizedRepositories.add(normalizedRepo);
        }
        return normalizedRepositories;
    }

    @Nullable
    protected MavenRepository normalizeRepository(MavenRepository originalRepository) {
        CacheResult<MavenRepository> result;
        block19: {
            MavenRepository repository = this.applyAuthenticationToRepository(this.applyMirrors(originalRepository));
            try {
                MavenRepository normalized;
                block20: {
                    if (repository.isKnownToExist()) {
                        return repository;
                    }
                    String originalUrl = repository.getUri().toString();
                    result = this.mavenPomCache.getNormalizedRepository(repository);
                    if (result != null) break block19;
                    String httpsUri = repository.getUri().getScheme().equalsIgnoreCase("http") ? repository.getUri().toString().replaceFirst("[hH][tT][tT][pP]://", "https://") : repository.getUri().toString();
                    Request.Builder request = this.applyAuthenticationToRequest(repository, new Request.Builder().url(httpsUri).get());
                    normalized = null;
                    try (Response ignored = (Response)sendRequest.apply((Object)request.build());){
                        normalized = repository.withUri(URI.create(httpsUri));
                    }
                    catch (Throwable t) {
                        if (httpsUri.equals(originalUrl)) break block20;
                        try (Response ignored2 = (Response)sendRequest.apply((Object)request.url(originalUrl).build());){
                            normalized = new MavenRepository(repository.getId(), URI.create(originalUrl), repository.isReleases(), repository.isSnapshots(), repository.getUsername(), repository.getPassword());
                        }
                        catch (Throwable t2) {
                            this.ctx.getOnError().accept(t2);
                        }
                    }
                }
                result = this.mavenPomCache.setNormalizedRepository(repository, normalized);
            }
            catch (Exception e) {
                this.ctx.getOnError().accept(e);
                result = this.mavenPomCache.setNormalizedRepository(repository, null);
            }
        }
        MavenRepository repo = result.getData();
        return repo == null ? null : this.applyAuthenticationToRepository(repo);
    }

    private MavenRepository applyAuthenticationToRepository(MavenRepository repository) {
        return MavenRepositoryCredentials.apply(this.ctx.getCredentials(), repository);
    }

    private Request.Builder applyAuthenticationToRequest(MavenRepository repository, Request.Builder request) {
        if (repository.getUsername() != null && repository.getPassword() != null) {
            String credentials = Credentials.basic((String)repository.getUsername(), (String)repository.getPassword());
            request.header("Authorization", credentials);
        }
        return request;
    }

    private MavenRepository applyMirrors(MavenRepository repository) {
        return MavenRepositoryMirror.apply(this.ctx.getMirrors(), repository);
    }

    static {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(MavenPomDownloader.class.getResourceAsStream("/unresolvable.txt"), StandardCharsets.UTF_8));){
            reader.lines().filter(line -> !line.isEmpty()).forEach(unresolvablePoms::add);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

