/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.io.IOException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.internal.JacksonMapdbSerializer;

public class CacheResultJacksonMapdbSerializer<T>
implements Serializer<CacheResult<T>> {
    private final JacksonMapdbSerializer<T> jacksonMapdbSerializer;

    public CacheResultJacksonMapdbSerializer(Class<T> tClass) {
        this.jacksonMapdbSerializer = new JacksonMapdbSerializer<T>(tClass);
    }

    public void serialize(DataOutput2 out, CacheResult<T> value) throws IOException {
        if (value.getData() != null) {
            out.writeBoolean(true);
            out.writeLong(value.getTtl());
            this.jacksonMapdbSerializer.serialize(out, value.getData());
        } else {
            out.writeBoolean(false);
            out.writeLong(value.getTtl());
        }
    }

    public CacheResult<T> deserialize(DataInput2 input, int available) throws IOException {
        boolean present = input.readBoolean();
        long ttl = input.readLong();
        Object data = present ? (Object)this.jacksonMapdbSerializer.deserialize(input, available) : null;
        return new CacheResult<Object>(CacheResult.State.Cached, data, ttl);
    }
}

