/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.MavenRepository;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksdbMavenPomCache
implements MavenPomCache {
    static ObjectMapper mapper;
    private static final Map<String, RocksCache> cacheMap;
    private final Map<MavenPomCache.PomKey, CacheResult<RawMaven>> l1PomCache = new HashMap<MavenPomCache.PomKey, CacheResult<RawMaven>>();
    private final Map<MavenPomCache.MetadataKey, CacheResult<MavenMetadata>> l1MavenMetadataCache = new HashMap<MavenPomCache.MetadataKey, CacheResult<MavenMetadata>>();
    private final Map<MavenRepository, CacheResult<MavenRepository>> l1RepositoryCache = new HashMap<MavenRepository, CacheResult<MavenRepository>>();
    private final RocksCache cache;
    private final long releaseTimeToLiveMilliseconds;
    private final long snapshotTimeToLiveMilliseconds;

    static synchronized RocksCache getCache(String pomCacheDir) {
        return cacheMap.computeIfAbsent(pomCacheDir, RocksCache::new);
    }

    public RocksdbMavenPomCache(@Nullable Path workspace) {
        this(workspace, 3600000L, 60000L);
    }

    public RocksdbMavenPomCache(@Nullable Path workspace, long releaseTimeToLiveMilliseconds, long snapshotTimeToLiveMilliseconds) {
        this.releaseTimeToLiveMilliseconds = releaseTimeToLiveMilliseconds;
        this.snapshotTimeToLiveMilliseconds = snapshotTimeToLiveMilliseconds;
        assert (workspace != null);
        File pomCacheDir = new File(workspace.toFile(), ".rewrite-cache");
        if (!pomCacheDir.exists() && !pomCacheDir.mkdirs()) {
            throw new IllegalStateException("Unable to find or create maven pom cache at " + pomCacheDir);
        }
        if (!pomCacheDir.isDirectory()) {
            throw new IllegalStateException("The maven pom cache workspace must be a directory at " + pomCacheDir);
        }
        File lock = new File(pomCacheDir, "LOCK");
        if (lock.exists()) {
            lock.delete();
        }
        this.cache = RocksdbMavenPomCache.getCache(pomCacheDir.getAbsolutePath());
    }

    @Override
    @Nullable
    public CacheResult<MavenMetadata> getMavenMetadata(MavenPomCache.MetadataKey key) {
        CacheResult<MavenMetadata> metadata = this.l1MavenMetadataCache.get(key);
        if (metadata == null) {
            try {
                metadata = RocksdbMavenPomCache.deserializeMavenMetadata(this.cache.get(RocksdbMavenPomCache.serialize(key)));
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
        }
        return this.filterExpired(metadata);
    }

    @Override
    public CacheResult<MavenMetadata> setMavenMetadata(MavenPomCache.MetadataKey key, MavenMetadata metadata, boolean isSnapshot) {
        long ttl = this.calculateExpiration(isSnapshot ? this.snapshotTimeToLiveMilliseconds : this.releaseTimeToLiveMilliseconds);
        CacheResult<MavenMetadata> cached = new CacheResult<MavenMetadata>(CacheResult.State.Cached, metadata, ttl);
        this.l1MavenMetadataCache.put(key, cached);
        try {
            this.cache.put(RocksdbMavenPomCache.serialize(key), RocksdbMavenPomCache.serialize(cached));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
        return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata, ttl);
    }

    @Override
    @Nullable
    public CacheResult<RawMaven> getMaven(MavenPomCache.PomKey key) {
        CacheResult<RawMaven> rawMavenEntry = this.l1PomCache.get(key);
        if (rawMavenEntry == null) {
            byte[] rocksKey = RocksdbMavenPomCache.serialize(key);
            try {
                rawMavenEntry = RocksdbMavenPomCache.deserializeRawMaven(this.cache.get(rocksKey));
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
        }
        return this.filterExpired(rawMavenEntry);
    }

    @Override
    public CacheResult<RawMaven> setMaven(MavenPomCache.PomKey key, RawMaven maven, boolean isSnapshot) {
        long ttl = this.calculateExpiration(isSnapshot ? this.snapshotTimeToLiveMilliseconds : this.releaseTimeToLiveMilliseconds);
        CacheResult<RawMaven> cached = new CacheResult<RawMaven>(CacheResult.State.Cached, maven, ttl);
        this.l1PomCache.put(key, cached);
        try {
            this.cache.put(RocksdbMavenPomCache.serialize(key), RocksdbMavenPomCache.serialize(cached));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
        return new CacheResult<RawMaven>(CacheResult.State.Updated, maven, ttl);
    }

    @Override
    @Nullable
    public CacheResult<MavenRepository> getNormalizedRepository(MavenRepository repository) {
        CacheResult<MavenRepository> repositoryCacheResult = this.l1RepositoryCache.get(repository);
        if (repositoryCacheResult == null) {
            try {
                repositoryCacheResult = RocksdbMavenPomCache.deserializeMavenRepository(this.cache.get(RocksdbMavenPomCache.serialize(repository)));
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
        }
        return this.filterExpired(repositoryCacheResult);
    }

    @Override
    public CacheResult<MavenRepository> setNormalizedRepository(MavenRepository repository, MavenRepository normalized) {
        long ttl = this.calculateExpiration(normalized == null ? 60000L : 3600000L);
        CacheResult<MavenRepository> cached = new CacheResult<MavenRepository>(CacheResult.State.Cached, normalized, ttl);
        this.l1RepositoryCache.put(repository, cached);
        try {
            this.cache.put(RocksdbMavenPomCache.serialize(repository), RocksdbMavenPomCache.serialize(cached));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
        return new CacheResult<MavenRepository>(CacheResult.State.Updated, normalized, ttl);
    }

    @Override
    public void clear() {
        this.l1PomCache.clear();
        this.l1MavenMetadataCache.clear();
        this.l1RepositoryCache.clear();
    }

    static <T> byte[] serialize(T object) {
        if (object == null) {
            return null;
        }
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize object to byte array.");
        }
    }

    static CacheResult<MavenRepository> deserializeMavenRepository(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (CacheResult)mapper.readValue(bytes, (TypeReference)new TypeReference<CacheResult<MavenRepository>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    static CacheResult<RawMaven> deserializeRawMaven(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (CacheResult)mapper.readValue(bytes, (TypeReference)new TypeReference<CacheResult<RawMaven>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    static CacheResult<MavenMetadata> deserializeMavenMetadata(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (CacheResult)mapper.readValue(bytes, (TypeReference)new TypeReference<CacheResult<MavenMetadata>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void close() throws Exception {
    }

    static {
        cacheMap = new HashMap<String, RocksCache>();
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = new ObjectMapper((JsonFactory)f).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY));
        RocksDB.loadLibrary();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> cacheMap.values().forEach(rec$ -> ((RocksCache)rec$).close())));
    }

    static class RocksCache {
        private final RocksDB database;
        private final Options options;
        private final WriteOptions writeOptions;

        RocksCache(String pomCacheDir) {
            try {
                this.options = new Options();
                this.options.setCreateIfMissing(true);
                this.options.setWriteBufferSize(1000000L);
                this.options.setParanoidChecks(false);
                this.options.setParanoidFileChecks(false);
                this.writeOptions = new WriteOptions();
                this.writeOptions.setDisableWAL(true);
                this.database = RocksDB.open((Options)this.options, (String)pomCacheDir);
            }
            catch (RocksDBException exception) {
                throw new IllegalStateException("Unable to create cache database." + exception.getMessage(), exception);
            }
            try {
                this.cleanCacheIfCorrupt(pomCacheDir);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to clear corrupt maven pom cache.", ex);
            }
        }

        private void cleanCacheIfCorrupt(String pomCacheDir) throws IOException {
            try {
                this.database.verifyChecksum();
            }
            catch (RocksDBException ex) {
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(pomCacheDir, new String[0]), "*");){
                    paths.forEach(path -> {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException ioException) {
                            throw new IllegalStateException("Unable to delete maven pom cache at " + path, ioException);
                        }
                    });
                }
            }
        }

        private void put(byte[] key, byte[] value) throws RocksDBException {
            this.database.put(this.writeOptions, key, value);
        }

        private byte[] get(byte[] key) throws RocksDBException {
            return this.database.get(key);
        }

        private void close() {
            this.database.close();
            this.writeOptions.close();
            this.options.close();
        }
    }
}

