/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import java.net.URI;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.MavenRepository;

public interface MavenPomCache
extends AutoCloseable {
    public static final MavenPomCache NOOP = new MavenPomCache(){

        @Override
        @Nullable
        public CacheResult<MavenMetadata> getMavenMetadata(MetadataKey key) {
            return null;
        }

        @Override
        public CacheResult<MavenMetadata> setMavenMetadata(MetadataKey key, MavenMetadata metadata, boolean isSnapshot) {
            return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata, -1L);
        }

        @Override
        @Nullable
        public CacheResult<RawMaven> getMaven(PomKey key) {
            return null;
        }

        @Override
        public CacheResult<RawMaven> setMaven(PomKey key, RawMaven maven, boolean isSnapshot) {
            return new CacheResult<RawMaven>(CacheResult.State.Updated, maven, -1L);
        }

        @Override
        @Nullable
        public CacheResult<MavenRepository> getNormalizedRepository(MavenRepository repository) {
            return null;
        }

        @Override
        public CacheResult<MavenRepository> setNormalizedRepository(MavenRepository repository, MavenRepository normalized) {
            return new CacheResult<MavenRepository>(CacheResult.State.Updated, normalized, -1L);
        }

        @Override
        public void clear() {
        }

        @Override
        public void close() {
        }
    };

    public CacheResult<MavenMetadata> getMavenMetadata(MetadataKey var1);

    public CacheResult<MavenMetadata> setMavenMetadata(MetadataKey var1, MavenMetadata var2, boolean var3);

    public CacheResult<RawMaven> getMaven(PomKey var1);

    public CacheResult<RawMaven> setMaven(PomKey var1, RawMaven var2, boolean var3);

    public CacheResult<MavenRepository> getNormalizedRepository(MavenRepository var1);

    public CacheResult<MavenRepository> setNormalizedRepository(MavenRepository var1, MavenRepository var2);

    public void clear();

    default public long calculateExpiration(long ttl) {
        return ttl < 0L ? -1L : System.currentTimeMillis() + ttl;
    }

    @Nullable
    default public <T> CacheResult<T> filterExpired(CacheResult<T> result) {
        if (result != null && result.getTtl() > 0L && result.getTtl() < System.currentTimeMillis()) {
            return null;
        }
        return result;
    }

    public static final class MetadataKey {
        private final URI repo;
        private final String groupId;
        private final String artifactId;
        @Nullable
        private final String version;

        public MetadataKey(URI repo, String groupId, String artifactId, @Nullable String version) {
            this.repo = repo;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public URI getRepo() {
            return this.repo;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetadataKey)) {
                return false;
            }
            MetadataKey other = (MetadataKey)o;
            URI this$repo = this.getRepo();
            URI other$repo = other.getRepo();
            if (this$repo == null ? other$repo != null : !((Object)this$repo).equals(other$repo)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $repo = this.getRepo();
            result = result * 59 + ($repo == null ? 43 : ((Object)$repo).hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenPomCache.MetadataKey(repo=" + this.getRepo() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }

    public static final class PomKey {
        private final URI repo;
        private final String groupId;
        private final String artifactId;
        private final String version;

        public PomKey(URI repo, String groupId, String artifactId, String version) {
            this.repo = repo;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public URI getRepo() {
            return this.repo;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PomKey)) {
                return false;
            }
            PomKey other = (PomKey)o;
            URI this$repo = this.getRepo();
            URI other$repo = other.getRepo();
            if (this$repo == null ? other$repo != null : !((Object)this$repo).equals(other$repo)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $repo = this.getRepo();
            result = result * 59 + ($repo == null ? 43 : ((Object)$repo).hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenPomCache.PomKey(repo=" + this.getRepo() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }
}

