/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.CacheResultJacksonMapdbSerializer;
import org.openrewrite.maven.internal.JacksonMapdbSerializer;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.MavenRepository;

public class MapdbMavenPomCache
implements MavenPomCache {
    private static final Serializer<MavenRepository> REPOSITORY_SERIALIZER = new JacksonMapdbSerializer<MavenRepository>(MavenRepository.class);
    private static final Serializer<MavenPomCache.PomKey> POM_KEY_SERIALIZER = new JacksonMapdbSerializer<MavenPomCache.PomKey>(MavenPomCache.PomKey.class);
    private static final Serializer<MavenPomCache.MetadataKey> METADATA_KEY_SERIALIZER = new JacksonMapdbSerializer<MavenPomCache.MetadataKey>(MavenPomCache.MetadataKey.class);
    private static final Serializer<CacheResult<RawMaven>> MAVEN_SERIALIZER = new CacheResultJacksonMapdbSerializer<RawMaven>(RawMaven.class);
    private static final Serializer<CacheResult<MavenRepository>> OPTIONAL_REPOSITORY_SERIALIZER = new CacheResultJacksonMapdbSerializer<MavenRepository>(MavenRepository.class);
    private static final Serializer<CacheResult<MavenMetadata>> MAVEN_METADATA_SERIALIZER = new CacheResultJacksonMapdbSerializer<MavenMetadata>(MavenMetadata.class);
    private final HTreeMap<MavenPomCache.PomKey, CacheResult<RawMaven>> pomCache;
    private final HTreeMap<MavenPomCache.MetadataKey, CacheResult<MavenMetadata>> mavenMetadataCache;
    private final HTreeMap<MavenRepository, CacheResult<MavenRepository>> normalizedRepositoryUrls;
    private final long releaseTimeToLiveMilliseconds;
    private final long snapshotTimeToLiveMilliseconds;

    public MapdbMavenPomCache(@Nullable File workspace, @Nullable Long maxCacheStoreSize, long releaseTimeToLiveMilliseconds, long snapshotTimeToLiveMilliseconds) {
        this.releaseTimeToLiveMilliseconds = releaseTimeToLiveMilliseconds;
        this.snapshotTimeToLiveMilliseconds = snapshotTimeToLiveMilliseconds;
        if (workspace != null) {
            if (!workspace.exists() && !workspace.mkdirs()) {
                throw new IllegalStateException("Unable to find or create maven pom cache at " + workspace);
            }
            if (workspace.isDirectory()) {
                workspace = new File(workspace, "db");
            }
            DB localRepositoryDiskDb = DBMaker.fileDB((File)workspace).fileMmapEnableIfSupported().fileLockWait(10000L).checksumHeaderBypass().closeOnJvmShutdown().make();
            this.pomCache = localRepositoryDiskDb.hashMap("pom.disk").keySerializer(POM_KEY_SERIALIZER).valueSerializer(MAVEN_SERIALIZER).createOrOpen();
            this.mavenMetadataCache = localRepositoryDiskDb.hashMap("metadata.disk").keySerializer(METADATA_KEY_SERIALIZER).valueSerializer(MAVEN_METADATA_SERIALIZER).createOrOpen();
            this.normalizedRepositoryUrls = localRepositoryDiskDb.hashMap("repository.urls").keySerializer(REPOSITORY_SERIALIZER).valueSerializer(OPTIONAL_REPOSITORY_SERIALIZER).createOrOpen();
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "disk", "content", "poms"}), this.pomCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "disk", "content", "metadata"}), this.mavenMetadataCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "disk", "content", "repository urls"}), this.normalizedRepositoryUrls);
        } else {
            DB inMemoryDb = DBMaker.heapDB().make();
            this.pomCache = inMemoryDb.hashMap("pom.inmem").keySerializer(POM_KEY_SERIALIZER).valueSerializer(MAVEN_SERIALIZER).expireStoreSize(maxCacheStoreSize == null ? 0L : maxCacheStoreSize).create();
            this.mavenMetadataCache = inMemoryDb.hashMap("metadata.inmem").keySerializer(METADATA_KEY_SERIALIZER).valueSerializer(MAVEN_METADATA_SERIALIZER).expireStoreSize(maxCacheStoreSize == null ? 0L : maxCacheStoreSize).create();
            this.normalizedRepositoryUrls = inMemoryDb.hashMap("repository.urls").keySerializer(REPOSITORY_SERIALIZER).valueSerializer(OPTIONAL_REPOSITORY_SERIALIZER).create();
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "memory", "content", "pom"}), this.pomCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "memory", "content", "metadata"}), this.mavenMetadataCache);
            Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "mapdb", "layer", "memory", "content", "repository urls"}), this.normalizedRepositoryUrls);
        }
    }

    @Override
    public CacheResult<MavenMetadata> getMavenMetadata(MavenPomCache.MetadataKey key) {
        return this.filterExpired((CacheResult)this.mavenMetadataCache.get((Object)key));
    }

    @Override
    public CacheResult<MavenMetadata> setMavenMetadata(MavenPomCache.MetadataKey key, MavenMetadata metadata, boolean isSnapshot) {
        long ttl = this.calculateExpiration(isSnapshot ? this.snapshotTimeToLiveMilliseconds : this.releaseTimeToLiveMilliseconds);
        this.mavenMetadataCache.put((Object)key, new CacheResult<MavenMetadata>(CacheResult.State.Cached, metadata, ttl));
        return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata, ttl);
    }

    @Override
    public CacheResult<RawMaven> getMaven(MavenPomCache.PomKey key) {
        return this.filterExpired((CacheResult)this.pomCache.get((Object)key));
    }

    @Override
    public CacheResult<RawMaven> setMaven(MavenPomCache.PomKey key, RawMaven maven, boolean isSnapshot) {
        long ttl = this.calculateExpiration(isSnapshot ? this.snapshotTimeToLiveMilliseconds : this.releaseTimeToLiveMilliseconds);
        this.pomCache.put((Object)key, new CacheResult<RawMaven>(CacheResult.State.Cached, maven, ttl));
        return new CacheResult<RawMaven>(CacheResult.State.Updated, maven, ttl);
    }

    @Override
    public CacheResult<MavenRepository> getNormalizedRepository(MavenRepository repository) {
        return this.filterExpired((CacheResult)this.normalizedRepositoryUrls.get((Object)repository));
    }

    @Override
    public CacheResult<MavenRepository> setNormalizedRepository(MavenRepository repository, MavenRepository normalized) {
        long ttl = this.calculateExpiration(normalized == null ? 60000L : 3600000L);
        this.normalizedRepositoryUrls.put((Object)repository, new CacheResult<MavenRepository>(CacheResult.State.Cached, normalized, ttl));
        return new CacheResult<MavenRepository>(CacheResult.State.Updated, normalized, ttl);
    }

    @Override
    public void close() {
        this.pomCache.close();
        this.mavenMetadataCache.close();
        this.normalizedRepositoryUrls.close();
    }

    @Override
    public void clear() {
        this.pomCache.clear();
        this.mavenMetadataCache.clear();
        this.normalizedRepositoryUrls.clear();
    }
}

