/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.MavenRepository;

public class InMemoryMavenPomCache
implements MavenPomCache {
    private final Map<MavenPomCache.PomKey, CacheResult<RawMaven>> pomCache = new HashMap<MavenPomCache.PomKey, CacheResult<RawMaven>>();
    private final Map<MavenPomCache.MetadataKey, CacheResult<MavenMetadata>> mavenMetadataCache = new HashMap<MavenPomCache.MetadataKey, CacheResult<MavenMetadata>>();
    private final Map<MavenRepository, CacheResult<MavenRepository>> repositoryCache = new HashMap<MavenRepository, CacheResult<MavenRepository>>();
    private final long releaseTimeToLiveMilliseconds;
    private final long snapshotTimeToLiveMilliseconds;

    public InMemoryMavenPomCache() {
        this(3600000L, 60000L);
    }

    public InMemoryMavenPomCache(long releaseTimeToLiveMilliseconds, long snapshotTimeToLiveMilliseconds) {
        this.releaseTimeToLiveMilliseconds = releaseTimeToLiveMilliseconds;
        this.snapshotTimeToLiveMilliseconds = snapshotTimeToLiveMilliseconds;
        Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "inmem", "content", "poms"}), this.pomCache);
        Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "inmem", "content", "metadata"}), this.mavenMetadataCache);
        Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "inmem", "content", "repository urls"}), this.repositoryCache);
    }

    @Override
    @Nullable
    public CacheResult<MavenMetadata> getMavenMetadata(MavenPomCache.MetadataKey key) {
        return this.filterExpired(this.mavenMetadataCache.get(key));
    }

    @Override
    public CacheResult<MavenMetadata> setMavenMetadata(MavenPomCache.MetadataKey key, MavenMetadata metadata, boolean isSnapshot) {
        long ttl = System.currentTimeMillis() + (isSnapshot ? this.snapshotTimeToLiveMilliseconds : this.releaseTimeToLiveMilliseconds);
        this.mavenMetadataCache.put(key, new CacheResult<MavenMetadata>(CacheResult.State.Cached, metadata, ttl));
        return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata, ttl);
    }

    @Override
    @Nullable
    public CacheResult<RawMaven> getMaven(MavenPomCache.PomKey key) {
        return this.filterExpired(this.pomCache.get(key));
    }

    @Override
    public CacheResult<RawMaven> setMaven(MavenPomCache.PomKey key, RawMaven maven, boolean isSnapshot) {
        long ttl = System.currentTimeMillis() + (isSnapshot ? this.snapshotTimeToLiveMilliseconds : this.releaseTimeToLiveMilliseconds);
        this.pomCache.put(key, new CacheResult<RawMaven>(CacheResult.State.Cached, maven, ttl));
        return new CacheResult<RawMaven>(CacheResult.State.Updated, maven, ttl);
    }

    @Override
    @Nullable
    public CacheResult<MavenRepository> getNormalizedRepository(MavenRepository repository) {
        return this.filterExpired(this.repositoryCache.get(repository));
    }

    @Override
    public CacheResult<MavenRepository> setNormalizedRepository(MavenRepository repository, MavenRepository normalized) {
        long ttl = this.calculateExpiration(normalized == null ? 60000L : 3600000L);
        this.repositoryCache.put(repository, new CacheResult<MavenRepository>(CacheResult.State.Cached, normalized, ttl));
        return new CacheResult<MavenRepository>(CacheResult.State.Updated, normalized, ttl);
    }

    @Override
    public void clear() {
        this.pomCache.clear();
        this.mavenMetadataCache.clear();
        this.repositoryCache.clear();
    }

    @Override
    public void close() throws Exception {
    }
}

