/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.xml.AutoFormatVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class OrderPomElements
extends Recipe {
    private static final List<String> REQUIRED_ORDER = Arrays.asList("modelVersion", "parent", "groupId", "artifactId", "version", "packaging", "name", "description", "url", "inceptionYear", "organization", "licenses", "developers", "contributors", "mailingLists", "prerequisites", "modules", "scm", "issueManagement", "ciManagement", "distributionManagement", "properties", "dependencyManagement", "dependencies", "repositories", "pluginRepositories", "build", "reporting", "profiles");

    public String getDisplayName() {
        return "Order POM elements";
    }

    public String getDescription() {
        return "Order POM elements according to the [recommended](http://maven.apache.org/developers/conventions/code.html#pom-code-convention) order.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3423");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected MavenVisitor getVisitor() {
        return new MavenVisitor(){

            @Override
            public Maven visitMaven(Maven maven, ExecutionContext ctx) {
                Maven mvn = super.visitMaven(maven, ctx);
                Xml.Tag root = mvn.getRoot();
                if (root.getContent() != null) {
                    Content updated;
                    Content original;
                    HashMap groupedContents = new HashMap(root.getContent().size());
                    ArrayList<Object> groupedContent = new ArrayList<Object>();
                    ArrayList<Object> otherContent = new ArrayList<Object>();
                    HashMap<UUID, Integer> groupSizes = new HashMap<UUID, Integer>();
                    for (Object content : root.getContent()) {
                        if (content instanceof Xml.Comment) {
                            groupedContent.add(content);
                            continue;
                        }
                        if (content instanceof Xml.Tag) {
                            groupedContent.add(content);
                            groupedContents.put(((Xml.Tag)content).getName(), groupedContent);
                            groupSizes.put(((Content)groupedContent.get(0)).getId(), groupedContent.size());
                            groupedContent = new ArrayList();
                            continue;
                        }
                        groupedContent.add(content);
                        otherContent.addAll(groupedContent);
                        groupSizes.put(((Content)groupedContent.get(0)).getId(), groupedContent.size());
                        groupedContent = new ArrayList();
                    }
                    ArrayList<Object> updatedOrder = new ArrayList<Object>(root.getContent().size());
                    for (String order : REQUIRED_ORDER) {
                        if (!groupedContents.containsKey(order)) continue;
                        updatedOrder.addAll((Collection)groupedContents.get(order));
                        groupedContents.remove(order);
                    }
                    for (List value : groupedContents.values()) {
                        updatedOrder.addAll(value);
                    }
                    updatedOrder.addAll(otherContent);
                    int beforeIndex = 0;
                    int afterIndex = 0;
                    for (int i = 0; i < root.getContent().size() && beforeIndex != root.getContent().size() && afterIndex != updatedOrder.size(); beforeIndex += ((Integer)groupSizes.get(original.getId())).intValue(), afterIndex += ((Integer)groupSizes.get(updated.getId())).intValue(), ++i) {
                        original = (Content)root.getContent().get(beforeIndex);
                        updated = (Content)updatedOrder.get(afterIndex);
                        updatedOrder.set(afterIndex, (Content)updated.withPrefix(original.getPrefix()));
                    }
                    boolean foundChange = false;
                    for (int i = 0; i < root.getContent().size(); ++i) {
                        if (root.getContent().get(i) == updatedOrder.get(i)) continue;
                        foundChange = true;
                        break;
                    }
                    if (foundChange) {
                        root = root.withContent(updatedOrder);
                        mvn = mvn.withRoot(root);
                        mvn = (Maven)new AutoFormatVisitor(new Xml.Tag[0]).visitNonNull((Tree)mvn, (Object)ctx);
                    }
                }
                return mvn;
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag tg = (Xml.Tag)super.visitTag(tag, (Object)executionContext);
                if ("dependency".equals(tg.getName()) || "parent".equals(tg.getName())) {
                    tg = this.orderGav(tg);
                }
                return tg;
            }

            private Xml.Tag orderGav(Xml.Tag gavParent) {
                if (gavParent.getContent() != null) {
                    int groupPos = -1;
                    int artifactPos = -1;
                    int versionPos = -1;
                    HashMap gavGroups = new HashMap();
                    ArrayList<Object> groupedContent = new ArrayList<Object>();
                    ArrayList<Object> otherContent = new ArrayList<Object>();
                    for (int i = 0; i < gavParent.getContent().size(); ++i) {
                        Content content = (Content)gavParent.getContent().get(i);
                        if (content instanceof Xml.Comment) {
                            groupedContent.add(content);
                            continue;
                        }
                        if (content instanceof Xml.Tag) {
                            Xml.Tag tag = (Xml.Tag)content;
                            if ("groupId".equals(tag.getName())) {
                                groupPos = i;
                            } else if ("artifactId".equals(tag.getName())) {
                                artifactPos = i;
                            } else if ("version".equals(tag.getName())) {
                                versionPos = i;
                            }
                            switch (tag.getName()) {
                                case "groupId": 
                                case "artifactId": 
                                case "version": {
                                    groupedContent.add(tag);
                                    gavGroups.put(tag.getName(), groupedContent);
                                    groupedContent = new ArrayList();
                                    break;
                                }
                                default: {
                                    otherContent.addAll(groupedContent);
                                    otherContent.add(content);
                                    groupedContent = new ArrayList();
                                    break;
                                }
                            }
                            continue;
                        }
                        otherContent.addAll(groupedContent);
                        otherContent.add(content);
                        groupedContent = new ArrayList();
                    }
                    if (groupPos > artifactPos || versionPos > -1 && artifactPos > versionPos) {
                        ArrayList<Object> orderedContents = new ArrayList<Object>();
                        for (String type : new String[]{"groupId", "artifactId", "version"}) {
                            List gavContents = (List)gavGroups.get(type);
                            if (gavContents == null) continue;
                            orderedContents.addAll(gavContents);
                        }
                        orderedContents.addAll(otherContent);
                        gavParent = gavParent.withContent(orderedContents);
                    }
                }
                return gavParent;
            }
        };
    }
}

