/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.internal.MavenParsingException;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;

public class MavenExecutionContextView
extends DelegatingExecutionContext {
    private static final String MAVEN_MIRRORS = "org.openrewrite.maven.mirrors";
    private static final String MAVEN_CREDENTIALS = "org.openrewrite.maven.auth";
    private static final String MAVEN_REPOSITORIES = "org.openrewrite.maven.repos";
    private static final String MAVEN_PINNED_SNAPSHOT_VERSIONS = "org.openrewrite.maven.pinnedSnapshotVersions";

    public MavenExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public void setMirrors(Collection<MavenRepositoryMirror> mirrors) {
        this.putMessage(MAVEN_MIRRORS, mirrors);
    }

    public Collection<MavenRepositoryMirror> getMirrors() {
        return (Collection)this.getMessage(MAVEN_MIRRORS, Collections.emptyList());
    }

    public void setCredentials(Collection<MavenRepositoryCredentials> credentials) {
        this.putMessage(MAVEN_CREDENTIALS, credentials);
    }

    public Collection<MavenRepositoryCredentials> getCredentials() {
        return (Collection)this.getMessage(MAVEN_CREDENTIALS, Collections.emptyList());
    }

    public void setRepositories(List<MavenRepository> repositories) {
        this.putMessage(MAVEN_REPOSITORIES, repositories);
    }

    public List<MavenRepository> getRepositories() {
        return (List)this.getMessage(MAVEN_REPOSITORIES, Collections.emptyList());
    }

    public void setPinnedSnapshotVersions(Collection<GroupArtifactVersion> pinnedSnapshotVersions) {
        this.putMessage(MAVEN_PINNED_SNAPSHOT_VERSIONS, pinnedSnapshotVersions);
    }

    public Collection<GroupArtifactVersion> getPinnedSnapshotVersions() {
        return (Collection)this.getMessage(MAVEN_PINNED_SNAPSHOT_VERSIONS, Collections.emptyList());
    }

    public void setMavenSettings(@Nullable MavenSettings settings, String ... activeProfiles) {
        if (settings == null) {
            return;
        }
        if (settings.getServers() != null) {
            this.setCredentials(settings.getServers().getServers().stream().map(server -> new MavenRepositoryCredentials(server.getId(), server.getUsername(), server.getPassword())).collect(Collectors.toList()));
        }
        if (settings.getMirrors() != null) {
            this.setMirrors(settings.getMirrors().getMirrors().stream().map(mirror -> new MavenRepositoryMirror(mirror.getId(), mirror.getUrl(), mirror.getMirrorOf(), mirror.getReleases(), mirror.getSnapshots())).collect(Collectors.toList()));
        }
        this.setRepositories(settings.getActiveRepositories(activeProfiles).stream().map(repo -> {
            try {
                return new MavenRepository(repo.getId(), URI.create(repo.getUrl()), repo.getReleases() == null || repo.getReleases().isEnabled(), repo.getSnapshots() != null && repo.getSnapshots().isEnabled(), null, null);
            }
            catch (Exception exception) {
                this.getOnError().accept(new MavenParsingException("Unable to parse URL %s for Maven settings repository id %s", (Throwable)exception, repo.getUrl(), repo.getId()));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

