/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ChangePluginExecutions
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;
    @Option(displayName="Executions", description="Plugin goal executions provided as raw XML. Supplying `null` will remove any existing executions.", example="<execution><phase>validate</phase><goals><goal>dryRun</goal></goals></execution>", required=false)
    @Nullable
    @Language(value="xml")
    private final String executions;

    public String getDisplayName() {
        return "Change Maven plugin executions";
    }

    public String getDescription() {
        return "Apply the specified executions to a Maven plugin. Will not add the plugin if it does not already exist in the pom.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional<Xml.Tag> maybePlugin;
                Xml.Tag plugins = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (PLUGINS_MATCHER.matches(this.getCursor()) && (maybePlugin = plugins.getChildren().stream().filter(plugin -> plugin.getName().equals("plugin") && ChangePluginExecutions.this.groupId.equals(plugin.getChildValue("groupId").orElse(null)) && ChangePluginExecutions.this.artifactId.equals(plugin.getChildValue("artifactId").orElse(null))).findAny()).isPresent()) {
                    Xml.Tag plugin2 = maybePlugin.get();
                    plugins = ChangePluginExecutions.this.executions == null ? FilterTagChildrenVisitor.filterChildren((Xml.Tag)plugins, (Xml.Tag)plugin2, child -> !(child instanceof Xml.Tag) || !"executions".equals(((Xml.Tag)child).getName())) : AddOrUpdateChild.addOrUpdateChild((Xml.Tag)plugins, (Xml.Tag)plugin2, (Xml.Tag)Xml.Tag.build((String)("<executions>\n" + ChangePluginExecutions.this.executions + "\n</executions>")), (Cursor)this.getCursor().getParentOrThrow());
                }
                return plugins;
            }
        };
    }

    public ChangePluginExecutions(String groupId, String artifactId, @Nullable @Language(value="xml") String executions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.executions = executions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    @Language(value="xml")
    public String getExecutions() {
        return this.executions;
    }

    @NonNull
    public String toString() {
        return "ChangePluginExecutions(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", executions=" + this.getExecutions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginExecutions)) {
            return false;
        }
        ChangePluginExecutions other = (ChangePluginExecutions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$executions = this.getExecutions();
        String other$executions = other.getExecutions();
        return !(this$executions == null ? other$executions != null : !this$executions.equals(other$executions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePluginExecutions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $executions = this.getExecutions();
        result = result * 59 + ($executions == null ? 43 : $executions.hashCode());
        return result;
    }
}

