/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ChangePackaging
extends Recipe {
    private static final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");
    @Option(displayName="Group", description="The groupId of the project whose packaging should be changed. Accepts glob patterns.", example="org.openrewrite.*")
    private final String groupId;
    @Option(displayName="Group", description="The artifactId of the project whose packaging should be changed. Accepts glob patterns.", example="rewrite-*")
    private final String artifactId;
    @Option(displayName="Packaging", description="The type of packaging to set. If `null` specified the packaging tag will be removed", example="jar")
    @Nullable
    private final String packaging;

    public String getDisplayName() {
        return "Set Maven project packaging";
    }

    public String getDescription() {
        return "Sets the packaging type of Maven projects. Either adds the packaging tag if it is missing or changes its context if present.";
    }

    public MavenVisitor getVisitor() {
        return new MavenVisitor(){

            @Override
            public Maven visitMaven(Maven maven, ExecutionContext ctx) {
                Pom pom = maven.getModel();
                if (!StringUtils.matchesGlob((String)pom.getGroupId(), (String)ChangePackaging.this.groupId) || !StringUtils.matchesGlob((String)pom.getArtifactId(), (String)ChangePackaging.this.artifactId)) {
                    return maven;
                }
                maven = maven.withModel(pom.withPackaging(ChangePackaging.this.packaging));
                return super.visitMaven(maven, ctx);
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext context) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)context);
                if (PROJECT_MATCHER.matches(this.getCursor())) {
                    t = ChangePackaging.this.packaging == null ? FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)t, it -> !"packaging".equals(it.getName())) : AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)Xml.Tag.build((String)("\n<packaging>" + ChangePackaging.this.packaging + "</packaging>")), (Cursor)this.getCursor().getParentOrThrow());
                }
                return t;
            }
        };
    }

    public ChangePackaging(String groupId, String artifactId, @Nullable String packaging) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getPackaging() {
        return this.packaging;
    }

    @NonNull
    public String toString() {
        return "ChangePackaging(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", packaging=" + this.getPackaging() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackaging)) {
            return false;
        }
        ChangePackaging other = (ChangePackaging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$packaging = this.getPackaging();
        String other$packaging = other.getPackaging();
        return !(this$packaging == null ? other$packaging != null : !this$packaging.equals(other$packaging));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackaging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $packaging = this.getPackaging();
        result = result * 59 + ($packaging == null ? 43 : $packaging.hashCode());
        return result;
    }
}

