/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeDependencyVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Trust parent POM", description="Even if the parent suggests a version that is older than what we are trying to upgrade to, trust it anyway. Useful when you want to wait for the parent to catch up before upgrading. The parent is not trusted by default.", example="false", required=false)
    @Nullable
    private final Boolean trustParent;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven dependency version";
    }

    public String getDescription() {
        return "Upgrade the version of a dependency by specifying a group or group and artifact using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UpgradeDependencyVersionVisitor();
    }

    public UpgradeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean trustParent) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.trustParent = trustParent;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getTrustParent() {
        return this.trustParent;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", trustParent=" + this.getTrustParent() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private class ChangeDependencyVersionVisitor
    extends MavenVisitor {
        private final String newVersion;
        private final String groupId;
        private final String artifactId;

        private ChangeDependencyVersionVisitor(String newVersion, String groupId, String artifactId) {
            this.newVersion = newVersion;
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            block6: {
                block4: {
                    block5: {
                        String version;
                        Optional versionTag;
                        block7: {
                            if (!this.isDependencyTag(this.groupId, this.artifactId) && !this.isManagedDependencyTag(this.groupId, this.artifactId)) break block4;
                            versionTag = tag.getChild("version");
                            if (!versionTag.isPresent()) break block5;
                            version = ((Xml.Tag)versionTag.get()).getValue().orElse(null);
                            if (version == null) break block6;
                            if (!version.trim().startsWith("${") || this.newVersion.equals(this.model.getValue(version.trim()))) break block7;
                            this.doAfterVisit(new ChangePropertyValue(version, this.newVersion));
                            break block6;
                        }
                        if (this.newVersion.equals(version)) break block6;
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), this.newVersion));
                        break block6;
                    }
                    if (this.isManagedDependencyTag(this.groupId, this.artifactId)) break block6;
                    Xml.Tag newVersionTag = Xml.Tag.build((String)("<version>" + this.newVersion + "</version>"));
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor((Xml.Tag)this.getCursor().getValue(), newVersionTag));
                    break block6;
                }
                if (!this.modules.isEmpty() && this.isPropertyTag()) {
                    String propertyKeyRef = "${" + tag.getName() + "}";
                    block0: for (Pom module : this.modules) {
                        for (Pom.Dependency dependency : module.getDependencies()) {
                            if (!this.artifactId.equals(dependency.getArtifactId()) || !propertyKeyRef.equals(dependency.getRequestedVersion())) continue;
                            this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, this.newVersion));
                            this.doAfterVisit(new RemoveRedundantDependencyVersions());
                            break block0;
                        }
                        for (DependencyManagementDependency dependencyManagementDependency : module.getDependencyManagement().getDependencies()) {
                            if (!this.artifactId.equals(dependencyManagementDependency.getArtifactId()) || !propertyKeyRef.equals(dependencyManagementDependency.getRequestedVersion())) continue;
                            this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, this.newVersion));
                            this.doAfterVisit(new RemoveRedundantDependencyVersions());
                            break block0;
                        }
                    }
                }
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }

    private class UpgradeDependencyVersionVisitor
    extends MavenVisitor {
        @Nullable
        private Collection<String> availableVersions;
        private final VersionComparator versionComparator;

        public UpgradeDependencyVersionVisitor() {
            this.versionComparator = (VersionComparator)Semver.validate((String)UpgradeDependencyVersion.this.newVersion, (String)UpgradeDependencyVersion.this.versionPattern).getValue();
        }

        @Override
        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            return maven.withMavenModel(maven.getMavenModel().withPom(this.maybeChangeDependencyVersion(maven.getModel(), ctx))).withModules(ListUtils.map(maven.getModules(), module -> this.maybeChangeDependencyVersion((Pom)module, ctx)));
        }

        private Pom maybeChangeDependencyVersion(Pom model, ExecutionContext ctx) {
            return model.withDependencies(ListUtils.map(model.getDependencies(), dependency -> {
                if (StringUtils.matchesGlob((String)dependency.getGroupId(), (String)UpgradeDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) {
                    String managedVersion;
                    if (model.getParent() != null && (managedVersion = model.getParent().getManagedVersion(dependency.getGroupId(), dependency.getArtifactId())) != null) {
                        return dependency;
                    }
                    return this.findNewerDependencyVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), ctx).map(newer -> {
                        ChangeDependencyVersionVisitor changeDependencyVersion = new ChangeDependencyVersionVisitor((String)newer, dependency.getGroupId(), dependency.getArtifactId());
                        this.doAfterVisit((TreeVisitor)changeDependencyVersion);
                        return dependency.withVersion((String)newer);
                    }).orElse((Pom.Dependency)dependency);
                }
                return dependency;
            })).withDependencyManagement(model.getDependencyManagement().withDependencies(ListUtils.map(model.getDependencyManagement().getDependencies(), dependency -> {
                if (StringUtils.matchesGlob((String)dependency.getGroupId(), (String)UpgradeDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) {
                    return this.findNewerDependencyVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), ctx).map(newer -> {
                        ChangeDependencyVersionVisitor changeDependencyVersion = new ChangeDependencyVersionVisitor((String)newer, dependency.getGroupId(), dependency.getArtifactId());
                        this.doAfterVisit((TreeVisitor)changeDependencyVersion);
                        return dependency.withVersion((String)newer);
                    }).orElse((DependencyManagementDependency)dependency);
                }
                return dependency;
            })));
        }

        private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) {
            if (this.availableVersions == null) {
                MavenMetadata mavenMetadata = new MavenPomDownloader(MavenPomCache.NOOP, Collections.emptyMap(), ctx).downloadMetadata(groupId, artifactId, ((Maven)((Object)this.getCursor().firstEnclosingOrThrow(Maven.class))).getModel().getEffectiveRepositories());
                this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(v -> this.versionComparator.isValid(currentVersion, v)).collect(Collectors.toList());
            }
            return this.versionComparator.upgrade(currentVersion, this.availableVersions);
        }
    }
}

