/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    public String getDisplayName() {
        return "Remove redundant explicit dependency versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependency versions when a parent pom's dependencyManagement specifies the same explicit version.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FindManagedDependencyVersionVisitor();
    }

    @NonNull
    public String toString() {
        return "RemoveRedundantDependencyVersions()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static class RemoveVersionVisitor
    extends MavenVisitor {
        private final String moduleArtifactId;
        private final String groupId;
        private final String artifactId;
        private final DependencyManagementDependency.Defined managedVersion;

        public RemoveVersionVisitor(String moduleArtifactId, String groupId, String artifactId, DependencyManagementDependency.Defined managedVersion) {
            this.moduleArtifactId = moduleArtifactId;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.managedVersion = managedVersion;
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.model.getArtifactId().equals(this.moduleArtifactId) && this.isDependencyTag(this.groupId, this.artifactId) && tag.getContent() != null) {
                List contents = tag.getContent();
                Xml.Tag versionTag = null;
                Scope scope = null;
                for (Content content : contents) {
                    Xml.Tag contentTag = (Xml.Tag)content;
                    if (contentTag.getName().equals("version") && contentTag.getValue().isPresent() && this.managedVersion.getVersion() != null && this.managedVersion.getVersion().equals(contentTag.getValue().get())) {
                        versionTag = contentTag;
                        continue;
                    }
                    if (!contentTag.getName().equals("scope") || !contentTag.getValue().isPresent()) continue;
                    scope = Scope.fromName((String)contentTag.getValue().get());
                }
                if (versionTag != null && FindManagedDependencyVersionVisitor.scopeMatches(scope, this.managedVersion.getScope())) {
                    this.doAfterVisit((TreeVisitor)new RemoveContentVisitor(versionTag, false));
                }
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }

    private static class FindManagedDependencyVersionVisitor
    extends MavenVisitor {
        private FindManagedDependencyVersionVisitor() {
        }

        @Override
        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            Maven newMaven = super.visitMaven(maven, ctx);
            ArrayList<Pom.Dependency> dependencies = new ArrayList<Pom.Dependency>(maven.getModel().getDependencies());
            for (Pom.Dependency dependency : dependencies) {
                Scope scope;
                DependencyManagementDependency.Defined managedVersion = this.findManagedVersion(maven.getModel(), dependency);
                Scope scope2 = scope = managedVersion != null ? managedVersion.getScope() : null;
                if (managedVersion == null || managedVersion.getVersion() == null || dependency.getRequestedVersion() == null || !dependency.getVersion().equals(dependency.getRequestedVersion()) || !managedVersion.getVersion().equals(dependency.getRequestedVersion()) || !FindManagedDependencyVersionVisitor.scopeMatches(scope, dependency.getScope())) continue;
                this.doAfterVisit((TreeVisitor)new RemoveVersionVisitor(maven.getModel().getArtifactId(), dependency.getGroupId(), dependency.getArtifactId(), managedVersion));
            }
            return newMaven;
        }

        private static Scope scopeOrDefault(@Nullable Scope scope) {
            if (scope == null) {
                return Scope.Compile;
            }
            return scope;
        }

        private static boolean scopeMatches(@Nullable Scope firstScope, @Nullable Scope secondScope) {
            return Objects.equals((Object)FindManagedDependencyVersionVisitor.scopeOrDefault(firstScope), (Object)FindManagedDependencyVersionVisitor.scopeOrDefault(secondScope));
        }

        @Nullable
        private DependencyManagementDependency.Defined findManagedVersion(Pom pom, Pom.Dependency dependency) {
            if (pom.getDependencyManagement() != null) {
                List<DependencyManagementDependency> managedDependencies = pom.getDependencyManagement().getDependencies();
                for (DependencyManagementDependency managedDependency : managedDependencies) {
                    if (!(managedDependency instanceof DependencyManagementDependency.Defined)) continue;
                    DependencyManagementDependency.Defined definedDependency = (DependencyManagementDependency.Defined)managedDependency;
                    if (!dependency.getGroupId().equals(definedDependency.getGroupId()) || !dependency.getArtifactId().equals(definedDependency.getArtifactId()) || definedDependency.getVersion() == null) continue;
                    return definedDependency;
                }
            }
            if (pom.getParent() == null) {
                return null;
            }
            return this.findManagedVersion(pom.getParent(), dependency);
        }
    }
}

