/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawMavenResolver;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.maven.tree.Modules;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class MavenParser
implements Parser<Maven> {
    private final MavenPomCache mavenPomCache;
    private final Collection<String> activeProfiles;
    private final boolean resolveOptional;

    private MavenParser(MavenPomCache mavenPomCache, Collection<String> activeProfiles, boolean resolveOptional) {
        this.mavenPomCache = mavenPomCache;
        this.activeProfiles = activeProfiles;
        this.resolveOptional = resolveOptional;
    }

    public List<Maven> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Maven> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        LinkedHashMap<RawMaven, Xml.Document> projectPoms = new LinkedHashMap<RawMaven, Xml.Document>();
        for (Parser.Input source : sources) {
            projectPoms.put(RawMaven.parse(source, relativeTo, null, ctx), (Xml.Document)new MavenXmlParser().parseInputs(Collections.singletonList(source), relativeTo, ctx).iterator().next());
        }
        MavenPomDownloader downloader = new MavenPomDownloader(this.mavenPomCache, projectPoms.keySet().stream().collect(Collectors.toMap(RawMaven::getSourcePath, Function.identity())), ctx);
        ArrayList<Maven> parsed = new ArrayList<Maven>();
        HashMap<String, String> effectiveProperties = new HashMap<String, String>();
        if (relativeTo != null) {
            effectiveProperties.put("project.basedir", relativeTo.toString());
            effectiveProperties.put("basedir", relativeTo.toString());
        }
        for (Map.Entry rawToDoc : projectPoms.entrySet()) {
            RawMaven raw = ((RawMaven)rawToDoc.getKey()).withProjectPom(true);
            MavenModel model = new RawMavenResolver(downloader, this.activeProfiles, this.resolveOptional, ctx).resolve(raw, effectiveProperties);
            if (model == null) continue;
            parsed.add(new Maven(((Xml.Document)rawToDoc.getValue()).withMarkers(((Xml.Document)rawToDoc.getValue()).getMarkers().compute((Marker)model, (old, n) -> n))));
        }
        for (int i = 0; i < parsed.size(); ++i) {
            Maven maven = (Maven)((Object)parsed.get(i));
            ArrayList<Pom> modules = new ArrayList<Pom>(0);
            for (Maven possibleModule : parsed) {
                Pom parent = possibleModule.getModel().getParent();
                if (parent == null || !parent.getGroupId().equals(maven.getModel().getGroupId()) || !parent.getArtifactId().equals(maven.getModel().getArtifactId()) || !parent.getVersion().equals(maven.getModel().getVersion())) continue;
                modules.add(possibleModule.getModel());
            }
            if (modules.isEmpty()) continue;
            parsed.set(i, maven.withMarkers(maven.getMarkers().compute((Marker)new Modules(Tree.randomId(), modules), (old, n) -> n)));
        }
        return parsed;
    }

    public boolean accept(Path path) {
        return path.toString().equals("pom.xml") || path.toString().endsWith(".pom");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MavenPomCache mavenPomCache = new InMemoryMavenPomCache();
        private final Collection<String> activeProfiles = new HashSet<String>();
        private boolean resolveOptional = false;

        Builder resolveOptional(@Nullable Boolean optional) {
            this.resolveOptional = optional == null || optional != false;
            return this;
        }

        public Builder activeProfiles(String ... profiles) {
            if (profiles != null) {
                Collections.addAll(this.activeProfiles, profiles);
            }
            return this;
        }

        public Builder mavenConfig(@Nullable Path mavenConfig) {
            if (mavenConfig != null && mavenConfig.toFile().exists()) {
                try {
                    String mavenConfigText = new String(Files.readAllBytes(mavenConfig));
                    Matcher matcher = Pattern.compile("(?:$|\\s)-P\\s+([^\\s]+)").matcher(mavenConfigText);
                    if (matcher.find()) {
                        String[] profiles = matcher.group(1).split(",");
                        return this.activeProfiles(profiles);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this;
        }

        public Builder cache(MavenPomCache cache) {
            this.mavenPomCache = cache;
            return this;
        }

        public MavenParser build() {
            return new MavenParser(this.mavenPomCache, this.activeProfiles, this.resolveOptional);
        }
    }

    private static class MavenXmlParser
    extends XmlParser {
        private MavenXmlParser() {
        }

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    }
}

