/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;

public final class PrintMavenAsCycloneDxBom {
    private PrintMavenAsCycloneDxBom() {
    }

    public static String print(Maven maven) {
        Pom pom = maven.getModel();
        StringBuilder bom = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bom.append("<bom xmlns=\"http://cyclonedx.org/schema/bom/1.2\" serialNumber=\"urn:uuid:").append(maven.getId().toString()).append("\" version=\"1\">\n");
        PrintMavenAsCycloneDxBom.writeMetadata(maven.getModel(), bom);
        Map<DependencyKey, Pom.Dependency> dependencies = PrintMavenAsCycloneDxBom.traverseDependencies(pom.getDependencies(), new LinkedHashMap<DependencyKey, Pom.Dependency>());
        PrintMavenAsCycloneDxBom.writeComponents(dependencies, bom);
        PrintMavenAsCycloneDxBom.writeDependencies(dependencies, bom);
        bom.append("</bom>\n");
        return bom.toString();
    }

    private static void writeMetadata(Pom pom, StringBuilder bom) {
        bom.append("    <metadata>\n");
        bom.append("        <timestamp>").append(Instant.now().toString()).append("</timestamp>\n");
        bom.append("        <tools>\n");
        bom.append("            <tool>\n");
        bom.append("                <vendor>OpenRewrite</vendor>\n");
        bom.append("                <name>OpenRewrite CycloneDX</name>\n");
        bom.append("                <version>7.0.0</version>\n");
        bom.append("            </tool>\n");
        bom.append("        </tools>\n");
        String bomReference = PrintMavenAsCycloneDxBom.getBomReference(pom.getGroupId(), pom.getArtifactId(), pom.getValue(pom.getVersion()));
        PrintMavenAsCycloneDxBom.writeComponent(pom, bomReference, pom.getVersion(), Scope.Compile, bom);
        bom.append("    </metadata>\n");
    }

    private static void writeComponents(Map<DependencyKey, Pom.Dependency> dependencyMap, StringBuilder bom) {
        if (dependencyMap.isEmpty()) {
            return;
        }
        HashSet<String> componentsWritten = new HashSet<String>(dependencyMap.size());
        bom.append("    <components>\n");
        for (Pom.Dependency component : dependencyMap.values()) {
            String bomReference = PrintMavenAsCycloneDxBom.getBomReference(component.getGroupId(), component.getArtifactId(), component.getVersion());
            if (componentsWritten.contains(bomReference)) continue;
            PrintMavenAsCycloneDxBom.writeComponent(component.getModel(), bomReference, component.getVersion(), component.getScope(), bom);
            componentsWritten.add(bomReference);
        }
        bom.append("    </components>\n");
    }

    private static void writeDependencies(Map<DependencyKey, Pom.Dependency> dependencyMap, StringBuilder bom) {
        if (dependencyMap.isEmpty()) {
            return;
        }
        bom.append("    <dependencies>\n");
        for (Pom.Dependency dependency : dependencyMap.values()) {
            PrintMavenAsCycloneDxBom.writeDependency(dependency, bom);
        }
        bom.append("    </dependencies>\n");
    }

    private static void writeDependency(Pom.Dependency dependency, StringBuilder bom) {
        String bomReference = PrintMavenAsCycloneDxBom.getBomReference(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        bom.append("        <dependency ref=\"").append(bomReference).append("\">\n");
        if (dependency.getModel().getDependencies() != null) {
            for (Pom.Dependency nested : dependency.getModel().getDependencies()) {
                bom.append("            <dependency ref=\"").append(PrintMavenAsCycloneDxBom.getBomReference(nested.getGroupId(), nested.getArtifactId(), nested.getVersion())).append("\"/>\n");
            }
        }
        bom.append("        </dependency>\n");
    }

    private static void writeComponent(Pom pom, String bomReference, String version, Scope scope, StringBuilder bom) {
        String type = "library";
        if (pom.getPackaging().equals("war") || pom.getPackaging().equals("ear")) {
            type = "application";
        }
        String indent = "        ";
        bom.append(indent).append("<component bom-ref=\"").append(bomReference).append("\" type=\"").append(type).append("\">\n");
        bom.append(indent).append("    <group>").append(pom.getGroupId()).append("</group>\n");
        bom.append(indent).append("    <name>").append(pom.getArtifactId()).append("</name>\n");
        bom.append(indent).append("    <version>").append(version).append("</version>\n");
        if (pom.getDescription() != null) {
            bom.append(indent).append("    <description>\n");
            bom.append(indent).append("        <![CDATA[").append(pom.getDescription()).append("]]>\n");
            bom.append(indent).append("    </description>\n");
        }
        if (scope != null) {
            String cycloneScope;
            switch (scope) {
                case Compile: 
                case System: {
                    cycloneScope = "required";
                    break;
                }
                case None: 
                case Invalid: 
                case Test: {
                    cycloneScope = "excluded";
                    break;
                }
                default: {
                    cycloneScope = "optional";
                }
            }
            bom.append(indent).append("    <scope>").append(cycloneScope).append("</scope>\n");
        }
        PrintMavenAsCycloneDxBom.writeLicenses(pom, bom, indent);
        bom.append(indent).append("    <purl>").append(bomReference).append("</purl>\n");
        bom.append(indent).append("</component>\n");
    }

    private static void writeLicenses(Pom pom, StringBuilder bom, String indent) {
        if (!pom.getLicenses().isEmpty()) {
            bom.append(indent).append("    <licenses>\n");
            for (Pom.License license : pom.getLicenses()) {
                bom.append(indent).append("        <license>\n");
                String spdxId = null;
                if (license.getType() == Pom.LicenseType.Apache2) {
                    spdxId = "Apache-2.0";
                }
                if (spdxId != null) {
                    bom.append(indent).append("            <id>").append(spdxId).append("</id>\n");
                }
                bom.append(indent).append("            <name>").append(license.getName()).append("</name>\n");
                bom.append(indent).append("        </license>\n");
            }
            bom.append(indent).append("      </licenses>\n");
        }
    }

    private static String getBomReference(String group, String artifactId, String version) {
        return "pkg:maven/" + group + "/" + artifactId + "@" + version + "?type=jar";
    }

    private static Map<DependencyKey, Pom.Dependency> traverseDependencies(Collection<Pom.Dependency> dependencies, Map<DependencyKey, Pom.Dependency> dependencyMap) {
        if (dependencies == null) {
            return dependencyMap;
        }
        dependencies.stream().filter(PrintMavenAsCycloneDxBom::isDependencyInScope).forEach(d -> {
            DependencyKey key = PrintMavenAsCycloneDxBom.getDependencyKey(d);
            if (!dependencyMap.containsKey(key)) {
                dependencyMap.put(key, (Pom.Dependency)d);
                PrintMavenAsCycloneDxBom.traverseDependencies(d.getModel().getDependencies(), dependencyMap);
            }
        });
        return dependencyMap;
    }

    private static boolean isDependencyInScope(Pom.Dependency dependency) {
        return !dependency.isOptional() && dependency.getScope() != Scope.Test;
    }

    private static DependencyKey getDependencyKey(Pom.Dependency dependency) {
        return new DependencyKey(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getExclusions());
    }

    static final class DependencyKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<GroupArtifact> exclusions;

        public DependencyKey(String groupId, String artifactId, String version, Set<GroupArtifact> exclusions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.exclusions = exclusions;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyKey)) {
                return false;
            }
            DependencyKey other = (DependencyKey)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "PrintMavenAsCycloneDxBom.DependencyKey(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", exclusions=" + this.getExclusions() + ")";
        }
    }
}

