/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class ChangeDependencyScope
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava")
    private final String artifactId;
    @Option(displayName="New scope", description="Scope to apply to specified Maven dependency. May be omitted, which indicates that no scope should be added and any existing scope be removed from the dependency.", valid={"compile", "test", "runtime", "provided"}, required=false)
    @Nullable
    private final String newScope;

    public String getDisplayName() {
        return "Change Maven dependency scope";
    }

    public String getDescription() {
        return "Add or alter the scope of the specified dependency";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeDependencyScopeVisitor();
    }

    public ChangeDependencyScope(String groupId, String artifactId, @Nullable String newScope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newScope = newScope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getNewScope() {
        return this.newScope;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyScope(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newScope=" + this.getNewScope() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyScope)) {
            return false;
        }
        ChangeDependencyScope other = (ChangeDependencyScope)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newScope = this.getNewScope();
        String other$newScope = other.getNewScope();
        return !(this$newScope == null ? other$newScope != null : !this$newScope.equals(other$newScope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyScope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newScope = this.getNewScope();
        result = result * 59 + ($newScope == null ? 43 : $newScope.hashCode());
        return result;
    }

    private class ChangeDependencyScopeVisitor
    extends MavenVisitor {
        private ChangeDependencyScopeVisitor() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isDependencyTag() && ChangeDependencyScope.this.groupId.equals(tag.getChildValue("groupId").orElse(this.model.getGroupId())) && ChangeDependencyScope.this.artifactId.equals(tag.getChildValue("artifactId").orElse(null))) {
                Optional scope = tag.getChild("scope");
                if (scope.isPresent()) {
                    if (ChangeDependencyScope.this.newScope == null) {
                        this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)scope.get(), false));
                    } else if (!ChangeDependencyScope.this.newScope.equals(((Xml.Tag)scope.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)scope.get(), ChangeDependencyScope.this.newScope));
                    }
                } else {
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, Xml.Tag.build((String)("<scope>" + ChangeDependencyScope.this.newScope + "</scope>"))));
                }
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }
}

