/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import org.openrewrite.internal.lang.Nullable;

public enum Scope {
    None,
    Compile,
    Provided,
    Runtime,
    Test,
    System;


    public boolean isInClasspathOf(@Nullable Scope scope) {
        return this.transitiveOf(scope) == scope;
    }

    @Nullable
    public Scope transitiveOf(@Nullable Scope scope) {
        if (scope == null) {
            return this;
        }
        switch (scope) {
            case None: {
                return this;
            }
            case Compile: {
                switch (this) {
                    case Compile: {
                        return Compile;
                    }
                    case Runtime: {
                        return Runtime;
                    }
                }
                return null;
            }
            case Provided: {
                switch (this) {
                    case Compile: 
                    case Runtime: {
                        return Provided;
                    }
                }
                return null;
            }
            case Runtime: {
                switch (this) {
                    case Compile: 
                    case Runtime: {
                        return Runtime;
                    }
                }
                return null;
            }
            case Test: {
                switch (this) {
                    case Compile: 
                    case Runtime: 
                    case Test: {
                        return Test;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static Scope fromName(@Nullable String scope) {
        if (scope == null) {
            return Compile;
        }
        switch (scope.toLowerCase()) {
            case "compile": {
                return Compile;
            }
            case "provided": {
                return Provided;
            }
            case "runtime": {
                return Runtime;
            }
            case "test": {
                return Test;
            }
            case "system": {
                return System;
            }
        }
        throw new IllegalArgumentException("unsupported scope '" + scope + "'");
    }
}

