/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class RawMaven {
    private static final ObjectMapper xmlMapper;
    private final Xml.Document document;
    private final RawPom pom;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawMaven rawMaven = (RawMaven)o;
        return this.getSourcePath().equals(rawMaven.getSourcePath());
    }

    @JsonIgnore
    public Path getSourcePath() {
        return this.document.getSourcePath();
    }

    public int hashCode() {
        return Objects.hash(this.getSourcePath());
    }

    public String toString() {
        return "RawMaven{pom=" + this.pom + '}';
    }

    public static RawMaven parse(Parser.Input source, @Nullable Path relativeTo, @Nullable String snapshotVersion) {
        Xml.Document document = (Xml.Document)new MavenXmlParser().parseInputs(Collections.singletonList(source), relativeTo).iterator().next();
        try {
            RawPom pom = (RawPom)xmlMapper.readValue(source.getSource(), RawPom.class);
            if (snapshotVersion != null) {
                pom = pom.withSnapshotVersion(snapshotVersion);
            }
            return new RawMaven(document, pom);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse " + source.getPath(), e);
        }
    }

    public Map<String, String> getActiveProperties(Collection<String> activeProfiles) {
        return this.pom.getActiveProperties(activeProfiles);
    }

    public List<RawPom.Dependency> getActiveDependencies(Collection<String> activeProfiles) {
        return this.pom.getActiveDependencies(activeProfiles);
    }

    @ConstructorProperties(value={"document", "pom"})
    public RawMaven(Xml.Document document, RawPom pom) {
        this.document = document;
        this.pom = pom;
    }

    public Xml.Document getDocument() {
        return this.document;
    }

    public RawPom getPom() {
        return this.pom;
    }

    public RawMaven withPom(RawPom pom) {
        return this.pom == pom ? this : new RawMaven(this.document, pom);
    }

    static {
        WstxInputFactory input = new WstxInputFactory();
        input.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        input.setProperty("javax.xml.stream.isNamespaceAware", false);
        xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)input, (XMLOutputFactory)new WstxOutputFactory())).disable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).disable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    private static class MavenXmlParser
    extends XmlParser {
        private MavenXmlParser() {
        }

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    }
}

