/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlParser;

public class MavenMetadata {
    private static final ObjectMapper xmlMapper = new XmlMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final XmlParser xmlParser = new XmlParser(){

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    };
    public static final MavenMetadata EMPTY = new MavenMetadata(new Versioning(Collections.emptyList(), null));
    private final Versioning versioning;

    public static MavenMetadata parse(byte[] document) {
        try {
            return (MavenMetadata)xmlMapper.readValue(document, MavenMetadata.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @ConstructorProperties(value={"versioning"})
    public MavenMetadata(Versioning versioning) {
        this.versioning = versioning;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenMetadata)) {
            return false;
        }
        MavenMetadata other = (MavenMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Versioning this$versioning = this.getVersioning();
        Versioning other$versioning = other.getVersioning();
        return !(this$versioning == null ? other$versioning != null : !((Object)this$versioning).equals(other$versioning));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Versioning $versioning = this.getVersioning();
        result = result * 59 + ($versioning == null ? 43 : ((Object)$versioning).hashCode());
        return result;
    }

    public String toString() {
        return "MavenMetadata(versioning=" + this.getVersioning() + ")";
    }

    public static class Snapshot {
        private final String timestamp;
        private final String buildNumber;

        @ConstructorProperties(value={"timestamp", "buildNumber"})
        public Snapshot(String timestamp, String buildNumber) {
            this.timestamp = timestamp;
            this.buildNumber = buildNumber;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Snapshot)) {
                return false;
            }
            Snapshot other = (Snapshot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            String this$buildNumber = this.getBuildNumber();
            String other$buildNumber = other.getBuildNumber();
            return !(this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Snapshot;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            String $buildNumber = this.getBuildNumber();
            result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
            return result;
        }

        public String toString() {
            return "MavenMetadata.Snapshot(timestamp=" + this.getTimestamp() + ", buildNumber=" + this.getBuildNumber() + ")";
        }
    }

    public static class Versioning {
        private final Collection<String> versions;
        @Nullable
        private final Snapshot snapshot;

        @ConstructorProperties(value={"versions", "snapshot"})
        public Versioning(Collection<String> versions, Snapshot snapshot) {
            this.versions = versions;
            this.snapshot = snapshot;
        }

        public Collection<String> getVersions() {
            return this.versions;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Versioning)) {
                return false;
            }
            Versioning other = (Versioning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<String> this$versions = this.getVersions();
            Collection<String> other$versions = other.getVersions();
            if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
                return false;
            }
            Snapshot this$snapshot = this.getSnapshot();
            Snapshot other$snapshot = other.getSnapshot();
            return !(this$snapshot == null ? other$snapshot != null : !((Object)this$snapshot).equals(other$snapshot));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Versioning;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<String> $versions = this.getVersions();
            result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
            Snapshot $snapshot = this.getSnapshot();
            result = result * 59 + ($snapshot == null ? 43 : ((Object)$snapshot).hashCode());
            return result;
        }

        public String toString() {
            return "MavenMetadata.Versioning(versions=" + this.getVersions() + ", snapshot=" + this.getSnapshot() + ")";
        }
    }
}

